/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.model;

import java.util.ArrayList;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.ICDescriptor;
import org.eclipse.cdt.core.ICPathEntry;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.IArchiveContainer;
import org.eclipse.cdt.core.model.IBinaryContainer;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.ILibraryReference;
import org.eclipse.cdt.internal.core.model.CContainer;
import org.eclipse.cdt.internal.core.model.CElementInfo;
import org.eclipse.cdt.internal.core.model.CModelManager;
import org.eclipse.cdt.internal.core.model.CModelStatus;
import org.eclipse.cdt.internal.core.model.CProjectInfo;
import org.eclipse.cdt.internal.core.model.LibraryReference;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;

public class CProject
extends CContainer
implements ICProject {
    public CProject(ICElement parent, IProject project) {
        super(parent, (IResource)project, 11);
    }

    public IBinaryContainer getBinaryContainer() {
        return ((CProjectInfo)this.getElementInfo()).getBinaryContainer();
    }

    public IArchiveContainer getArchiveContainer() {
        return ((CProjectInfo)this.getElementInfo()).getArchiveContainer();
    }

    public IProject getProject() {
        try {
            return this.getUnderlyingResource().getProject();
        }
        catch (CModelException e) {
            e.printStackTrace();
            return null;
        }
    }

    public ICElement findElement(IPath path) throws CModelException {
        ICElement celem = null;
        if (path.isAbsolute()) {
            celem = CModelManager.getDefault().create(path);
        } else {
            IProject project = this.getProject();
            if (project != null) {
                IPath p = project.getFullPath().append(path);
                celem = CModelManager.getDefault().create(p);
            }
        }
        if (celem == null) {
            CModelStatus status = new CModelStatus(979, path);
            throw new CModelException(status);
        }
        return celem;
    }

    public static boolean hasCNature(IProject p) {
        try {
            return p.hasNature("org.eclipse.cdt.core.cnature");
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    protected CElementInfo createElementInfo() {
        return new CProjectInfo(this);
    }

    public int hashCode() {
        return this.getProject().hashCode();
    }

    public ILibraryReference[] getLibraryReferences() throws CModelException {
        ArrayList<LibraryReference> list = new ArrayList<LibraryReference>(5);
        try {
            ICDescriptor cdesc = CCorePlugin.getDefault().getCProjectDescription(this.getProject());
            ICPathEntry[] entries = cdesc.getPathEntries();
            int i = 0;
            while (i < entries.length) {
                if (entries[i].getEntryKind() == 1) {
                    ICPathEntry entry = entries[i];
                    list.add(new LibraryReference((ICElement)this, entry.getPath().lastSegment(), entry));
                }
                ++i;
            }
        }
        catch (CoreException e) {
            throw new CModelException(e);
        }
        return list.toArray(new ILibraryReference[0]);
    }
}

