/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.model;

import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICElementDelta;
import org.eclipse.cdt.core.model.ICModel;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.IParent;
import org.eclipse.cdt.internal.core.model.CContainer;
import org.eclipse.cdt.internal.core.model.CContainerInfo;
import org.eclipse.cdt.internal.core.model.CElement;
import org.eclipse.cdt.internal.core.model.CElementDelta;
import org.eclipse.cdt.internal.core.model.CElementInfo;
import org.eclipse.cdt.internal.core.model.CModelManager;
import org.eclipse.cdt.internal.core.model.Openable;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.runtime.IPath;

public class DeltaProcessor {
    protected CElementDelta fCurrentDelta;
    ICElement currentElement;
    static final ICElementDelta[] NO_DELTA = new ICElementDelta[0];
    public static boolean VERBOSE = false;
    ICElement movedFromElement = null;

    protected ICElement createElement(IResource resource) {
        ICElement parent;
        CModelManager manager = CModelManager.getDefault();
        if (resource == null) {
            return null;
        }
        ICElement celement = manager.create(resource);
        if (celement == null && (parent = manager.create((IResource)resource.getParent())) instanceof IParent) {
            IResource res;
            int i;
            ICElement bin;
            ICProject cproj;
            ICElement[] children = ((CElement)parent).getElementInfo().getChildren();
            int i2 = 0;
            while (i2 < children.length) {
                IResource res2 = children[i2].getResource();
                if (res2 != null && res2.equals((Object)resource)) {
                    celement = children[i2];
                    break;
                }
                ++i2;
            }
            if (celement == null && (cproj = parent.getCProject()) != null) {
                bin = cproj.getBinaryContainer();
                children = ((CElement)bin).getElementInfo().getChildren();
                i = 0;
                while (i < children.length) {
                    res = children[i].getResource();
                    if (res != null && res.equals((Object)resource)) {
                        celement = children[i];
                        break;
                    }
                    ++i;
                }
            }
            if (celement == null && (cproj = parent.getCProject()) != null) {
                bin = cproj.getArchiveContainer();
                children = ((CElement)bin).getElementInfo().getChildren();
                i = 0;
                while (i < children.length) {
                    res = children[i].getResource();
                    if (res != null && res.equals((Object)resource)) {
                        celement = children[i];
                        break;
                    }
                    ++i;
                }
            }
        }
        return celement;
    }

    protected ICElement createElement(IPath path) {
        return CModelManager.getDefault().create(path);
    }

    protected void releaseCElement(ICElement celement) {
        CModelManager.getDefault().releaseCElement(celement);
    }

    protected void addToParentInfo(Openable child) {
        Openable parent = (Openable)child.getParent();
        if (parent != null && parent.isOpen()) {
            CElementInfo info = parent.getElementInfo();
            info.addChild(child);
        }
    }

    protected void elementAdded(ICElement element, IResourceDelta delta) {
        if (element instanceof Openable) {
            this.addToParentInfo((Openable)element);
        }
        if ((delta.getFlags() & 0x1000) != 0) {
            if (this.movedFromElement == null) {
                this.movedFromElement = this.createElement(delta.getMovedFromPath());
            }
            this.fCurrentDelta.movedTo(element, this.movedFromElement);
            this.movedFromElement = null;
        } else {
            this.fCurrentDelta.added(element);
        }
    }

    protected void elementClosed(ICElement element, IResourceDelta delta) {
        if (element.getElementType() == 11) {
            this.elementRemoved(element, delta);
        } else {
            this.fCurrentDelta.closed(element);
        }
    }

    protected void elementOpened(ICElement element, IResourceDelta delta) {
        if (element.getElementType() == 11) {
            if (this.hasCNature(delta.getResource())) {
                this.elementAdded(element, delta);
            }
        } else {
            this.fCurrentDelta.opened(element);
        }
    }

    private void close(Openable element) {
        try {
            element.close();
        }
        catch (CModelException cModelException) {}
    }

    protected void elementChanged(ICElement element, IResourceDelta delta) {
        if (element instanceof Openable) {
            this.close((Openable)element);
        }
        this.fCurrentDelta.changed(element, 1);
    }

    protected void elementRemoved(ICElement element, IResourceDelta delta) {
        if ((delta.getFlags() & 0x2000) != 0) {
            IPath movedToPath = delta.getMovedToPath();
            ICElement movedToElement = this.createElement(movedToPath);
            if (movedToElement == null) {
                this.fCurrentDelta.removed(element);
            } else {
                this.movedFromElement = element;
                this.fCurrentDelta.movedFrom(element, movedToElement);
            }
        } else {
            this.fCurrentDelta.removed(element);
        }
        this.releaseCElement(element);
    }

    protected ICElementDelta[] filterRealDeltas(ICElementDelta[] deltas) {
        int length = deltas.length;
        ICElementDelta[] realDeltas = null;
        int index = 0;
        int i = 0;
        while (i < length) {
            CElementDelta delta = (CElementDelta)deltas[i];
            if (delta != null && (delta.getAffectedChildren().length > 0 || delta.getKind() == 1 || delta.getKind() == 2 || (delta.getFlags() & 0x400) != 0 || (delta.getFlags() & 0x200) != 0 || delta.resourceDeltasCounter > 0)) {
                if (realDeltas == null) {
                    realDeltas = new ICElementDelta[length];
                }
                realDeltas[index++] = delta;
            }
            ++i;
        }
        if (index > 0) {
            ICElementDelta[] result = new ICElementDelta[index];
            System.arraycopy(realDeltas, 0, result, 0, index);
            return result;
        }
        return NO_DELTA;
    }

    protected boolean hasCNature(IResource resource) {
        IProject project = resource.getProject();
        if (project.isOpen()) {
            return CoreModel.getDefault().hasCNature(project);
        }
        return false;
    }

    public ICElementDelta[] processResourceDelta(IResourceDelta changes) {
        ICModel root = CModelManager.getDefault().getCModel();
        IResourceDelta[] deltas = changes.getAffectedChildren();
        ICElementDelta[] translatedDeltas = new CElementDelta[deltas.length];
        int i = 0;
        while (i < deltas.length) {
            IResourceDelta delta = deltas[i];
            this.fCurrentDelta = new CElementDelta(root);
            this.traverseDelta(root, delta);
            translatedDeltas[i] = this.fCurrentDelta;
            ++i;
        }
        return this.filterRealDeltas(translatedDeltas);
    }

    protected void traverseDelta(ICElement parent, IResourceDelta delta) {
        try {
            ICElement current = this.updateCurrentDeltaAndIndex(delta);
            if (current == null) {
                this.nonCResourcesChanged(parent, delta);
            } else {
                parent = current;
            }
        }
        catch (CModelException cModelException) {}
        IResourceDelta[] children = delta.getAffectedChildren();
        int i = 0;
        while (i < children.length) {
            this.traverseDelta(parent, children[i]);
            ++i;
        }
    }

    protected void nonCResourcesChanged(ICElement parent, IResourceDelta delta) {
        CElementInfo info;
        CElementDelta elementDelta = this.fCurrentDelta.find(parent);
        if (elementDelta == null) {
            this.fCurrentDelta.changed(parent, 1);
        } else {
            elementDelta.addResourceDelta(delta);
        }
        if (parent instanceof CContainer && (info = ((CContainer)parent).getElementInfo()) instanceof CContainerInfo) {
            ((CContainerInfo)info).setNonCResources(null);
        }
    }

    private ICElement updateCurrentDeltaAndIndex(IResourceDelta delta) throws CModelException {
        IResource resource = delta.getResource();
        ICElement element = this.createElement(resource);
        switch (delta.getKind()) {
            case 1: {
                if (element == null) break;
                this.updateIndexAddResource(element, delta);
                this.elementAdded(element, delta);
                break;
            }
            case 2: {
                if (element == null) break;
                this.updateIndexRemoveResource(element, delta);
                this.elementRemoved(element, delta);
                break;
            }
            case 4: {
                int flags = delta.getFlags();
                if ((flags & 0x100) != 0) {
                    if (element == null) break;
                    this.elementChanged(element, delta);
                    this.updateIndexAddResource(element, delta);
                    break;
                }
                if (resource.getType() == 4) {
                    if ((flags & 0x4000) != 0) {
                        IProject res = (IProject)resource;
                        if (element == null) break;
                        if (res.isOpen()) {
                            this.elementOpened(element, delta);
                            this.updateIndexAddResource(element, delta);
                            break;
                        }
                        this.elementClosed(element, delta);
                        this.updateIndexRemoveResource(element, delta);
                        break;
                    }
                    if ((flags & 0x80000) != 0) {
                        if (element == null) break;
                        this.elementAdded(element, delta);
                        break;
                    }
                    if (element == null) break;
                    this.elementChanged(element, delta);
                    break;
                }
                if (element == null) break;
                this.elementChanged(element, delta);
            }
        }
        return element;
    }

    protected void updateIndexAddResource(ICElement element, IResourceDelta delta) {
    }

    protected void updateIndexRemoveResource(ICElement element, IResourceDelta delta) {
    }
}

