/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.utils.spawner;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Properties;
import java.util.Vector;
import org.eclipse.cdt.utils.spawner.ProcessFactory;

public class EnvironmentReader {
    private static Properties envVars = null;
    private static Vector rawVars = null;

    public static Properties getEnvVars() {
        if (envVars != null) {
            return envVars;
        }
        String OS = System.getProperty("os.name").toLowerCase();
        Process p = null;
        envVars = new Properties();
        rawVars = new Vector(32);
        String command = "env";
        InputStream in = null;
        boolean check_ready = false;
        try {
            try {
                String line;
                if (OS.indexOf("windows 9") > -1) {
                    command = "command.com /c set";
                    check_ready = true;
                } else if (OS.indexOf("nt") > -1 || OS.indexOf("windows 2000") > -1 || OS.indexOf("windows xp") > -1) {
                    command = "cmd.exe /c set";
                }
                p = ProcessFactory.getFactory().exec(command);
                in = p.getInputStream();
                BufferedReader br = new BufferedReader(new InputStreamReader(in));
                while ((line = br.readLine()) != null) {
                    rawVars.add(line);
                    int idx = line.indexOf(61);
                    if (idx != -1) {
                        String key = line.substring(0, idx);
                        String value = line.substring(idx + 1);
                        envVars.setProperty(key, value);
                    } else {
                        envVars.setProperty(line, "");
                    }
                    if (!check_ready || br.ready()) {
                        continue;
                    }
                    break;
                }
            }
            catch (IOException iOException) {}
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException iOException) {}
            try {
                if (p != null) {
                    p.waitFor();
                }
            }
            catch (InterruptedException interruptedException) {}
            throw throwable;
        }
        Object var10_12 = null;
        try {
            if (in != null) {
                in.close();
            }
        }
        catch (IOException iOException) {}
        try {
            if (p != null) {
                p.waitFor();
            }
        }
        catch (InterruptedException interruptedException) {}
        rawVars.trimToSize();
        return envVars;
    }

    public static String getEnvVar(String key) {
        Properties p = EnvironmentReader.getEnvVars();
        return p.getProperty(key);
    }

    public static String[] getRawEnvVars() {
        EnvironmentReader.getEnvVars();
        return rawVars.toArray(new String[0]);
    }
}

