/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core.cdi.event;

import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.event.ICDIChangedEvent;
import org.eclipse.cdt.debug.core.cdi.model.ICDIObject;
import org.eclipse.cdt.debug.core.cdi.model.ICDISharedLibrary;
import org.eclipse.cdt.debug.core.cdi.model.ICDISignal;
import org.eclipse.cdt.debug.mi.core.cdi.BreakpointManager;
import org.eclipse.cdt.debug.mi.core.cdi.ExpressionManager;
import org.eclipse.cdt.debug.mi.core.cdi.RegisterManager;
import org.eclipse.cdt.debug.mi.core.cdi.Session;
import org.eclipse.cdt.debug.mi.core.cdi.SharedLibraryManager;
import org.eclipse.cdt.debug.mi.core.cdi.SignalManager;
import org.eclipse.cdt.debug.mi.core.cdi.VariableManager;
import org.eclipse.cdt.debug.mi.core.cdi.model.Breakpoint;
import org.eclipse.cdt.debug.mi.core.cdi.model.CObject;
import org.eclipse.cdt.debug.mi.core.cdi.model.Register;
import org.eclipse.cdt.debug.mi.core.cdi.model.Variable;
import org.eclipse.cdt.debug.mi.core.event.MIBreakpointChangedEvent;
import org.eclipse.cdt.debug.mi.core.event.MIRegisterChangedEvent;
import org.eclipse.cdt.debug.mi.core.event.MISharedLibChangedEvent;
import org.eclipse.cdt.debug.mi.core.event.MISignalChangedEvent;
import org.eclipse.cdt.debug.mi.core.event.MIVarChangedEvent;

public class ChangedEvent
implements ICDIChangedEvent {
    Session session;
    ICDIObject source;

    public ChangedEvent(Session s, MIVarChangedEvent var) {
        ExpressionManager expMgr;
        this.session = s;
        VariableManager mgr = (VariableManager)this.session.getVariableManager();
        String varName = var.getVarName();
        Variable variable = mgr.getVariable(varName);
        this.source = variable != null ? variable : ((variable = (expMgr = (ExpressionManager)this.session.getExpressionManager()).getExpression(varName)) != null ? variable : new CObject(this.session.getCurrentTarget()));
    }

    public ChangedEvent(Session s, MIRegisterChangedEvent var) {
        this.session = s;
        RegisterManager mgr = (RegisterManager)this.session.getRegisterManager();
        int regno = var.getNumber();
        Register reg = null;
        try {
            reg = mgr.getRegister(regno);
        }
        catch (CDIException cDIException) {}
        this.source = reg != null ? reg : new CObject(this.session.getCurrentTarget());
    }

    public ChangedEvent(Session s, MIBreakpointChangedEvent bpoint) {
        this.session = s;
        BreakpointManager mgr = (BreakpointManager)this.session.getBreakpointManager();
        int number = bpoint.getNumber();
        Breakpoint breakpoint = mgr.getBreakpoint(number);
        this.source = breakpoint != null ? breakpoint : new CObject(this.session.getCurrentTarget());
    }

    public ChangedEvent(Session s, MISharedLibChangedEvent slib) {
        this.session = s;
        SharedLibraryManager mgr = (SharedLibraryManager)this.session.getSharedLibraryManager();
        String name = slib.getName();
        ICDISharedLibrary lib = mgr.getSharedLibrary(name);
        this.source = lib != null ? lib : new CObject(this.session.getCurrentTarget());
    }

    public ChangedEvent(Session s, MISignalChangedEvent sig) {
        this.session = s;
        SignalManager mgr = (SignalManager)this.session.getSignalManager();
        String name = sig.getName();
        ICDISignal signal = mgr.getSignal(name);
        this.source = signal != null ? signal : new CObject(this.session.getCurrentTarget());
    }

    public ChangedEvent(Session s, ICDIObject src) {
        this.session = s;
        this.source = src;
    }

    public ICDIObject getSource() {
        return this.source;
    }
}

