/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.internal.ui;

import org.eclipse.cdt.debug.mi.core.IGDBServerMILaunchConfigurationConstants;
import org.eclipse.cdt.debug.mi.core.IMILaunchConfigurationConstants;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class GDBServerDebuggerPage
extends AbstractLaunchConfigurationTab {
    protected Text fDebuggerCommandText;
    protected Button fTCPButton;
    protected Button fAsyncButton;
    protected Text fHostText;
    protected Text fHostPort;
    protected Text fAsyncDev;
    private Button fAutoSoLibButton;

    public void createControl(Composite parent) {
        Composite comp = new Composite(parent, 0);
        GridLayout topLayout = new GridLayout();
        topLayout.numColumns = 2;
        comp.setLayout((Layout)topLayout);
        GridData gd = new GridData(768);
        comp.setLayoutData((Object)gd);
        this.setControl((Control)comp);
        this.createVerticalSpacer(comp, 2);
        Label debugCommandLabel = new Label(comp, 0);
        debugCommandLabel.setText("GDBServer gdb executable:");
        this.fDebuggerCommandText = new Text(comp, 2052);
        gd = new GridData(768);
        this.fDebuggerCommandText.setLayoutData((Object)gd);
        this.fDebuggerCommandText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent evt) {
                GDBServerDebuggerPage.this.updateLaunchConfigurationDialog();
            }
        });
        Composite radioComp = new Composite(comp, 0);
        GridLayout radioLayout = new GridLayout(2, true);
        radioLayout.marginHeight = 0;
        radioLayout.marginWidth = 0;
        radioComp.setLayout((Layout)radioLayout);
        gd = new GridData();
        gd.horizontalSpan = 2;
        radioComp.setLayoutData((Object)gd);
        this.fTCPButton = this.createRadioButton(radioComp, "Connect using TCP");
        this.fTCPButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean isTcp = GDBServerDebuggerPage.this.fTCPButton.getSelection();
                GDBServerDebuggerPage.this.fHostPort.setEnabled(isTcp);
                GDBServerDebuggerPage.this.fHostText.setEnabled(isTcp);
                GDBServerDebuggerPage.this.updateLaunchConfigurationDialog();
            }
        });
        this.fAsyncButton = this.createRadioButton(radioComp, "Connect using a serial port");
        this.fAsyncButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GDBServerDebuggerPage.this.fAsyncDev.setEnabled(GDBServerDebuggerPage.this.fAsyncButton.getSelection());
                GDBServerDebuggerPage.this.updateLaunchConfigurationDialog();
            }
        });
        Label hostTextLabel = new Label(comp, 0);
        hostTextLabel.setText("GDBServer TCP host:");
        this.fHostText = new Text(comp, 2052);
        gd = new GridData(768);
        this.fHostText.setLayoutData((Object)gd);
        this.fHostText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent evt) {
                GDBServerDebuggerPage.this.updateLaunchConfigurationDialog();
            }
        });
        Label hostPortLabel = new Label(comp, 0);
        hostPortLabel.setText("GDBServer TCP port:");
        this.fHostPort = new Text(comp, 2052);
        gd = new GridData(768);
        this.fHostPort.setLayoutData((Object)gd);
        this.fHostPort.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent evt) {
                GDBServerDebuggerPage.this.updateLaunchConfigurationDialog();
            }
        });
        Label asyncDevLabel = new Label(comp, 0);
        asyncDevLabel.setText("Serial device:");
        this.fAsyncDev = new Text(comp, 2052);
        gd = new GridData(768);
        this.fAsyncDev.setLayoutData((Object)gd);
        this.fAsyncDev.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent evt) {
                GDBServerDebuggerPage.this.updateLaunchConfigurationDialog();
            }
        });
        this.fTCPButton.setSelection(true);
        this.fAsyncButton.setSelection(false);
        this.fHostText.setEnabled(true);
        this.fHostPort.setEnabled(true);
        this.fAsyncDev.setEnabled(false);
        this.fHostPort.setEnabled(true);
        this.fHostText.setEnabled(true);
        this.fAsyncDev.setEnabled(false);
        this.createVerticalSpacer(comp, 2);
        this.fAutoSoLibButton = new Button(comp, 32);
        this.fAutoSoLibButton.setText("Load shared library symbols automatically");
        gd = new GridData();
        gd.horizontalSpan = 2;
        this.fAutoSoLibButton.setLayoutData((Object)gd);
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        String attr = null;
        try {
            attr = configuration.getAttribute(IMILaunchConfigurationConstants.ATTR_DEBUG_NAME, null);
        }
        catch (CoreException coreException) {}
        if (attr == null) {
            configuration.setAttribute(IMILaunchConfigurationConstants.ATTR_DEBUG_NAME, "gdb");
        }
        attr = null;
        try {
            attr = configuration.getAttribute(IGDBServerMILaunchConfigurationConstants.ATTR_HOST, null);
        }
        catch (CoreException coreException) {}
        if (attr == null) {
            configuration.setAttribute(IGDBServerMILaunchConfigurationConstants.ATTR_HOST, "");
        }
        attr = null;
        try {
            attr = configuration.getAttribute(IGDBServerMILaunchConfigurationConstants.ATTR_PORT, null);
        }
        catch (CoreException coreException) {}
        if (attr == null) {
            configuration.setAttribute(IGDBServerMILaunchConfigurationConstants.ATTR_PORT, "");
        }
        attr = null;
        try {
            attr = configuration.getAttribute(IGDBServerMILaunchConfigurationConstants.ATTR_DEV, null);
        }
        catch (CoreException coreException) {}
        if (attr == null) {
            configuration.setAttribute(IGDBServerMILaunchConfigurationConstants.ATTR_DEV, "/dev/ttyS0");
        }
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        boolean valid = this.fDebuggerCommandText.getText().length() != 0;
        this.setErrorMessage(null);
        this.setMessage(null);
        if (!valid) {
            this.setErrorMessage("Debugger executable must be specified");
            this.setMessage(null);
        }
        if (valid) {
            if (this.fTCPButton.getSelection()) {
                boolean bl = valid = this.fHostText.getText().length() != 0 && this.fHostPort.getText().length() != 0;
                if (!valid) {
                    this.setErrorMessage("If TCP is selected, host and port must be specified");
                    this.setMessage(null);
                }
            } else {
                boolean bl = valid = this.fAsyncDev.getText().length() != 0;
                if (!valid) {
                    this.setErrorMessage("If Async is selected, device must be specified");
                    this.setMessage(null);
                }
            }
        }
        return valid;
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        String debuggerCommand = "gdb";
        boolean isTcp = false;
        String hostText = "";
        String hostPort = "";
        String asyncDev = "/dev/ttyS0";
        boolean autosolib = false;
        try {
            debuggerCommand = configuration.getAttribute(IMILaunchConfigurationConstants.ATTR_DEBUG_NAME, "gdb");
            autosolib = configuration.getAttribute(IMILaunchConfigurationConstants.ATTR_AUTO_SOLIB, false);
        }
        catch (CoreException coreException) {}
        try {
            isTcp = configuration.getAttribute(IGDBServerMILaunchConfigurationConstants.ATTR_REMOTE_TCP, false);
            hostText = configuration.getAttribute(IGDBServerMILaunchConfigurationConstants.ATTR_HOST, "");
            hostPort = configuration.getAttribute(IGDBServerMILaunchConfigurationConstants.ATTR_PORT, "");
            asyncDev = configuration.getAttribute(IGDBServerMILaunchConfigurationConstants.ATTR_DEV, "");
        }
        catch (CoreException coreException) {}
        this.fDebuggerCommandText.setText(debuggerCommand);
        this.fTCPButton.setSelection(isTcp);
        this.fAsyncButton.setSelection(!isTcp);
        this.fHostText.setText(hostText);
        this.fHostPort.setText(hostPort);
        this.fAsyncDev.setText(asyncDev);
        this.fHostText.setEnabled(isTcp);
        this.fHostPort.setEnabled(isTcp);
        this.fAsyncDev.setEnabled(!isTcp);
        this.fAutoSoLibButton.setSelection(autosolib);
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        String debuggerCommand = this.fDebuggerCommandText.getText();
        String hostText = this.fHostText.getText();
        String hostPort = this.fHostPort.getText();
        String asyncDev = this.fAsyncDev.getText();
        debuggerCommand.trim();
        hostText.trim();
        hostPort.trim();
        asyncDev.trim();
        configuration.setAttribute(IMILaunchConfigurationConstants.ATTR_DEBUG_NAME, debuggerCommand);
        configuration.setAttribute(IMILaunchConfigurationConstants.ATTR_AUTO_SOLIB, this.fAutoSoLibButton.getSelection());
        configuration.setAttribute(IGDBServerMILaunchConfigurationConstants.ATTR_REMOTE_TCP, this.fTCPButton.getSelection());
        configuration.setAttribute(IGDBServerMILaunchConfigurationConstants.ATTR_HOST, hostText);
        configuration.setAttribute(IGDBServerMILaunchConfigurationConstants.ATTR_PORT, hostPort);
        configuration.setAttribute(IGDBServerMILaunchConfigurationConstants.ATTR_DEV, asyncDev);
    }

    public String getName() {
        return "GDBServer Debugger Options";
    }

    protected void updateLaunchConfigurationDialog() {
        super.updateLaunchConfigurationDialog();
    }
}

