/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui;

import org.eclipse.cdt.core.model.IBinary;
import org.eclipse.cdt.core.model.IBinaryModule;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.IDeclaration;
import org.eclipse.cdt.core.model.IField;
import org.eclipse.cdt.core.model.ILibraryReference;
import org.eclipse.cdt.core.model.IMethodDeclaration;
import org.eclipse.cdt.core.model.ITemplate;
import org.eclipse.cdt.internal.ui.CPluginImages;
import org.eclipse.cdt.internal.ui.util.ImageDescriptorRegistry;
import org.eclipse.cdt.ui.CElementImageDescriptor;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.model.IWorkbenchAdapter;

public class CElementImageProvider {
    public static final int OVERLAY_ICONS = 1;
    public static final int SMALL_ICONS = 2;
    public static final int LIGHT_TYPE_ICONS = 4;
    public static final int OVERLAY_ERROR = 8;
    public static final int OVERLAY_WARNING = 16;
    public static final int OVERLAY_OVERRIDE = 32;
    public static final int OVERLAY_IMPLEMENTS = 64;
    private static final Point SMALL_SIZE = new Point(16, 16);
    private static final Point BIG_SIZE = new Point(22, 16);
    private static ImageDescriptor DESC_OBJ_PROJECT_CLOSED;
    private static ImageDescriptor DESC_OBJ_PROJECT;
    private static ImageDescriptor DESC_OBJ_FOLDER;
    private ImageDescriptorRegistry fRegistry;
    static /* synthetic */ Class class$0;

    public CElementImageProvider() {
        ISharedImages images = CUIPlugin.getDefault().getWorkbench().getSharedImages();
        DESC_OBJ_PROJECT_CLOSED = images.getImageDescriptor("IMG_OBJ_PROJECT_CLOSED");
        DESC_OBJ_PROJECT = images.getImageDescriptor("IMG_OBJ_PROJECT");
        DESC_OBJ_FOLDER = images.getImageDescriptor("IMG_OBJ_FOLDER");
        this.fRegistry = CUIPlugin.getImageDescriptorRegistry();
    }

    public Image getImageLabel(Object element, int flags) {
        ImageDescriptor descriptor = null;
        if (element instanceof ICElement) {
            descriptor = this.getCImageDescriptor((ICElement)element, flags);
        }
        if (descriptor == null && element instanceof IAdaptable) {
            descriptor = this.getWorkbenchImageDescriptor((IAdaptable)element, flags);
        }
        if (descriptor != null) {
            return this.fRegistry.get(descriptor);
        }
        return null;
    }

    private boolean showOverlayIcons(int flags) {
        return (flags & 1) != 0;
    }

    private boolean useSmallSize(int flags) {
        return (flags & 2) != 0;
    }

    public ImageDescriptor getCImageDescriptor(ICElement element, int flags) {
        int adornmentFlags = this.computeCAdornmentFlags(element, flags);
        Point size = this.useSmallSize(flags) ? SMALL_SIZE : BIG_SIZE;
        ImageDescriptor desc = this.getBaseImageDescriptor(element, flags);
        if (desc != null) {
            return new CElementImageDescriptor(desc, adornmentFlags, size);
        }
        return null;
    }

    public ImageDescriptor getWorkbenchImageDescriptor(IAdaptable adaptable, int flags) {
        IWorkbenchAdapter wbAdapter;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.model.IWorkbenchAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((wbAdapter = (IWorkbenchAdapter)adaptable.getAdapter((Class)clazz)) == null) {
            return null;
        }
        ImageDescriptor descriptor = wbAdapter.getImageDescriptor((Object)adaptable);
        if (descriptor == null) {
            return null;
        }
        int adornmentFlags = this.computeBasicAdornmentFlags(adaptable, flags);
        Point size = this.useSmallSize(flags) ? SMALL_SIZE : BIG_SIZE;
        return new CElementImageDescriptor(descriptor, adornmentFlags, size);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ImageDescriptor getBaseImageDescriptor(ICElement celement, int renderFlags) {
        int type = celement.getElementType();
        switch (type) {
            case 30: {
                if (celement instanceof IBinaryModule) {
                    return CPluginImages.DESC_OBJS_BINARY;
                }
                if (!(celement instanceof ILibraryReference)) return CPluginImages.DESC_OBJS_CONTAINER;
                return CPluginImages.DESC_OBJS_LIBRARY;
            }
            case 14: {
                IBinary bin = (IBinary)celement;
                if (bin.isExecutable()) {
                    if (!bin.hasDebug()) return CPluginImages.DESC_OBJS_CEXEC;
                    return CPluginImages.DESC_OBJS_CEXEC_DEBUG;
                }
                if (bin.isSharedLib()) {
                    return CPluginImages.DESC_OBJS_SHLIB;
                }
                if (!bin.isCore()) return CPluginImages.DESC_OBJS_BINARY;
                return CPluginImages.DESC_OBJS_CORE;
            }
            case 18: {
                return CPluginImages.DESC_OBJS_ARCHIVE;
            }
            case 60: {
                return CPluginImages.DESC_OBJS_TUNIT;
            }
            case 12: {
                return DESC_OBJ_FOLDER;
            }
            case 11: {
                ImageDescriptor result;
                IWorkbenchAdapter adapter;
                ICProject cp = (ICProject)celement;
                if (!cp.getProject().isOpen()) return DESC_OBJ_PROJECT_CLOSED;
                IProject project = cp.getProject();
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.ui.model.IWorkbenchAdapter");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((adapter = (IWorkbenchAdapter)project.getAdapter((Class)clazz)) == null || (result = adapter.getImageDescriptor((Object)project)) == null) return DESC_OBJ_PROJECT;
                return result;
            }
            case 65: {
                return CPluginImages.DESC_OBJS_STRUCT;
            }
            case 64: 
            case 73: {
                return CPluginImages.DESC_OBJS_CLASS;
            }
            case 66: {
                return CPluginImages.DESC_OBJS_UNION;
            }
            case 78: {
                return CPluginImages.DESC_OBJS_TYPEDEF;
            }
            case 63: {
                return CPluginImages.DESC_OBJS_ENUMERATION;
            }
            case 79: {
                return CPluginImages.DESC_OBJS_ENUMERATOR;
            }
            case 69: {
                IField field = (IField)celement;
                switch (field.getVisibility()) {
                    case 2: {
                        return CPluginImages.DESC_OBJS_PUBLIC_FIELD;
                    }
                    case 1: {
                        return CPluginImages.DESC_OBJS_PROTECTED_FIELD;
                    }
                    case 0: {
                        return CPluginImages.DESC_OBJS_PRIVATE_FIELD;
                    }
                }
            }
            case 74: {
                return CPluginImages.DESC_OBJS_FIELD;
            }
            case 67: 
            case 68: 
            case 81: {
                IMethodDeclaration md = (IMethodDeclaration)celement;
                switch (md.getVisibility()) {
                    case 2: {
                        return CPluginImages.DESC_OBJS_PUBLIC_METHOD;
                    }
                    case 1: {
                        return CPluginImages.DESC_OBJS_PROTECTED_METHOD;
                    }
                    case 0: {
                        return CPluginImages.DESC_OBJS_PRIVATE_METHOD;
                    }
                }
            }
            case 71: {
                return CPluginImages.DESC_OBJS_FUNCTION;
            }
            case 75: {
                return CPluginImages.DESC_OBJS_VAR_DECLARARION;
            }
            case 70: 
            case 80: {
                return CPluginImages.DESC_OBJS_DECLARARION;
            }
            case 72: {
                return CPluginImages.DESC_OBJS_INCLUDE;
            }
            case 77: {
                return CPluginImages.DESC_OBJS_MACRO;
            }
            case 61: {
                return CPluginImages.DESC_OBJS_CONTAINER;
            }
        }
        return null;
    }

    private int computeCAdornmentFlags(ICElement element, int renderFlags) {
        int flags = this.computeBasicAdornmentFlags(element, renderFlags);
        if (this.showOverlayIcons(renderFlags) && element instanceof IDeclaration) {
            IDeclaration decl = (IDeclaration)element;
            if (decl.isStatic()) {
                flags |= 8;
            }
            if (decl.isConst()) {
                flags |= 2;
            }
            if (decl.isVolatile()) {
                flags |= 4;
            }
            if (element instanceof ITemplate) {
                flags |= 1;
            }
        }
        return flags;
    }

    private int computeBasicAdornmentFlags(Object element, int renderFlags) {
        int flags = 0;
        if ((renderFlags & 8) != 0) {
            flags |= 0x40;
        }
        if ((renderFlags & 0x10) != 0) {
            flags |= 0x20;
        }
        if ((renderFlags & 0x20) != 0) {
            flags |= 0x80;
        }
        if ((renderFlags & 0x40) != 0) {
            flags |= 0x100;
        }
        return flags;
    }

    public void dispose() {
    }
}

