/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.compare;

import java.util.Iterator;
import java.util.List;
import org.eclipse.cdt.internal.core.dom.ClassSpecifier;
import org.eclipse.cdt.internal.core.dom.DOMBuilder;
import org.eclipse.cdt.internal.core.dom.DOMFactory;
import org.eclipse.cdt.internal.core.dom.Declaration;
import org.eclipse.cdt.internal.core.dom.Declarator;
import org.eclipse.cdt.internal.core.dom.EnumerationSpecifier;
import org.eclipse.cdt.internal.core.dom.IOffsetable;
import org.eclipse.cdt.internal.core.dom.Inclusion;
import org.eclipse.cdt.internal.core.dom.Macro;
import org.eclipse.cdt.internal.core.dom.Name;
import org.eclipse.cdt.internal.core.dom.NamespaceDefinition;
import org.eclipse.cdt.internal.core.dom.ParameterDeclarationClause;
import org.eclipse.cdt.internal.core.dom.SimpleDeclaration;
import org.eclipse.cdt.internal.core.dom.TemplateDeclaration;
import org.eclipse.cdt.internal.core.dom.TranslationUnit;
import org.eclipse.cdt.internal.core.dom.TypeSpecifier;
import org.eclipse.cdt.internal.core.parser.IParserCallback;
import org.eclipse.cdt.internal.core.parser.Parser;
import org.eclipse.cdt.internal.parser.IStructurizerCallback;

public class ComparatorModelBuilder {
    IStructurizerCallback callback;
    String code;

    public ComparatorModelBuilder(IStructurizerCallback cb, String buffer) {
        this.callback = cb;
        this.code = buffer;
    }

    public void parse() {
        DOMBuilder domBuilder = DOMFactory.createDOMBuilder((boolean)false);
        try {
            Parser parser = new Parser(this.code, (IParserCallback)domBuilder, true);
            parser.parse();
        }
        catch (Exception e) {
            this.callback.reportError((Throwable)e);
        }
        this.generateModelElements(domBuilder.getTranslationUnit());
    }

    protected void generateModelElements(TranslationUnit tu) {
        Iterator i = tu.iterateOffsetableElements();
        while (i.hasNext()) {
            IOffsetable offsetable = (IOffsetable)i.next();
            if (offsetable instanceof Inclusion) {
                this.createInclusion((Inclusion)offsetable);
                continue;
            }
            if (offsetable instanceof Macro) {
                this.createMacro((Macro)offsetable);
                continue;
            }
            if (!(offsetable instanceof Declaration)) continue;
            this.generateModelElements((Declaration)offsetable);
        }
    }

    protected void generateModelElements(Declaration declaration) {
        if (declaration instanceof NamespaceDefinition) {
            NamespaceDefinition nsDef = (NamespaceDefinition)declaration;
            this.createNamespace(nsDef);
            List nsDeclarations = nsDef.getDeclarations();
            Iterator nsDecls = nsDeclarations.iterator();
            while (nsDecls.hasNext()) {
                Declaration subNsDeclaration = (Declaration)nsDecls.next();
                this.generateModelElements(subNsDeclaration);
            }
        }
        if (declaration instanceof SimpleDeclaration) {
            SimpleDeclaration simpleDeclaration = (SimpleDeclaration)declaration;
            TypeSpecifier typeSpec = simpleDeclaration.getTypeSpecifier();
            if (typeSpec instanceof EnumerationSpecifier) {
                EnumerationSpecifier enumSpecifier = (EnumerationSpecifier)typeSpec;
                this.createEnumeration(enumSpecifier);
            } else if (typeSpec instanceof ClassSpecifier) {
                ClassSpecifier classSpecifier = (ClassSpecifier)typeSpec;
                this.createClass(simpleDeclaration, classSpecifier, false);
                List declarations = classSpecifier.getDeclarations();
                Iterator j = declarations.iterator();
                while (j.hasNext()) {
                    Declaration subDeclaration = (Declaration)j.next();
                    this.generateModelElements(subDeclaration);
                }
            }
            List declarators = simpleDeclaration.getDeclarators();
            Iterator d = declarators.iterator();
            while (d.hasNext()) {
                Declarator declarator = (Declarator)d.next();
                this.createElement(simpleDeclaration, declarator);
            }
        }
        if (declaration instanceof TemplateDeclaration) {
            TemplateDeclaration templateDeclaration = (TemplateDeclaration)declaration;
            SimpleDeclaration simpleDeclaration = (SimpleDeclaration)templateDeclaration.getDeclarations().get(0);
            TypeSpecifier typeSpec = simpleDeclaration.getTypeSpecifier();
            if (typeSpec instanceof ClassSpecifier) {
                ClassSpecifier classSpecifier = (ClassSpecifier)typeSpec;
                this.createClass(simpleDeclaration, classSpecifier, true);
                List declarations = classSpecifier.getDeclarations();
                Iterator j = declarations.iterator();
                while (j.hasNext()) {
                    Declaration subDeclaration = (Declaration)j.next();
                    this.generateModelElements(subDeclaration);
                }
            }
            List declarators = simpleDeclaration.getDeclarators();
            Iterator d = declarators.iterator();
            while (d.hasNext()) {
                Declarator declarator = (Declarator)d.next();
                this.createTemplateElement(templateDeclaration, simpleDeclaration, declarator);
            }
        }
    }

    private void createElement(SimpleDeclaration simpleDeclaration, Declarator declarator) {
        if (simpleDeclaration.getDeclSpecifier().isTypedef()) {
            this.createTypeDef(declarator, simpleDeclaration);
        } else {
            ParameterDeclarationClause pdc = declarator.getParms();
            if (pdc == null) {
                this.createVariableSpecification(simpleDeclaration, declarator);
            } else {
                this.createFunctionSpecification(simpleDeclaration, declarator, pdc, false);
            }
        }
    }

    private void createTemplateElement(TemplateDeclaration templateDeclaration, SimpleDeclaration simpleDeclaration, Declarator declarator) {
        ParameterDeclarationClause pdc = declarator.getParms();
        if (pdc != null) {
            this.createFunctionSpecification(simpleDeclaration, declarator, pdc, true);
        }
    }

    private void createInclusion(Inclusion inclusion) {
        this.callback.includeDecl(inclusion.getName(), inclusion.getStartingOffset(), inclusion.getTotalLength(), 0, 0);
    }

    private void createMacro(Macro macro) {
        this.callback.defineDecl(macro.getName(), macro.getStartingOffset(), macro.getTotalLength(), 0, 0);
    }

    private void createNamespace(NamespaceDefinition nsDef) {
    }

    private void createEnumeration(EnumerationSpecifier enumSpecifier) {
        this.callback.structDeclBegin(enumSpecifier.getName().toString(), 63, enumSpecifier.getName().getStartOffset(), enumSpecifier.getName().length(), enumSpecifier.getStartingOffset(), 0, 0);
        this.callback.structDeclEnd(enumSpecifier.getTotalLength(), 0);
    }

    private void createClass(SimpleDeclaration simpleDeclaration, ClassSpecifier classSpecifier, boolean isTemplate) {
        int kind;
        String className = classSpecifier.getName() == null ? "" : classSpecifier.getName().toString();
        switch (classSpecifier.getClassKey()) {
            case 0: {
                kind = 64;
                break;
            }
            case 1: {
                kind = 65;
                break;
            }
            default: {
                kind = 66;
            }
        }
        if (classSpecifier.getName() != null) {
            this.callback.structDeclBegin(className, kind, classSpecifier.getName().getStartOffset(), classSpecifier.getName().length(), classSpecifier.getStartingOffset(), 0, 0);
        } else {
            this.callback.structDeclBegin(className, kind, classSpecifier.getClassKeyToken().getOffset(), classSpecifier.getClassKeyToken().getLength(), classSpecifier.getStartingOffset(), 0, 0);
        }
        this.callback.structDeclBegin(className, kind, classSpecifier.getClassKeyToken().getOffset(), classSpecifier.getClassKeyToken().getLength(), classSpecifier.getStartingOffset(), 0, 0);
        this.callback.structDeclEnd(classSpecifier.getTotalLength(), 0);
    }

    private void createTypeDef(Declarator declarator, SimpleDeclaration simpleDeclaration) {
        Name domName = declarator.getDeclarator() != null ? declarator.getDeclarator().getName() : declarator.getName();
        String declaratorName = domName.toString();
        this.callback.fieldDecl(declaratorName, domName.getStartOffset(), domName.length(), simpleDeclaration.getStartingOffset(), simpleDeclaration.getTotalLength(), 0, 0, 0);
    }

    private void createVariableSpecification(SimpleDeclaration simpleDeclaration, Declarator declarator) {
        Name domName = declarator.getDeclarator() != null ? declarator.getDeclarator().getName() : declarator.getName();
        String declaratorName = domName.toString();
        this.callback.fieldDecl(declaratorName, domName.getStartOffset(), domName.length(), simpleDeclaration.getStartingOffset(), simpleDeclaration.getTotalLength(), 0, 0, 0);
    }

    private void createFunctionSpecification(SimpleDeclaration simpleDeclaration, Declarator declarator, ParameterDeclarationClause pdc, boolean isTemplate) {
        Name domName = declarator.getDeclarator() != null ? declarator.getDeclarator().getName() : declarator.getName();
        String declaratorName = domName.toString();
        this.callback.functionDeclBegin(declaratorName, domName.getStartOffset(), domName.length(), simpleDeclaration.getStartingOffset(), 0, 0, 0);
        this.callback.functionDeclEnd(simpleDeclaration.getTotalLength(), 0, simpleDeclaration.isFunctionDefinition());
    }
}

