/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.cview;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.List;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.actions.CopyResourceAction;
import org.eclipse.ui.dialogs.IOverwriteQuery;
import org.eclipse.ui.part.PluginDropAdapter;
import org.eclipse.ui.part.ResourceTransfer;
import org.eclipse.ui.wizards.datatransfer.FileSystemStructureProvider;
import org.eclipse.ui.wizards.datatransfer.IImportStructureProvider;
import org.eclipse.ui.wizards.datatransfer.ImportOperation;

class CViewDropAdapter
extends PluginDropAdapter
implements IOverwriteQuery {
    protected long hoverStart = 0L;
    protected static final long hoverThreshold = 1500L;
    protected boolean isCanceled = false;
    protected boolean alwaysOverwrite = false;

    protected IStatus doCopy(final IResource source, final IPath destination, final boolean overwrite) {
        final boolean copy = this.getCurrentOperation() == 1;
        final IStatus[] result = new IStatus[]{this.ok()};
        try {
            new ProgressMonitorDialog(this.getShell()).run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) {
                    try {
                        IResource oldResource;
                        if (overwrite && (oldResource = source.getWorkspace().getRoot().findMember(destination)).exists()) {
                            oldResource.delete(true, null);
                        }
                        if (copy) {
                            IPath newName = destination;
                            if (source.getWorkspace().getRoot().exists(destination)) {
                                newName = CopyResourceAction.getNewNameFor((IPath)destination, (IWorkspace)source.getWorkspace());
                            }
                            if (newName != null) {
                                source.copy(newName, false, monitor);
                            }
                        } else {
                            source.move(destination, false, monitor);
                        }
                    }
                    catch (CoreException e) {
                        result[0] = e.getStatus();
                    }
                }
            });
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (InterruptedException interruptedException) {}
        return result[0];
    }

    protected IStatus dragAndDropCopy(IContainer target, IResource source) {
        if (this.isCanceled) {
            return this.ok();
        }
        if (this.getCurrentOperation() != 1 && (source.equals((Object)target) || source.getParent().equals((Object)target))) {
            return this.info("Same Source And Destination");
        }
        if (source.getFullPath().isPrefixOf(target.getFullPath())) {
            return this.error(source, "destination A SubFolder");
        }
        IPath destination = target.getFullPath().append(source.getName());
        IStatus result = this.doCopy(source, destination, false);
        if (result.getCode() == 374) {
            if (this.alwaysOverwrite) {
                return this.doCopy(source, destination, true);
            }
            String query = this.queryOverwrite(destination.toString());
            if (query == "YES") {
                return this.doCopy(source, destination, true);
            }
            if (query == "CANCEL") {
                this.isCanceled = true;
                return this.ok();
            }
            if (query == "ALL") {
                this.alwaysOverwrite = true;
                return this.doCopy(source, destination, true);
            }
            if (query == "NO") {
                return this.ok();
            }
        }
        return result;
    }

    protected IStatus dragAndDropImport(IContainer target, String filePath) {
        File toImport = new File(filePath);
        if (target.getLocation().equals((Object)toImport)) {
            return this.info("DropAdapter.canNotDropOntoSelf");
        }
        ImportOperation op = new ImportOperation(target.getFullPath(), (Object)new File(toImport.getParent()), (IImportStructureProvider)FileSystemStructureProvider.INSTANCE, (IOverwriteQuery)this, Arrays.asList(toImport));
        op.setCreateContainerStructure(false);
        try {
            new ProgressMonitorDialog(this.getShell()).run(true, true, (IRunnableWithProgress)op);
        }
        catch (InterruptedException interruptedException) {
            return this.info("Cancelled");
        }
        catch (InvocationTargetException e) {
            return this.error("Drop Operation Error", e.getTargetException());
        }
        return op.getStatus();
    }

    public void dragOver(DropTargetEvent event) {
        try {
            Object oldTarget = this.getCurrentTarget();
            super.dragOver(event);
            if (oldTarget != this.getCurrentTarget()) {
                this.hoverStart = System.currentTimeMillis();
            } else if (this.hoverStart > 0L && System.currentTimeMillis() - this.hoverStart > 1500L) {
                this.expandSelection((TreeItem)event.item);
                this.hoverStart = 0L;
            }
        }
        catch (Throwable t) {
            this.handleException(t, event);
        }
    }

    protected IStatus error(String message, Throwable exception) {
        return new Status(4, "org.eclipse.ui", 0, message, exception);
    }

    protected IStatus error(String message) {
        return this.error(message, null);
    }

    protected IStatus error(IResource source, String message) {
        if (this.getCurrentOperation() == 1) {
            return this.error("Can Not Copy", null);
        }
        return this.error("Can Not Move", null);
    }

    protected void expandSelection(TreeItem selection) {
        if (selection == null) {
            return;
        }
        if (!selection.getExpanded()) {
            TreeViewer treeViewer = (TreeViewer)this.getViewer();
            treeViewer.expandToLevel(selection.getData(), 1);
        }
    }

    protected IContainer getActualTarget(IResource mouseTarget) {
        if (this.getCurrentLocation() == 1 || this.getCurrentLocation() == 2) {
            return mouseTarget.getParent();
        }
        if (mouseTarget.getType() == 1) {
            return mouseTarget.getParent();
        }
        return (IContainer)mouseTarget;
    }

    protected Display getDisplay() {
        return this.getViewer().getControl().getDisplay();
    }

    protected Shell getShell() {
        return this.getViewer().getControl().getShell();
    }

    protected IStatus info(String message) {
        return new Status(1, "org.eclipse.ui", 0, message, null);
    }

    public CViewDropAdapter(StructuredViewer viewer) {
        super(viewer);
    }

    protected void mergeStatus(MultiStatus status, IStatus toMerge) {
        if (!toMerge.isOK()) {
            status.merge(toMerge);
        }
    }

    protected IStatus multiStatus(List problems, String message) {
        IStatus[] children = new IStatus[problems.size()];
        problems.toArray(children);
        if (children.length == 1) {
            return children[0];
        }
        return new MultiStatus("org.eclipse.ui", 0, children, message, null);
    }

    protected IStatus ok() {
        return new Status(0, "org.eclipse.ui", 0, "Ok", null);
    }

    protected void openError(IStatus status) {
        String genericTitle = "Error";
        int codes = 6;
        if (!status.isMultiStatus()) {
            ErrorDialog.openError((Shell)this.getShell(), (String)genericTitle, null, (IStatus)status, (int)codes);
            return;
        }
        IStatus[] children = status.getChildren();
        if (children.length == 1) {
            ErrorDialog.openError((Shell)this.getShell(), (String)status.getMessage(), null, (IStatus)children[0], (int)codes);
            return;
        }
        ErrorDialog.openError((Shell)this.getShell(), (String)genericTitle, null, (IStatus)status, (int)codes);
    }

    public boolean performDrop(Object data) {
        this.isCanceled = false;
        this.alwaysOverwrite = false;
        if (this.getCurrentTarget() == null || data == null) {
            return false;
        }
        TransferData currentTransfer = this.getCurrentTransfer();
        if (ResourceTransfer.getInstance().isSupportedType(currentTransfer)) {
            return this.performResourceDrop(data);
        }
        if (FileTransfer.getInstance().isSupportedType(currentTransfer)) {
            return this.performFileDrop(data);
        }
        return super.performDrop(data);
    }

    protected boolean performFileDrop(Object data) {
        MultiStatus problems = new MultiStatus("org.eclipse.ui", 0, "Problem Importing", null);
        this.mergeStatus(problems, this.validateTarget(this.getCurrentTarget()));
        Object obj = this.getCurrentTarget();
        IResource res = null;
        if (obj instanceof ICElement) {
            try {
                res = ((ICElement)obj).getUnderlyingResource();
            }
            catch (CModelException cModelException) {}
        }
        IContainer targetResource = this.getActualTarget(res);
        String[] names = (String[])data;
        int i = 0;
        while (i < names.length) {
            this.mergeStatus(problems, this.dragAndDropImport(targetResource, names[i]));
            ++i;
        }
        this.openError((IStatus)problems);
        return problems.isOK();
    }

    protected boolean performResourceDrop(Object data) {
        MultiStatus problems = new MultiStatus("org.eclipse.ui", 1, "Problems Moving", null);
        this.mergeStatus(problems, this.validateTarget(this.getCurrentTarget()));
        Object obj = this.getCurrentTarget();
        IResource res = null;
        if (obj instanceof ICElement) {
            try {
                res = ((ICElement)obj).getUnderlyingResource();
            }
            catch (CModelException cModelException) {}
        }
        IContainer targetResource = this.getActualTarget(res);
        IResource[] sources = (IResource[])data;
        int i = 0;
        while (i < sources.length) {
            this.mergeStatus(problems, this.dragAndDropCopy(targetResource, sources[i]));
            ++i;
        }
        this.openError((IStatus)problems);
        return false;
    }

    public String queryOverwrite(String pathString) {
        final String[] returnCode = new String[]{"CANCEL"};
        final String msg = String.valueOf(pathString) + " " + CUIPlugin.getResourceString("CViewDragNDrop.txt");
        final String[] options = new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.YES_TO_ALL_LABEL, IDialogConstants.CANCEL_LABEL};
        this.getDisplay().syncExec(new Runnable(){

            public void run() {
                MessageDialog dialog = new MessageDialog(CViewDropAdapter.this.getShell(), "Question", null, msg, 3, options, 0);
                dialog.open();
                int returnVal = dialog.getReturnCode();
                String[] returnCodes = new String[]{"YES", "NO", "ALL", "CANCEL"};
                returnCode[0] = returnVal < 0 ? "CANCEL" : returnCodes[returnVal];
            }
        });
        return returnCode[0];
    }

    public boolean validateDrop(Object target, int operation, TransferData transferType) {
        if (super.validateDrop(target, operation, transferType)) {
            return true;
        }
        return this.validateTarget(target).isOK();
    }

    protected IStatus validateTarget(Object target) {
        if (target instanceof ICElement) {
            try {
                IResource r = ((ICElement)target).getUnderlyingResource();
                if (r == null) {
                    return this.info("Target Must Be Resource");
                }
                target = r;
            }
            catch (CModelException cModelException) {}
        }
        if (!(target instanceof IResource)) {
            return this.info("Target Must Be Resource");
        }
        IResource resource = (IResource)target;
        if (!resource.isAccessible()) {
            return this.error("Can Not Drop Into Closed Project");
        }
        IContainer destination = this.getActualTarget(resource);
        if (destination.getType() == 8) {
            return this.error("Resources Can Not Be Siblings");
        }
        return this.ok();
    }
}

