/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.cview;

import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.IArchive;
import org.eclipse.cdt.core.model.IArchiveContainer;
import org.eclipse.cdt.core.model.IBinary;
import org.eclipse.cdt.core.model.IBinaryContainer;
import org.eclipse.cdt.core.model.ICContainer;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICModel;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.IFunction;
import org.eclipse.cdt.core.model.IFunctionDeclaration;
import org.eclipse.cdt.core.model.IInclude;
import org.eclipse.cdt.core.model.ILibraryReference;
import org.eclipse.cdt.core.model.IMacro;
import org.eclipse.cdt.core.model.IMethod;
import org.eclipse.cdt.core.model.IMethodDeclaration;
import org.eclipse.cdt.core.model.INamespace;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.model.IUsing;
import org.eclipse.cdt.core.model.IVariable;
import org.eclipse.cdt.core.model.IVariableDeclaration;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.viewers.ViewerSorter;

public class CViewSorter
extends ViewerSorter {
    public int category(Object element) {
        if (element instanceof ICModel) {
            return 0;
        }
        if (element instanceof ICProject) {
            return 10;
        }
        if (element instanceof IBinaryContainer) {
            return 20;
        }
        if (element instanceof IArchiveContainer) {
            return 30;
        }
        if (element instanceof ICContainer) {
            return 40;
        }
        if (element instanceof ITranslationUnit) {
            IResource res = null;
            try {
                res = ((ITranslationUnit)element).getUnderlyingResource();
            }
            catch (CModelException cModelException) {}
            if (res != null) {
                String ext = res.getFileExtension();
                if (ext != null) {
                    String[] headers = CoreModel.getDefault().getHeaderExtensions();
                    int i = 0;
                    while (i < headers.length) {
                        if (ext.equals(headers[i])) {
                            return 42;
                        }
                        ++i;
                    }
                    String[] sources = CoreModel.getDefault().getSourceExtensions();
                    int i2 = 0;
                    while (i2 < sources.length) {
                        if (ext.equals(sources[i2])) {
                            return 47;
                        }
                        ++i2;
                    }
                    return 48;
                }
                return 49;
            }
            return 50;
        }
        if (element instanceof IInclude) {
            return 60;
        }
        if (element instanceof IMacro) {
            return 70;
        }
        if (element instanceof INamespace) {
            return 80;
        }
        if (element instanceof IUsing) {
            return 90;
        }
        if (element instanceof IFunctionDeclaration && !(element instanceof IFunction)) {
            return 100;
        }
        if (element instanceof IMethodDeclaration && !(element instanceof IMethod)) {
            return 110;
        }
        if (element instanceof IVariableDeclaration) {
            return 120;
        }
        if (element instanceof IVariable) {
            String name = ((ICElement)element).getElementName();
            if (name.startsWith("__")) {
                return 122;
            }
            if (name.charAt(0) == '_') {
                return 124;
            }
            return 130;
        }
        if (element instanceof IFunction) {
            String name = ((ICElement)element).getElementName();
            if (name.startsWith("__")) {
                return 132;
            }
            if (name.charAt(0) == '_') {
                return 134;
            }
            return 140;
        }
        if (element instanceof IArchive) {
            return 150;
        }
        if (element instanceof IBinary) {
            return 160;
        }
        if (element instanceof ILibraryReference) {
            return 170;
        }
        if (element instanceof ICElement) {
            String name = ((ICElement)element).getElementName();
            if (name.startsWith("__")) {
                return 172;
            }
            if (name.charAt(0) == '_') {
                return 174;
            }
            return 180;
        }
        return 200;
    }
}

