/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.editor.asm;

import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import org.eclipse.cdt.internal.ui.editor.CEditorMessages;
import org.eclipse.cdt.internal.ui.editor.asm.AsmSourceViewerConfiguration;
import org.eclipse.cdt.internal.ui.editor.asm.AsmTextTools;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.SaveAsDialog;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.DefaultRangeIndicator;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.StatusTextEditor;

public class AsmTextEditor
extends StatusTextEditor {
    public AsmTextEditor() {
        this.initializeEditor();
    }

    protected void initializeEditor() {
        AsmTextTools textTools = CUIPlugin.getDefault().getAsmTextTools();
        this.setSourceViewerConfiguration(new AsmSourceViewerConfiguration(textTools, this));
        this.setDocumentProvider((IDocumentProvider)CUIPlugin.getDefault().getDocumentProvider());
        this.setRangeIndicator((Annotation)new DefaultRangeIndicator());
        this.setPreferenceStore(CUIPlugin.getDefault().getPreferenceStore());
        this.setEditorContextMenuId("#ASMEditorContext");
        this.setRulerContextMenuId("#ASMEditorRulerContext");
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    protected void performSaveAs(IProgressMonitor progressMonitor) {
        Shell shell = this.getSite().getShell();
        SaveAsDialog dialog = new SaveAsDialog(shell);
        dialog.open();
        IPath path = dialog.getResult();
        if (path == null) {
            if (progressMonitor != null) {
                progressMonitor.setCanceled(true);
            }
            return;
        }
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IFile file = workspace.getRoot().getFile(path);
        FileEditorInput newInput = new FileEditorInput(file);
        WorkspaceModifyOperation op = new WorkspaceModifyOperation((IEditorInput)newInput){
            private final /* synthetic */ IEditorInput val$newInput;
            {
                this.val$newInput = iEditorInput;
            }

            public void execute(IProgressMonitor monitor) throws CoreException {
                AsmTextEditor.this.getDocumentProvider().saveDocument(monitor, (Object)this.val$newInput, AsmTextEditor.this.getDocumentProvider().getDocument((Object)AsmTextEditor.this.getEditorInput()), true);
            }
        };
        boolean success = false;
        try {
            try {
                this.getDocumentProvider().aboutToChange((Object)newInput);
                new ProgressMonitorDialog(shell).run(false, true, (IRunnableWithProgress)op);
                success = true;
            }
            catch (InterruptedException interruptedException) {
            }
            catch (InvocationTargetException x) {
                String title = CEditorMessages.getString("CEditor.error.saving.title");
                String msg = MessageFormat.format(CEditorMessages.getString("CEditor.error.saving.message"), x.getTargetException().getMessage());
                MessageDialog.openError((Shell)shell, (String)title, (String)msg);
            }
        }
        catch (Throwable throwable) {
            Object var13_14 = null;
            this.getDocumentProvider().changed((Object)newInput);
            if (success) {
                this.setInput((IEditorInput)newInput);
            }
            throw throwable;
        }
        Object var13_15 = null;
        this.getDocumentProvider().changed((Object)newInput);
        if (success) {
            this.setInput((IEditorInput)newInput);
        }
        if (progressMonitor != null) {
            progressMonitor.setCanceled(!success);
        }
    }

    protected boolean affectsTextPresentation(PropertyChangeEvent event) {
        boolean affects = false;
        AsmTextTools textTools = CUIPlugin.getDefault().getAsmTextTools();
        return (affects |= textTools.affectsBehavior(event)) ? affects : super.affectsTextPresentation(event);
    }

    protected void createActions() {
        super.createActions();
    }

    protected void editorContextMenuAboutToShow(IMenuManager menu) {
        super.editorContextMenuAboutToShow(menu);
        this.addAction(menu, "group.edit", "ShiftRight");
        this.addAction(menu, "group.edit", "ShiftLeft");
    }
}

