/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.preferences;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.cdt.internal.ui.dialogs.IStatusChangeListener;
import org.eclipse.cdt.internal.ui.dialogs.StatusTool;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.wizards.BinaryParserBlock;
import org.eclipse.cdt.ui.wizards.IndexerBlock;
import org.eclipse.cdt.ui.wizards.SettingsBlock;
import org.eclipse.cdt.utils.ui.controls.TabFolderLayout;
import org.eclipse.cdt.utils.ui.swt.IValidation;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.ui.actions.WorkspaceModifyDelegatingOperation;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipse.ui.help.WorkbenchHelp;

public class CProjectPropertyPage
extends PropertyPage
implements IStatusChangeListener,
IValidation {
    private static final String MSG_NOCPROJECT = "CProjectPropertyPage.nocproject";
    private static final String MSG_CLOSEDPROJECT = "CProjectPropertyPage.closedproject";
    private TabFolder folder;
    SettingsBlock settingsBlock;
    IndexerBlock indexerBlock;
    BinaryParserBlock binaryParserBlock;

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new FillLayout());
        IProject project = this.getProject();
        if (!project.isOpen()) {
            this.contentForClosedProject(composite);
        } else {
            this.contentForCProject(composite);
        }
        return composite;
    }

    private void contentForCProject(Composite parent) {
        this.folder = new TabFolder(parent, 0);
        this.folder.setLayout((Layout)new TabFolderLayout());
        this.settingsBlock = new SettingsBlock(this, this.getProject());
        TabItem item2 = new TabItem(this.folder, 0);
        item2.setText(this.settingsBlock.getLabel());
        Image img2 = this.settingsBlock.getImage();
        if (img2 != null) {
            item2.setImage(img2);
        }
        item2.setData((Object)this.settingsBlock);
        item2.setControl((Control)this.settingsBlock.getControl((Composite)this.folder));
        this.indexerBlock = new IndexerBlock(this, this.getProject());
        TabItem item3 = new TabItem(this.folder, 0);
        item3.setText(this.indexerBlock.getLabel());
        Image img3 = this.indexerBlock.getImage();
        if (img3 != null) {
            item3.setImage(img3);
        }
        item3.setData((Object)this.indexerBlock);
        item3.setControl((Control)this.indexerBlock.getControl((Composite)this.folder));
        this.binaryParserBlock = new BinaryParserBlock(this, this.getProject());
        TabItem item4 = new TabItem(this.folder, 0);
        item4.setText(this.binaryParserBlock.getLabel());
        Image img4 = this.binaryParserBlock.getImage();
        if (img4 != null) {
            item4.setImage(img4);
        }
        item4.setData((Object)this.binaryParserBlock);
        item4.setControl((Control)this.binaryParserBlock.getControl((Composite)this.folder));
        WorkbenchHelp.setHelp((Control)parent, (String)"org.eclipse.cdt.ui.new_project_property_page_context");
    }

    private void contentForClosedProject(Composite parent) {
        Label label = new Label(parent, 16384);
        label.setText(CUIPlugin.getResourceString(MSG_CLOSEDPROJECT));
        label.setFont(parent.getFont());
        this.noDefaultAndApplyButton();
    }

    public void setComplete(boolean complete) {
        boolean ok = true;
        if (ok && this.settingsBlock != null) {
            ok = this.settingsBlock.isValid();
        }
        if (ok && this.indexerBlock != null) {
            ok = this.indexerBlock.isValid();
        }
        if (ok && this.binaryParserBlock != null) {
            ok = this.binaryParserBlock.isValid();
        }
        this.setValid(ok);
    }

    public boolean performOk() {
        Shell shell = this.getControl().getShell();
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                monitor.beginTask("Property changes", 20);
                if (CProjectPropertyPage.this.settingsBlock != null) {
                    CProjectPropertyPage.this.settingsBlock.doRun(CProjectPropertyPage.this.getProject(), monitor);
                }
                monitor.worked(2);
                if (CProjectPropertyPage.this.indexerBlock != null) {
                    CProjectPropertyPage.this.indexerBlock.doRun(CProjectPropertyPage.this.getProject(), monitor);
                }
                monitor.worked(10);
                if (CProjectPropertyPage.this.binaryParserBlock != null) {
                    CProjectPropertyPage.this.binaryParserBlock.doRun(CProjectPropertyPage.this.getProject(), monitor);
                }
                monitor.worked(19);
                monitor.done();
            }
        };
        WorkspaceModifyDelegatingOperation op = new WorkspaceModifyDelegatingOperation(runnable);
        try {
            new ProgressMonitorDialog(shell).run(false, true, (IRunnableWithProgress)op);
        }
        catch (InvocationTargetException invocationTargetException) {
            return false;
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        return true;
    }

    IProject getProject() {
        IAdaptable element = this.getElement();
        if (element instanceof IProject) {
            return (IProject)element;
        }
        return null;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible && this.folder != null) {
            this.settingsBlock.setVisible(visible);
            this.indexerBlock.setVisible(visible);
            this.binaryParserBlock.setVisible(visible);
            this.folder.setFocus();
        }
    }

    public void statusChanged(IStatus status) {
        this.setValid(!status.matches(4));
        StatusTool.applyToStatusLine((DialogPage)this, status);
    }
}

