/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.launchbar.ui.controls.internal;

import java.util.Comparator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.launchbar.ui.controls.internal.Activator;
import org.eclipse.launchbar.ui.controls.internal.EditButton;
import org.eclipse.launchbar.ui.controls.internal.LaunchBarListViewer;
import org.eclipse.launchbar.ui.controls.internal.Messages;
import org.eclipse.launchbar.ui.controls.internal.Transition;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.LineAttributes;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public abstract class CSelector
extends Composite {
    private IStructuredContentProvider contentProvider;
    private ILabelProvider labelProvider;
    private Comparator<?> sorter;
    private Comparator<?> sorterTop;
    private Object input;
    private Composite buttonComposite;
    private static final int arrowMax = 2;
    private Transition arrowTransition;
    private Object selection;
    private boolean mouseOver;
    private Label currentIcon;
    private Label currentLabel;
    private Shell popup;
    private LaunchBarListViewer listViewer;
    private Job delayJob;
    private MouseListener mouseListener = new MouseAdapter(){

        public void mouseUp(MouseEvent event) {
            if (CSelector.this.popup == null || CSelector.this.popup.isDisposed()) {
                CSelector.this.setFocus();
                CSelector.this.openPopup();
            } else {
                CSelector.this.closePopup();
            }
        }
    };
    private Listener focusOutListener = new Listener(){
        private Job closingJob;

        public void handleEvent(Event event) {
            switch (event.type) {
                case 15: {
                    if (this.closingJob != null) {
                        this.closingJob.cancel();
                    }
                    if (event.widget instanceof Control && CSelector.this.myIsFocusAncestor((Control)event.widget) || CSelector.this.isPopUpInFocus()) break;
                    CSelector.this.closePopup();
                    break;
                }
                case 16: {
                    if (!CSelector.this.isPopUpInFocus()) break;
                    if (this.closingJob != null) {
                        this.closingJob.cancel();
                    }
                    this.closingJob = new Job(Messages.CSelector_0){

                        protected IStatus run(IProgressMonitor monitor) {
                            if (monitor.isCanceled()) {
                                return Status.CANCEL_STATUS;
                            }
                            CSelector.this.closePopup();
                            closingJob = null;
                            return Status.OK_STATUS;
                        }
                    };
                    this.closingJob.schedule(300L);
                    break;
                }
                case 4: {
                    if (CSelector.this.popup == null || CSelector.this.popup.isDisposed()) break;
                    Point loc = CSelector.this.getDisplay().getCursorLocation();
                    if (CSelector.this.popup.getBounds().contains(loc) || CSelector.this.getBounds().contains(CSelector.this.getParent().toControl(loc))) break;
                    CSelector.this.closePopup();
                    break;
                }
            }
        }
    };

    protected boolean myIsFocusAncestor(Control control) {
        while (control != null && control != this && !(control instanceof Shell)) {
            control = control.getParent();
        }
        return control == this;
    }

    public CSelector(Composite parent, int style) {
        super(parent, style);
        this.setBackground(this.getDisplay().getSystemColor(25));
        GridLayout mainButtonLayout = new GridLayout();
        this.setLayout((Layout)mainButtonLayout);
        this.addPaintListener(e -> {
            GC gc = e.gc;
            gc.setBackground(this.getBackground());
            gc.setForeground(this.getOutlineColor());
            Point size = this.getSize();
            int arc = 3;
            gc.fillRoundRectangle(0, 0, size.x - 1, size.y - 1, 3, 3);
            gc.drawRoundRectangle(0, 0, size.x - 1, size.y - 1, 3, 3);
        });
        this.addMouseListener(this.mouseListener);
    }

    private boolean isPopUpInFocus() {
        Control focusControl = this.getDisplay().getFocusControl();
        return focusControl != null && focusControl.getShell() == this.popup;
    }

    public void dispose() {
        super.dispose();
        if (this.popup != null) {
            this.popup.dispose();
        }
    }

    public void setDelayedSelection(final Object element, long millis) {
        if (this.delayJob != null) {
            this.delayJob.cancel();
        }
        this.delayJob = new Job(Messages.CSelector_1){

            protected IStatus run(IProgressMonitor monitor) {
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                if (CSelector.this.isDisposed()) {
                    return Status.CANCEL_STATUS;
                }
                CSelector.this.getDisplay().asyncExec(() -> {
                    if (monitor.isCanceled()) {
                        return;
                    }
                    CSelector.this.setSelection(element);
                });
                return Status.OK_STATUS;
            }
        };
        this.delayJob.schedule(millis);
    }

    public void setSelection(Object element) {
        if (this.isDisposed()) {
            return;
        }
        this.selection = element;
        if (this.buttonComposite != null) {
            this.buttonComposite.dispose();
        }
        String toolTipText = this.getToolTipText();
        boolean editable = false;
        int columns = 2;
        Image image = this.labelProvider.getImage(element);
        if (image != null) {
            ++columns;
        }
        if (editable = this.isEditable(element)) {
            ++columns;
        }
        this.buttonComposite = new Composite((Composite)this, 0);
        GridLayout buttonLayout = new GridLayout(columns, false);
        buttonLayout.marginWidth = 0;
        buttonLayout.marginHeight = 0;
        this.buttonComposite.setLayout((Layout)buttonLayout);
        this.buttonComposite.setLayoutData((Object)new GridData(4, 4, true, false));
        this.buttonComposite.setBackground(this.getBackground());
        this.buttonComposite.addMouseListener(this.mouseListener);
        this.buttonComposite.setToolTipText(toolTipText);
        if (element != null) {
            if (image != null) {
                Label icon = this.createImage(this.buttonComposite, image);
                icon.addMouseListener(this.mouseListener);
                this.currentIcon = icon;
                this.currentIcon.setToolTipText(toolTipText);
            }
            Label label = this.createLabel(this.buttonComposite, element);
            label.addMouseListener(this.mouseListener);
            this.currentLabel = label;
            this.currentLabel.setToolTipText(toolTipText);
        } else {
            Composite blank = new Composite(this.buttonComposite, 0);
            blank.setLayoutData((Object)new GridData(4, 4, true, true));
            this.currentIcon = null;
            this.currentLabel = null;
        }
        Canvas arrow = new Canvas(this.buttonComposite, 0){

            public Point computeSize(int wHint, int hHint, boolean changed) {
                return new Point(12, 16);
            }
        };
        arrow.setLayoutData((Object)new GridData(4, 4, false, true));
        arrow.setBackground(this.getBackground());
        arrow.setForeground(this.getForeground());
        this.arrowTransition = new Transition((Control)arrow, 2, 80);
        arrow.addPaintListener(e -> {
            int hPadding = 2;
            GC gc = e.gc;
            LineAttributes attributes = new LineAttributes(2.0f);
            attributes.cap = 2;
            gc.setLineAttributes(attributes);
            gc.setAlpha(this.mouseOver ? 255 : 100);
            Rectangle bounds = arrow.getBounds();
            int arrowWidth = bounds.width - 4;
            int current = this.arrowTransition.getCurrent();
            gc.drawPolyline(new int[]{2, bounds.height / 2 - current, 2 + arrowWidth / 2, bounds.height / 2 + current, 2 + arrowWidth, bounds.height / 2 - current});
        });
        arrow.addMouseListener(this.mouseListener);
        if (editable) {
            EditButton editButton = new EditButton(this.buttonComposite, 0);
            editButton.setData("org.eclipse.swtbot.widget.key", "org.eclipse.launchbar.edit");
            editButton.setLayoutData(new GridData(4, 0x1000000, false, true));
            editButton.setBackground(this.getBackground());
            editButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    CSelector.this.getDisplay().asyncExec(() -> {
                        if (CSelector.this.selection != null) {
                            CSelector.this.handleEdit(CSelector.this.selection);
                        }
                    });
                }
            });
        }
        this.layout();
    }

    protected abstract void fireSelectionChanged();

    public Object getSelection() {
        return this.selection;
    }

    public MouseListener getMouseListener() {
        return this.mouseListener;
    }

    protected void openPopup() {
        Object[] elements = this.contentProvider.getElements(this.input);
        if (elements.length == 0 && !this.hasActionArea()) {
            return;
        }
        this.arrowTransition.to(-2);
        if (this.popup != null && !this.popup.isDisposed()) {
            this.popup.dispose();
        }
        this.popup = new Shell(this.getShell(), 16404);
        this.popup.setData("org.eclipse.swtbot.widget.key", (Object)"org.eclipse.launchbar.popup");
        this.popup.setLayout((Layout)GridLayoutFactory.fillDefaults().spacing(0, 0).create());
        this.popup.setBackground(this.getBackground());
        this.listViewer = new LaunchBarListViewer((Composite)this.popup);
        this.initializeListViewer(this.listViewer);
        this.listViewer.setFilterVisible(elements.length > 7);
        this.listViewer.setInput(this.input);
        this.listViewer.addSelectionChangedListener(event -> {
            if (!this.listViewer.isFinalSelection()) {
                return;
            }
            StructuredSelection ss = (StructuredSelection)event.getSelection();
            if (!ss.isEmpty()) {
                this.setSelection(ss.getFirstElement());
                this.fireSelectionChanged();
            }
            this.closePopup();
        });
        if (this.hasActionArea()) {
            this.createActionArea((Composite)this.popup);
        }
        Rectangle buttonBounds = this.getBounds();
        Point popupLocation = this.popup.getDisplay().map((Control)this, null, 0, buttonBounds.height);
        this.popup.setLocation(popupLocation.x, popupLocation.y + 5);
        this.restoreShellSize();
        this.popup.setVisible(true);
        this.popup.setFocus();
        this.getDisplay().addFilter(15, this.focusOutListener);
        this.getDisplay().addFilter(16, this.focusOutListener);
        this.getDisplay().addFilter(4, this.focusOutListener);
        this.popup.addDisposeListener(e -> {
            this.getDisplay().removeFilter(15, this.focusOutListener);
            this.getDisplay().removeFilter(16, this.focusOutListener);
            this.getDisplay().removeFilter(4, this.focusOutListener);
            this.saveShellSize();
        });
    }

    protected String getDialogPreferencePrefix() {
        return ((Object)((Object)this)).getClass().getSimpleName();
    }

    protected void restoreShellSize() {
        Point size = this.popup.computeSize(-1, -1);
        Point buttonSize = this.getSize();
        size.x = Math.max(size.x, buttonSize.x);
        size.y = Math.min(size.y, 300);
        try {
            IPreferenceStore store = Activator.getDefault().getPreferenceStore();
            String prefName = this.getDialogPreferencePrefix();
            int w = store.getInt(String.valueOf(prefName) + ".shell.w");
            int h = store.getInt(String.valueOf(prefName) + ".shell.h");
            size.x = Math.max(size.x, w);
            size.y = Math.max(size.y, h);
        }
        catch (Exception e) {
            Activator.log(e);
        }
        this.popup.setSize(size);
    }

    protected void saveShellSize() {
        Point size = this.popup.getSize();
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        String prefName = this.getDialogPreferencePrefix();
        store.setValue(String.valueOf(prefName) + ".shell.w", size.x);
        store.setValue(String.valueOf(prefName) + ".shell.h", size.y);
    }

    protected void initializeListViewer(LaunchBarListViewer listViewer) {
        listViewer.setContentProvider((IContentProvider)this.contentProvider);
        listViewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        listViewer.setComparator(this.sorter);
        listViewer.setHistoryComparator(this.sorterTop);
    }

    private void closePopup() {
        this.getDisplay().asyncExec(() -> {
            if (this.popup == null || this.popup.isDisposed()) {
                return;
            }
            this.arrowTransition.to(2);
            this.popup.setVisible(false);
            this.popup.dispose();
        });
    }

    private Label createImage(Composite parent, Image image) {
        Rectangle bounds = image.getBounds();
        boolean disposeImage = false;
        if (bounds.height > 16 || bounds.width > 16) {
            Image buttonImage = new Image((Device)this.getDisplay(), 16, 16);
            GC gc = new GC((Drawable)buttonImage);
            gc.setAntialias(1);
            gc.setInterpolation(2);
            gc.drawImage(image, 0, 0, image.getBounds().width, image.getBounds().height, 0, 0, 16, 16);
            gc.dispose();
            image = buttonImage;
            disposeImage = true;
        }
        Label icon = new Label(parent, 0);
        icon.setLayoutData((Object)new GridData(4, 0x1000000, false, true));
        icon.setImage(image);
        if (disposeImage) {
            Image disposableImage = image;
            icon.addDisposeListener(e -> disposableImage.dispose());
        }
        return icon;
    }

    private Label createLabel(Composite parent, Object element) {
        Label label = new Label(parent, 0);
        label.setLayoutData((Object)new GridData(4, 0x1000000, true, true));
        label.setText(this.labelProvider.getText(element));
        label.setFont(this.getDisplay().getSystemFont());
        return label;
    }

    public void setContentProvider(IStructuredContentProvider contentProvider) {
        this.contentProvider = contentProvider;
    }

    public IStructuredContentProvider getContentProvider() {
        return this.contentProvider;
    }

    public void setLabelProvider(ILabelProvider labelProvider) {
        this.labelProvider = labelProvider;
    }

    public ILabelProvider getLabelProvider() {
        return this.labelProvider;
    }

    public void setToolTipText(String toolTipText) {
        super.setToolTipText(toolTipText);
        if (this.buttonComposite != null) {
            this.buttonComposite.setToolTipText(toolTipText);
        }
        if (this.currentLabel != null && !this.currentLabel.isDisposed()) {
            this.currentLabel.setToolTipText(toolTipText);
        }
        if (this.currentIcon != null && !this.currentIcon.isDisposed()) {
            this.currentIcon.setToolTipText(toolTipText);
        }
    }

    public void setSorter(Comparator<?> sorter) {
        this.sorter = sorter;
    }

    public void setHistorySortComparator(Comparator<?> sorter) {
        this.sorterTop = sorter;
    }

    public void setInput(Object input) {
        this.input = input;
    }

    public Object getInput() {
        return this.input;
    }

    public void refresh() {
        PlatformUI.getWorkbench().getDisplay().asyncExec(() -> {
            if (this.isDisposed()) {
                return;
            }
            this.update(this.selection);
            if (this.popup != null && !this.popup.isDisposed()) {
                this.listViewer.refresh(true);
            }
        });
    }

    public void update(Object element) {
        if (this.selection == element) {
            if (this.currentIcon != null && !this.currentIcon.isDisposed()) {
                this.currentIcon.setImage(this.labelProvider.getImage(element));
            }
            if (this.currentLabel != null && !this.currentLabel.isDisposed()) {
                this.currentLabel.setText(this.labelProvider.getText(element));
            }
        }
        if (this.popup != null && !this.popup.isDisposed()) {
            this.listViewer.update(element, null);
        }
    }

    public String getText() {
        if (this.currentLabel != null) {
            this.currentLabel.getText();
        }
        return "";
    }

    protected boolean hasActionArea() {
        return false;
    }

    protected void createActionArea(Composite parent) {
    }

    protected boolean isEditable(Object element) {
        return false;
    }

    protected void handleEdit(Object element) {
    }

    public Color getOutlineColor() {
        return this.getDisplay().getSystemColor(18);
    }

    public Color getHighlightColor() {
        return this.getDisplay().getSystemColor(26);
    }
}

