/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.launchbar.ui.internal;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.launchbar.core.ILaunchDescriptor;
import org.eclipse.launchbar.core.internal.ExecutableExtension;
import org.eclipse.launchbar.core.internal.LaunchBarManager;

public class LaunchBarUIManager {
    private LaunchBarManager manager;
    private Map<String, ExecutableExtension<ILabelProvider>> descriptorLabelProviders = new HashMap<String, ExecutableExtension<ILabelProvider>>();

    public LaunchBarUIManager(LaunchBarManager manager) {
        IExtension[] extensions;
        this.manager = manager;
        IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.launchbar.ui", "launchBarUIContributions");
        IExtension[] iExtensionArray = extensions = point.getExtensions();
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
            int n3 = iConfigurationElementArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement element = iConfigurationElementArray[n4];
                String elementName = element.getName();
                if (elementName.equals("descriptorUI")) {
                    String descriptorTypeId = element.getAttribute("descriptorTypeId");
                    ExecutableExtension labelProvider = new ExecutableExtension(element, "labelProvider");
                    this.descriptorLabelProviders.put(descriptorTypeId, (ExecutableExtension<ILabelProvider>)labelProvider);
                }
                ++n4;
            }
            ++n2;
        }
    }

    public LaunchBarManager getManager() {
        return this.manager;
    }

    public ILabelProvider getLabelProvider(ILaunchDescriptor descriptor) throws CoreException {
        ExecutableExtension<ILabelProvider> provider = this.descriptorLabelProviders.get(this.manager.getDescriptorTypeId(descriptor.getType()));
        return provider != null ? (ILabelProvider)provider.get() : null;
    }
}

