/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.launchbar.ui.internal.controls;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.launchbar.core.ILaunchDescriptor;
import org.eclipse.launchbar.ui.internal.Activator;
import org.eclipse.launchbar.ui.internal.Messages;
import org.eclipse.launchbar.ui.internal.controls.EditButton;
import org.eclipse.launchbar.ui.internal.controls.FilterControl;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Sash;
import org.eclipse.swt.widgets.Widget;

public class LaunchBarListViewer
extends StructuredViewer {
    private ScrolledComposite listScrolled;
    private Composite listComposite;
    private ListItem[] listItems;
    private int selIndex;
    private int itemH = 30;
    private int scrollBucket;
    private final int maxScrollBucket = 6;
    private int separatorIndex = -1;
    private boolean historySupported = true;
    private ViewerComparator historyComparator;
    private boolean finalSelection = false;
    private FilterControl filterControl;
    private Sash sash;
    private String historyPref;
    private TraverseListener listItemTraverseListener = new TraverseListener(){

        public void keyTraversed(TraverseEvent e) {
            ListItem currItem;
            ListItem listItem = currItem = LaunchBarListViewer.this.selIndex >= 0 ? LaunchBarListViewer.this.listItems[LaunchBarListViewer.this.selIndex] : null;
            if (currItem == null && e.keyCode != 0x1000002) {
                return;
            }
            if (e.detail == 64 || e.detail == 16) {
                if (e.keyCode == 0x1000002) {
                    int maxIdx = LaunchBarListViewer.this.listItems.length - 1;
                    if (LaunchBarListViewer.this.selIndex < maxIdx) {
                        LaunchBarListViewer.this.listItems[LaunchBarListViewer.this.selIndex + 1].setSelected(true);
                        if (LaunchBarListViewer.this.scrollBucket < 6) {
                            LaunchBarListViewer launchBarListViewer = LaunchBarListViewer.this;
                            launchBarListViewer.scrollBucket = launchBarListViewer.scrollBucket + 1;
                        } else {
                            int sY = ((LaunchBarListViewer)LaunchBarListViewer.this).listScrolled.getOrigin().y;
                            LaunchBarListViewer.this.listScrolled.setOrigin(0, sY + LaunchBarListViewer.this.itemH);
                        }
                    } else if (LaunchBarListViewer.this.selIndex == maxIdx && maxIdx > 6) {
                        LaunchBarListViewer.this.listScrolled.setOrigin(0, LaunchBarListViewer.this.itemH * (maxIdx - 6 + 1));
                    }
                }
            } else if (e.detail == 32 || e.detail == 8) {
                if (e.keyCode == 0x1000001) {
                    if (LaunchBarListViewer.this.selIndex > 0) {
                        if (LaunchBarListViewer.this.scrollBucket > 0) {
                            LaunchBarListViewer launchBarListViewer = LaunchBarListViewer.this;
                            launchBarListViewer.scrollBucket = launchBarListViewer.scrollBucket - 1;
                        } else {
                            int sY = ((LaunchBarListViewer)LaunchBarListViewer.this).listScrolled.getOrigin().y;
                            LaunchBarListViewer.this.listScrolled.setOrigin(0, sY - LaunchBarListViewer.this.itemH);
                        }
                        LaunchBarListViewer.this.listItems[LaunchBarListViewer.this.selIndex - 1].setSelected(true);
                    } else if (LaunchBarListViewer.this.selIndex == 0) {
                        LaunchBarListViewer.this.listScrolled.setOrigin(0, 0);
                    }
                } else if (currItem.editButton != null) {
                    currItem.editButton.setSelected(false);
                    currItem.editButton.redraw();
                }
            } else if (e.detail == 4) {
                LaunchBarListViewer.this.setDefaultSelection(new StructuredSelection(currItem.element));
            } else if (e.detail == 2) {
                LaunchBarListViewer.this.setDefaultSelection(new StructuredSelection());
            }
        }
    };
    private KeyListener lisItemKeyListener = new KeyListener(){

        public void keyReleased(KeyEvent e) {
        }

        public void keyPressed(KeyEvent e) {
            if (e.character != '\u0000' && e.character >= ' ' && !LaunchBarListViewer.this.filterControl.isVisible()) {
                if (LaunchBarListViewer.this.listItems.length <= 1) {
                    return;
                }
                LaunchBarListViewer.this.filterControl.setVisible(true);
                LaunchBarListViewer.this.filterControl.setFocus();
                LaunchBarListViewer.this.filterControl.getParent().layout(true);
                LaunchBarListViewer.this.filterControl.getFilterText().setText(String.valueOf(e.character));
                LaunchBarListViewer.this.filterControl.getFilterText().setSelection(1);
            } else if (e.character == '\u001b') {
                LaunchBarListViewer.this.setDefaultSelection(new StructuredSelection());
            }
        }
    };

    public LaunchBarListViewer(Composite parent) {
        this.filterControl = new FilterControl(parent);
        this.listScrolled = new ScrolledComposite(parent, 262656);
        this.listScrolled.setLayoutData((Object)new GridData(4, 4, true, true));
        this.listScrolled.setExpandHorizontal(true);
        this.listComposite = new Composite((Composite)this.listScrolled, 0);
        this.listScrolled.setContent((Control)this.listComposite);
        this.listComposite.setLayout((Layout)GridLayoutFactory.fillDefaults().spacing(0, 0).create());
        this.selIndex = -1;
        this.scrollBucket = 0;
        this.filterControl.attachListViewer(this);
        this.historySupported = false;
        this.setHistoryPreferenceName(this.getHistoryPreferenceName());
    }

    private void createSash(final Composite listComp) {
        if (this.separatorIndex < 0 || !this.historySupported) {
            return;
        }
        this.sash = new Sash(listComp, 2304);
        this.sash.setLayoutData((Object)new GridData(768));
        if (this.separatorIndex < this.listItems.length) {
            this.sash.moveAbove((Control)this.listItems[this.separatorIndex]);
        } else {
            this.sash.moveBelow(null);
        }
        this.sash.setBackground(Display.getDefault().getSystemColor(26));
        this.sash.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                LaunchBarListViewer.this.separatorIndex = (e.y + LaunchBarListViewer.this.itemH / 2) / LaunchBarListViewer.this.itemH;
            }
        });
        this.sash.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
                LaunchBarListViewer.this.setSeparatorIndex(LaunchBarListViewer.this.separatorIndex);
                if (LaunchBarListViewer.this.separatorIndex >= 0) {
                    if (LaunchBarListViewer.this.separatorIndex < LaunchBarListViewer.this.listItems.length) {
                        LaunchBarListViewer.this.sash.moveAbove((Control)LaunchBarListViewer.this.listItems[LaunchBarListViewer.this.separatorIndex]);
                    } else {
                        LaunchBarListViewer.this.sash.moveBelow(null);
                    }
                    listComp.layout();
                }
            }

            public void mouseDown(MouseEvent e) {
                if (!Platform.getOS().equals("macosx")) {
                    LaunchBarListViewer.this.sash.moveAbove(null);
                }
            }

            public void mouseDoubleClick(MouseEvent e) {
            }
        });
        this.sash.setToolTipText(Messages.LaunchBarListViewer_0);
    }

    public Control getControl() {
        return this.listScrolled;
    }

    protected void inputChanged(Object input, Object oldInput) {
        super.inputChanged(input, oldInput);
        this.refreshAll();
    }

    protected void refreshAll() {
        Control[] children;
        this.selIndex = -1;
        Control[] controlArray = children = this.listComposite.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            control.dispose();
            ++n2;
        }
        Object[] origElements = this.getElements();
        Object[] elements = this.filterElements(origElements);
        this.listItems = new ListItem[elements.length];
        if (elements.length > 0) {
            this.listItems[0] = this.createListItem(elements, 0);
            this.itemH = Math.max(this.listItems[0].computeSize((int)-1, (int)-1).y, 16);
            int i = 1;
            while (i < elements.length) {
                this.listItems[i] = this.createListItem(elements, i);
                ++i;
            }
            this.createSash(this.listComposite);
        }
        this.listComposite.pack(true);
        this.listComposite.layout(true, true);
        GridData gd = new GridData(4, 4, true, true);
        if (elements.length > 6) {
            Rectangle bounds = this.listItems[6].getBounds();
            gd.heightHint = Math.max(bounds.y + bounds.height, this.itemH * 7);
        }
        this.listScrolled.setLayoutData((Object)gd);
        this.listScrolled.layout(true);
    }

    private ListItem createListItem(Object[] elements, int i) {
        ListItem item = new ListItem(this.listComposite, 0, elements[i], i, (ILabelProvider)this.getLabelProvider());
        GridData gd = new GridData(4, 4, true, false);
        item.setLayoutData(gd);
        if (i <= 6) {
            item.lazyInit();
        } else {
            gd.heightHint = this.itemH;
        }
        return item;
    }

    protected Widget doFindInputItem(Object element) {
        return this.doFindItem(element);
    }

    protected Widget doFindItem(Object element) {
        if (this.listItems == null) {
            return null;
        }
        ListItem[] listItemArray = this.listItems;
        int n = this.listItems.length;
        int n2 = 0;
        while (n2 < n) {
            ListItem listItem = listItemArray[n2];
            if (listItem.element.equals(element)) {
                return listItem;
            }
            ++n2;
        }
        return null;
    }

    protected void doUpdateItem(Widget item, Object element, boolean fullMap) {
        if (item instanceof ListItem) {
            ((ListItem)item).lazyInit();
        }
    }

    protected List getSelectionFromWidget() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (this.selIndex >= 0) {
            arrayList.add(this.listItems[this.selIndex].element);
        }
        return arrayList;
    }

    protected void internalRefresh(Object element) {
        if (element == null || element == this.getRoot()) {
            this.refreshAll();
            return;
        }
        ListItem item = (ListItem)this.doFindItem(element);
        ILabelProvider lp = (ILabelProvider)this.getLabelProvider();
        if (lp == null || item == null) {
            return;
        }
        item.setImage(lp.getImage(element));
        item.setText(lp.getText(element));
    }

    private Object[] filterElements(Object[] elements) {
        Object[] topElements = (Object[])elements.clone();
        if (this.getComparator() != null) {
            this.getComparator().sort((Viewer)this, elements);
        }
        if (this.getTopComparator() != null) {
            this.getTopComparator().sort((Viewer)this, topElements);
        }
        Object[] result = elements;
        if (this.getFilters() != null) {
            ViewerFilter[] viewerFilterArray = this.getFilters();
            int n = viewerFilterArray.length;
            int n2 = 0;
            while (n2 < n) {
                ViewerFilter f = viewerFilterArray[n2];
                result = f.filter((Viewer)this, null, result);
                ++n2;
            }
        }
        if (this.separatorIndex <= 0 || !this.historySupported) {
            return result;
        }
        if (this.separatorIndex >= topElements.length) {
            return topElements;
        }
        Object[] descsCopy = new ILaunchDescriptor[this.separatorIndex + result.length];
        System.arraycopy(topElements, 0, descsCopy, 0, this.separatorIndex);
        System.arraycopy(result, 0, descsCopy, this.separatorIndex, result.length);
        return descsCopy;
    }

    private Object[] getElements() {
        IStructuredContentProvider cp = (IStructuredContentProvider)this.getContentProvider();
        if (cp == null) {
            return new Object[0];
        }
        Object[] elements = cp.getElements(this.getInput());
        return elements;
    }

    public void reveal(Object element) {
    }

    public void setDefaultSelection(StructuredSelection selection) {
        this.finalSelection = true;
        this.setSelection((ISelection)selection, true);
    }

    protected void setSelectionToWidget(List l, boolean reveal) {
        if (l.size() == 0) {
            return;
        }
        Object sel = l.get(0);
        Widget wid = this.doFindItem(sel);
        if (wid instanceof ListItem) {
            ListItem listItem = (ListItem)wid;
            listItem.setSelected(true);
        }
    }

    public int getSeparatorIndex() {
        return this.separatorIndex;
    }

    public void setSeparatorIndex(int separatorIndex) {
        this.separatorIndex = separatorIndex;
        if (separatorIndex <= 0) {
            return;
        }
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        String prefName = this.getHistoryPreferenceName();
        if (prefName != null && store.getInt(prefName) != this.getSeparatorIndex()) {
            store.setValue(prefName, this.getSeparatorIndex());
        }
    }

    protected String getHistoryPreferenceName() {
        return this.historyPref;
    }

    public int getItemCount() {
        return this.listItems.length;
    }

    public Object getTopFilteredElement() {
        if (this.listItems.length > 0) {
            if (this.separatorIndex <= 0 || this.separatorIndex >= this.listItems.length || !this.historySupported) {
                return this.listItems[0].element;
            }
            return this.listItems[this.separatorIndex].element;
        }
        return null;
    }

    public Object getTopElement() {
        if (this.listItems.length > 0) {
            return this.listItems[0].element;
        }
        return null;
    }

    public ViewerComparator getTopComparator() {
        return this.historyComparator;
    }

    public void setHistoryComparator(ViewerComparator comp) {
        this.historyComparator = comp;
    }

    public void setHistoryComparator(Comparator<?> comp) {
        this.historyComparator = comp == null ? null : new LaunchBarListViewerComparator(comp);
    }

    public void setComparator(Comparator<?> comp) {
        this.setComparator(comp == null ? null : new LaunchBarListViewerComparator(comp));
    }

    public boolean isHistorySupported() {
        return this.historySupported;
    }

    public void setHistorySupported(boolean historySupported) {
        this.historySupported = historySupported;
    }

    public void setHistoryPreferenceName(String historyPreferenceName) {
        this.historyPref = historyPreferenceName;
        if (historyPreferenceName != null) {
            IPreferenceStore store = Activator.getDefault().getPreferenceStore();
            int separator = store.getInt(historyPreferenceName);
            if (separator <= 0) {
                separator = 1;
            }
            this.setSeparatorIndex(separator);
        }
    }

    public boolean isFinalSelection() {
        return this.finalSelection;
    }

    public void setFinalSelection(boolean finalSelection) {
        this.finalSelection = finalSelection;
    }

    public void setFocus() {
        if (this.selIndex >= 0 && this.listItems != null && this.listItems.length < this.selIndex) {
            this.listItems[this.selIndex].setFocus();
        } else {
            this.getControl().setFocus();
        }
    }

    public void setFilterVisible(boolean vis) {
        this.filterControl.setVisible(vis);
    }

    private static class LaunchBarListViewerComparator
    extends ViewerComparator {
        public LaunchBarListViewerComparator(Comparator<?> comp) {
            super(comp);
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            return this.getComparator().compare(e1, e2);
        }
    }

    private class ListItem
    extends Composite {
        protected final Object element;
        private Label icon;
        private Label label;
        protected EditButton editButton;
        private int index;
        private Color backgroundColor;
        private Color outlineColor;
        private Color highlightColor;
        private ILabelProvider labelProvider;

        public String toString() {
            return "[" + this.index + "] " + this.labelProvider.getText(this.element);
        }

        public ListItem(Composite parent, int style, Object element, int index, ILabelProvider labelProvider) {
            super(parent, style);
            this.backgroundColor = this.getDisplay().getSystemColor(25);
            this.outlineColor = this.getDisplay().getSystemColor(18);
            this.highlightColor = this.getDisplay().getSystemColor(26);
            this.element = element;
            this.index = index;
            this.labelProvider = labelProvider;
            this.setData(element);
            this.addPaintListener(new PaintListener(){

                public void paintControl(PaintEvent e) {
                    Point size = ListItem.this.getSize();
                    GC gc = e.gc;
                    gc.setForeground(ListItem.this.outlineColor);
                    gc.drawLine(0, size.y - 1, size.x, size.y - 1);
                    if (ListItem.this.label == null) {
                        ListItem.this.lazyInit();
                    }
                }
            });
        }

        protected void lazyInit() {
            Image image = this.labelProvider.getImage(this.element);
            int columns = 1;
            if (image != null) {
                ++columns;
            }
            GridLayout layout = new GridLayout(columns, false);
            layout.marginHeight = 7;
            layout.marginWidth = 7;
            this.setLayout((Layout)layout);
            MouseAdapter listItemMouseListener = new MouseAdapter(){

                public void mouseUp(MouseEvent e) {
                    LaunchBarListViewer.this.setDefaultSelection(new StructuredSelection(ListItem.this.element));
                }
            };
            MouseTrackAdapter listItemMouseTrackListener = new MouseTrackAdapter(){

                public void mouseEnter(MouseEvent e) {
                    ListItem.this.setSelected(true);
                }

                public void mouseExit(MouseEvent e) {
                    ListItem.this.setSelected(false);
                }
            };
            this.addMouseListener((MouseListener)listItemMouseListener);
            this.addMouseTrackListener((MouseTrackListener)listItemMouseTrackListener);
            if (image != null) {
                this.icon = this.createImage(this, image);
                this.icon.addMouseListener((MouseListener)listItemMouseListener);
                this.icon.addMouseTrackListener((MouseTrackListener)listItemMouseTrackListener);
            }
            this.label = this.createLabel(this, this.element);
            this.label.addMouseListener((MouseListener)listItemMouseListener);
            this.label.addMouseTrackListener((MouseTrackListener)listItemMouseTrackListener);
            this.addTraverseListener(LaunchBarListViewer.this.listItemTraverseListener);
            this.addKeyListener(LaunchBarListViewer.this.lisItemKeyListener);
            this.setBackground(this.backgroundColor);
            this.layout(true);
        }

        public void setSelected(boolean selected) {
            if (selected) {
                this.setBackground(this.highlightColor);
                int idx = this.getIndex();
                if (idx != LaunchBarListViewer.this.selIndex) {
                    if (LaunchBarListViewer.this.selIndex >= 0) {
                        LaunchBarListViewer.this.listItems[LaunchBarListViewer.this.selIndex].setBackground(this.backgroundColor);
                        LaunchBarListViewer.this.scrollBucket = Math.max(Math.min(LaunchBarListViewer.this.scrollBucket + idx - LaunchBarListViewer.this.selIndex, 6), 0);
                    } else {
                        LaunchBarListViewer.this.scrollBucket = Math.min(idx, 6);
                    }
                }
                LaunchBarListViewer.this.selIndex = idx;
            } else {
                this.setBackground(this.backgroundColor);
            }
            if (this.editButton != null) {
                this.editButton.setSelected(selected);
            }
        }

        public void setBackground(Color color) {
            super.setBackground(color);
            if (this.icon != null && !this.icon.isDisposed()) {
                this.icon.setBackground(color);
            }
            if (this.label != null && !this.label.isDisposed()) {
                this.label.setBackground(color);
            }
            if (this.editButton != null && !this.editButton.isDisposed()) {
                this.editButton.setBackground(color);
            }
        }

        public void setImage(Image image) {
            if (this.icon != null && !this.icon.isDisposed()) {
                this.icon.setImage(image);
            }
        }

        public void setText(String text) {
            if (!this.label.isDisposed()) {
                this.label.setText(text);
            }
        }

        public boolean setFocus() {
            super.setFocus();
            return true;
        }

        protected int getIndex() {
            return this.index;
        }

        private Label createImage(Composite parent, Image image) {
            Rectangle bounds = image.getBounds();
            boolean disposeImage = false;
            if (bounds.height > 16 || bounds.width > 16) {
                Image buttonImage = new Image((Device)this.getDisplay(), 16, 16);
                GC gc = new GC((Drawable)buttonImage);
                gc.setAntialias(1);
                gc.setInterpolation(2);
                gc.drawImage(image, 0, 0, image.getBounds().width, image.getBounds().height, 0, 0, 16, 16);
                gc.dispose();
                image = buttonImage;
                disposeImage = true;
            }
            Label icon = new Label(parent, 0);
            icon.setLayoutData((Object)new GridData(4, 0x1000000, false, true));
            icon.setImage(image);
            if (disposeImage) {
                final Image disposableImage = image;
                icon.addDisposeListener(new DisposeListener(){

                    public void widgetDisposed(DisposeEvent e) {
                        disposableImage.dispose();
                    }
                });
            }
            return icon;
        }

        private Label createLabel(Composite parent, Object element) {
            Label label = new Label(parent, 0);
            label.setLayoutData((Object)new GridData(4, 0x1000000, true, true));
            ILabelProvider labelProvider = (ILabelProvider)LaunchBarListViewer.this.getLabelProvider();
            label.setText(labelProvider.getText(element));
            if (labelProvider instanceof IFontProvider) {
                label.setFont(((IFontProvider)labelProvider).getFont(element));
            }
            return label;
        }
    }
}

