/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.launchbar.ui.internal.dialogs;

import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.ILaunchGroup;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.launchbar.ui.internal.Messages;
import org.eclipse.launchbar.ui.internal.dialogs.NewLaunchConfigEditPage;
import org.eclipse.launchbar.ui.internal.dialogs.NewLaunchConfigWizard;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public class NewLaunchConfigTypePage
extends WizardPage {
    private Table table;

    public NewLaunchConfigTypePage() {
        super(Messages.NewLaunchConfigTypePage_0);
        this.setTitle(Messages.NewLaunchConfigTypePage_1);
        this.setDescription(Messages.NewLaunchConfigTypePage_2);
    }

    public void createControl(Composite parent) {
        Composite comp = new Composite(parent, 0);
        comp.setLayout((Layout)new GridLayout(1, false));
        this.table = new Table(comp, 2052);
        GridData data = new GridData(4, 4, true, false);
        data.heightHint = 500;
        this.table.setLayoutData((Object)data);
        this.populateItems();
        this.setControl((Control)comp);
    }

    void populateItems() {
        ILaunchGroup group = ((NewLaunchConfigWizard)this.getWizard()).modePage.selectedGroup;
        if (group == null) {
            return;
        }
        this.table.removeAll();
        boolean haveItems = false;
        ILaunchConfigurationType[] iLaunchConfigurationTypeArray = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurationTypes();
        int n = iLaunchConfigurationTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ILaunchConfigurationType type = iLaunchConfigurationTypeArray[n2];
            if (type.isPublic() && type.getCategory() == null && type.supportsMode(group.getMode())) {
                haveItems = true;
                TableItem item = new TableItem(this.table, 0);
                item.setText(type.getName());
                ImageDescriptor imageDesc = DebugUITools.getDefaultImageDescriptor((Object)type);
                if (imageDesc != null) {
                    item.setImage(imageDesc.createImage());
                }
                item.setData((Object)type);
            }
            ++n2;
        }
        if (haveItems) {
            this.table.select(0);
        }
        this.setPageComplete(haveItems);
    }

    public boolean canFlipToNextPage() {
        return this.isPageComplete();
    }

    public IWizardPage getNextPage() {
        ILaunchConfigurationType type = (ILaunchConfigurationType)this.table.getSelection()[0].getData();
        NewLaunchConfigEditPage editPage = ((NewLaunchConfigWizard)this.getWizard()).editPage;
        editPage.changeLaunchConfigType(type);
        return editPage;
    }
}

