/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.launchbar.core;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.launchbar.core.ILaunchConfigurationProvider;
import org.eclipse.launchbar.core.ILaunchDescriptor;

public abstract class LaunchConfigurationProvider
implements ILaunchConfigurationProvider {
    protected static final String ORIGINAL_NAME = "org.eclipse.launchbar.core.originalName";

    @Override
    public ILaunchConfiguration createLaunchConfiguration(ILaunchManager launchManager, ILaunchDescriptor descriptor) throws CoreException {
        String name = launchManager.generateLaunchConfigurationName(this.getConfigurationName(descriptor));
        ILaunchConfigurationWorkingCopy wc = this.getLaunchConfigurationType().newInstance(null, name);
        wc.setAttribute(ORIGINAL_NAME, name);
        this.populateConfiguration(wc, descriptor);
        return wc.doSave();
    }

    protected String getConfigurationName(ILaunchDescriptor descriptor) {
        return descriptor.getName();
    }

    protected void populateConfiguration(ILaunchConfigurationWorkingCopy workingCopy, ILaunchDescriptor descriptor) throws CoreException {
    }

    protected boolean ownsConfiguration(ILaunchConfiguration configuration) throws CoreException {
        if (!configuration.getType().equals(this.getLaunchConfigurationType())) {
            return false;
        }
        return configuration.getAttribute(ORIGINAL_NAME, "").equals(configuration.getName());
    }
}

