/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.launchbar.core;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.launchbar.core.ILaunchDescriptor;
import org.eclipse.launchbar.core.LaunchConfigurationProvider;

public abstract class ProjectLaunchConfigurationProvider
extends LaunchConfigurationProvider {
    @Override
    protected void populateConfiguration(ILaunchConfigurationWorkingCopy workingCopy, ILaunchDescriptor descriptor) throws CoreException {
        super.populateConfiguration(workingCopy, descriptor);
        IProject project = (IProject)descriptor.getAdapter(IProject.class);
        IResource[] mappedResources = workingCopy.getMappedResources();
        if (mappedResources == null || mappedResources.length == 0) {
            workingCopy.setMappedResources(new IResource[]{project});
        } else {
            IResource[] newResources = new IResource[mappedResources.length + 1];
            System.arraycopy(mappedResources, 0, newResources, 0, mappedResources.length);
            newResources[mappedResources.length] = project;
            workingCopy.setMappedResources(newResources);
        }
    }

    protected IProject getProject(ILaunchConfiguration configuration) throws CoreException {
        IResource[] iResourceArray = configuration.getMappedResources();
        int n = iResourceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IResource resource = iResourceArray[n2];
            if (resource instanceof IProject) {
                return (IProject)resource;
            }
            ++n2;
        }
        return null;
    }

    @Override
    public Object launchConfigurationAdded(ILaunchConfiguration configuration) throws CoreException {
        if (!this.ownsConfiguration(configuration)) {
            return null;
        }
        IProject project = this.getProject(configuration);
        if (project == null) {
            return null;
        }
        return project;
    }

    @Override
    public boolean launchConfigurationRemoved(ILaunchConfiguration configuration) throws CoreException {
        return this.ownsConfiguration(configuration);
    }
}

