/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.launchbar.core.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationListener;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.ILaunchMode;
import org.eclipse.launchbar.core.ILaunchBarManager;
import org.eclipse.launchbar.core.ILaunchConfigurationProvider;
import org.eclipse.launchbar.core.ILaunchDescriptor;
import org.eclipse.launchbar.core.ILaunchDescriptorType;
import org.eclipse.launchbar.core.ILaunchObjectProvider;
import org.eclipse.launchbar.core.internal.Activator;
import org.eclipse.launchbar.core.internal.DefaultLaunchDescriptorType;
import org.eclipse.launchbar.core.internal.LaunchConfigProviderInfo;
import org.eclipse.launchbar.core.internal.LaunchDescriptorTypeInfo;
import org.eclipse.launchbar.core.internal.LaunchTargetTypeInfo;
import org.eclipse.launchbar.core.internal.Messages;
import org.eclipse.launchbar.core.internal.Pair;
import org.eclipse.remote.core.IRemoteConnection;
import org.eclipse.remote.core.IRemoteConnectionChangeListener;
import org.eclipse.remote.core.IRemoteConnectionType;
import org.eclipse.remote.core.IRemoteServicesManager;
import org.eclipse.remote.core.RemoteConnectionChangeEvent;
import org.eclipse.remote.core.launch.IRemoteLaunchConfigService;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class LaunchBarManager
implements ILaunchBarManager,
ILaunchConfigurationListener,
IRemoteConnectionChangeListener {
    private final List<Listener> listeners = new LinkedList<Listener>();
    private final List<ILaunchObjectProvider> objectProviders = new ArrayList<ILaunchObjectProvider>();
    private final Map<String, LaunchDescriptorTypeInfo> descriptorTypes = new HashMap<String, LaunchDescriptorTypeInfo>();
    private final Map<ILaunchDescriptorType, LaunchDescriptorTypeInfo> descriptorTypeInfo = new HashMap<ILaunchDescriptorType, LaunchDescriptorTypeInfo>();
    private final List<LaunchDescriptorTypeInfo> orderedDescriptorTypes = new LinkedList<LaunchDescriptorTypeInfo>();
    private final Map<String, LaunchTargetTypeInfo> targetTypes = new HashMap<String, LaunchTargetTypeInfo>();
    private final Map<String, List<String>> descriptorTargets = new HashMap<String, List<String>>();
    private final Map<String, Map<String, String>> configTypes = new HashMap<String, Map<String, String>>();
    private final Map<String, String> defaultTargetTypes = new HashMap<String, String>();
    private final Map<String, List<String>> configTargetTypes = new HashMap<String, List<String>>();
    private final Map<String, String> defaultConfigTargetTypes = new HashMap<String, String>();
    private final Map<String, LaunchConfigProviderInfo> configProviders = new HashMap<String, LaunchConfigProviderInfo>();
    private DefaultLaunchDescriptorType defaultDescriptorType = new DefaultLaunchDescriptorType();
    private final Map<Pair<String, String>, ILaunchDescriptor> descriptors = new LinkedHashMap<Pair<String, String>, ILaunchDescriptor>();
    private final Map<Object, ILaunchDescriptor> objectDescriptorMap = new HashMap<Object, ILaunchDescriptor>();
    private final Map<ILaunchDescriptor, Map<ILaunchConfigurationProvider, ILaunchConfiguration>> configs = new HashMap<ILaunchDescriptor, Map<ILaunchConfigurationProvider, ILaunchConfiguration>>();
    private final IRemoteServicesManager remoteServicesManager = this.getRemoteServicesManager();
    private final IRemoteLaunchConfigService remoteLaunchConfigService = this.getRemoteLaunchConfigService();
    private ILaunchDescriptor activeLaunchDesc;
    private ILaunchMode activeLaunchMode;
    private IRemoteConnection activeLaunchTarget;
    private static final String PREF_ACTIVE_LAUNCH_MODE = "activeLaunchMode";
    private static final String PREF_ACTIVE_LAUNCH_TARGET = "activeLaunchTarget";
    private static final String PREF_CONFIG_DESC_ORDER = "configDescList";
    boolean initialized = false;

    public LaunchBarManager() {
        this(true);
    }

    LaunchBarManager(boolean doInit) {
        this.remoteServicesManager.addRemoteConnectionChangeListener((IRemoteConnectionChangeListener)this);
        if (doInit) {
            new Job(Messages.LaunchBarManager_0){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        LaunchBarManager.this.init();
                        return Status.OK_STATUS;
                    }
                    catch (CoreException e) {
                        return e.getStatus();
                    }
                }
            }.schedule();
        }
    }

    IRemoteServicesManager getRemoteServicesManager() {
        return Activator.getService(IRemoteServicesManager.class);
    }

    IRemoteLaunchConfigService getRemoteLaunchConfigService() {
        return Activator.getService(IRemoteLaunchConfigService.class);
    }

    IExtensionPoint getExtensionPoint() throws CoreException {
        return Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.launchbar.core", "launchBarContributions");
    }

    ILaunchManager getLaunchManager() {
        return DebugPlugin.getDefault().getLaunchManager();
    }

    void init() throws CoreException {
        try {
            IEclipsePreferences store = this.getPreferenceStore();
            String configDescIds = store.get(PREF_CONFIG_DESC_ORDER, "");
            this.loadExtensions();
            LaunchDescriptorTypeInfo defaultInfo = new LaunchDescriptorTypeInfo("org.eclipse.launchbar.core.descriptorType.default", 0, this.defaultDescriptorType);
            this.addDescriptorType(defaultInfo);
            ILaunchManager launchManager = this.getLaunchManager();
            ILaunchConfiguration[] iLaunchConfigurationArray = launchManager.getLaunchConfigurations();
            int n = iLaunchConfigurationArray.length;
            int n2 = 0;
            while (n2 < n) {
                ILaunchConfiguration configuration = iLaunchConfigurationArray[n2];
                this.launchConfigurationAdded(configuration);
                ++n2;
            }
            launchManager.addLaunchConfigurationListener((ILaunchConfigurationListener)this);
            if (!configDescIds.isEmpty()) {
                String[] split = configDescIds.split(",");
                ILaunchDescriptor last = null;
                String[] stringArray = split;
                int n3 = split.length;
                int n4 = 0;
                while (n4 < n3) {
                    String id = stringArray[n4];
                    Pair<String, String> key = this.toId(id);
                    ILaunchDescriptor desc = this.descriptors.get(key);
                    if (desc != null) {
                        this.descriptors.remove(key);
                        this.descriptors.put(key, desc);
                        last = desc;
                    }
                    ++n4;
                }
                if (last != null) {
                    this.setActiveLaunchDescriptor(last);
                }
            }
        }
        finally {
            this.initialized = true;
        }
        this.fireActiveLaunchDescriptorChanged();
        this.fireActiveLaunchTargetChanged();
        this.fireActiveLaunchModeChanged();
        this.fireLaunchTargetsChanged();
    }

    private void loadExtensions() throws CoreException {
        String elementName;
        IConfigurationElement element;
        int n;
        int n2;
        IConfigurationElement[] iConfigurationElementArray;
        IExtension extension;
        IExtension[] extensions;
        IExtensionPoint point = this.getExtensionPoint();
        IExtension[] iExtensionArray = extensions = point.getExtensions();
        int n3 = extensions.length;
        int n4 = 0;
        while (n4 < n3) {
            extension = iExtensionArray[n4];
            iConfigurationElementArray = extension.getConfigurationElements();
            n2 = iConfigurationElementArray.length;
            n = 0;
            while (n < n2) {
                element = iConfigurationElementArray[n];
                try {
                    String targetTypeId;
                    Object info;
                    elementName = element.getName();
                    if (elementName.equals("descriptorType")) {
                        LaunchDescriptorTypeInfo typeInfo = new LaunchDescriptorTypeInfo(element);
                        this.addDescriptorType(typeInfo);
                    } else if (elementName.equals("targetType")) {
                        info = new LaunchTargetTypeInfo(element);
                        this.targetTypes.put(((LaunchTargetTypeInfo)info).getId(), (LaunchTargetTypeInfo)info);
                    } else if (elementName.equals("configType")) {
                        String descriptorTypeId = element.getAttribute("descriptorType");
                        targetTypeId = element.getAttribute("targetType");
                        String launchConfigTypeId = element.getAttribute("launchConfigurationType");
                        String isDefaultStr = element.getAttribute("isDefault");
                        boolean isDefault = isDefaultStr != null ? Boolean.parseBoolean(isDefaultStr) : false;
                        List<String> targetTypes = this.descriptorTargets.get(descriptorTypeId);
                        if (targetTypes == null) {
                            targetTypes = new ArrayList<String>();
                            this.descriptorTargets.put(descriptorTypeId, targetTypes);
                        }
                        targetTypes.add(targetTypeId);
                        Map<String, String> targetConfigMap = this.configTypes.get(descriptorTypeId);
                        if (targetConfigMap == null) {
                            targetConfigMap = new HashMap<String, String>();
                            this.configTypes.put(descriptorTypeId, targetConfigMap);
                        }
                        targetConfigMap.put(targetTypeId, launchConfigTypeId);
                        if (isDefault) {
                            this.defaultTargetTypes.put(descriptorTypeId, targetTypeId);
                        }
                        this.addDefaultConfigTargetType(launchConfigTypeId, targetTypeId, isDefault);
                    } else if (elementName.equals("configProvider")) {
                        info = new LaunchConfigProviderInfo(element);
                        this.configProviders.put(((LaunchConfigProviderInfo)info).getLaunchConfigTypeId(), (LaunchConfigProviderInfo)info);
                    } else if (elementName.equals("defaultConfigTarget")) {
                        String configTypeId = element.getAttribute("launchConfigurationType");
                        targetTypeId = element.getAttribute("targetType");
                        String isDefaultStr = element.getAttribute("isDefault");
                        boolean isDefault = isDefaultStr != null ? Boolean.parseBoolean(isDefaultStr) : false;
                        this.addDefaultConfigTargetType(configTypeId, targetTypeId, isDefault);
                    }
                }
                catch (CoreException e) {
                    Activator.log(e.getStatus());
                }
                ++n;
            }
            ++n4;
        }
        iExtensionArray = extensions;
        n3 = extensions.length;
        n4 = 0;
        while (n4 < n3) {
            extension = iExtensionArray[n4];
            iConfigurationElementArray = extension.getConfigurationElements();
            n2 = iConfigurationElementArray.length;
            n = 0;
            while (n < n2) {
                element = iConfigurationElementArray[n];
                try {
                    elementName = element.getName();
                    if (elementName.equals("objectProvider")) {
                        ILaunchObjectProvider objectProvider = (ILaunchObjectProvider)element.createExecutableExtension("class");
                        this.addObjectProvider(objectProvider);
                    }
                }
                catch (Exception e) {
                    Activator.log(e);
                }
                ++n;
            }
            ++n4;
        }
    }

    private void addDescriptorType(LaunchDescriptorTypeInfo typeInfo) throws CoreException {
        this.descriptorTypes.put(typeInfo.getId(), typeInfo);
        this.descriptorTypeInfo.put(typeInfo.getType(), typeInfo);
        Iterator<LaunchDescriptorTypeInfo> iterator = this.orderedDescriptorTypes.iterator();
        boolean inserted = false;
        int i = 0;
        while (i < this.orderedDescriptorTypes.size()) {
            if (iterator.next().getPriority() < typeInfo.getPriority()) {
                this.orderedDescriptorTypes.add(i, typeInfo);
                inserted = true;
                break;
            }
            ++i;
        }
        if (!inserted) {
            this.orderedDescriptorTypes.add(typeInfo);
        }
        Activator.trace("registered descriptor type " + typeInfo.getId());
    }

    private void addDefaultConfigTargetType(String configTypeId, String targetTypeId, boolean isDefault) {
        List<String> targetTypes = this.configTargetTypes.get(configTypeId);
        if (targetTypes == null) {
            targetTypes = new ArrayList<String>();
            this.configTargetTypes.put(configTypeId, targetTypes);
        }
        targetTypes.add(targetTypeId);
        if (isDefault) {
            this.defaultConfigTargetTypes.put(configTypeId, targetTypeId);
        }
    }

    private void addObjectProvider(ILaunchObjectProvider objectProvider) {
        this.objectProviders.add(objectProvider);
        try {
            objectProvider.init(this);
        }
        catch (Exception e) {
            Activator.log(e);
        }
    }

    private void addDescriptor(Object launchObject, ILaunchDescriptor descriptor) throws CoreException {
        this.descriptors.put(this.getDescriptorId(descriptor), descriptor);
        this.objectDescriptorMap.put(launchObject, descriptor);
        this.setActiveLaunchDescriptor(descriptor);
    }

    private void removeDescriptor(Object launchObject, ILaunchDescriptor descriptor) throws CoreException {
        this.objectDescriptorMap.remove(launchObject);
        if (descriptor != null) {
            Map<ILaunchConfigurationProvider, ILaunchConfiguration> configMap;
            this.descriptors.remove(this.getDescriptorId(descriptor));
            if (descriptor.equals(this.activeLaunchDesc)) {
                this.setActiveLaunchDescriptor(this.getLastUsedDescriptor());
            }
            if ((configMap = this.configs.get(descriptor)) != null) {
                this.configs.remove(descriptor);
                for (ILaunchConfiguration config : configMap.values()) {
                    config.delete();
                }
            }
        }
    }

    public String getDescriptorTypeId(ILaunchDescriptorType type) {
        return this.descriptorTypeInfo.get(type).getId();
    }

    private Pair<String, String> getDescriptorId(ILaunchDescriptor descriptor) {
        return new Pair<String, String>(this.getDescriptorTypeId(descriptor.getType()), descriptor.getName());
    }

    private Pair<String, String> getTargetId(IRemoteConnection target) {
        return new Pair<String, String>(target.getConnectionType().getId(), target.getName());
    }

    private String toString(Pair<String, String> key) {
        return String.valueOf(key.getFirst()) + ":" + key.getSecond();
    }

    private Pair<String, String> toId(String key) {
        int i = key.indexOf(58);
        if (i < 0) {
            return null;
        }
        return new Pair<String, String>(key.substring(0, i), key.substring(i + 1));
    }

    private LaunchTargetTypeInfo getTargetTypeInfo(ILaunchDescriptor descriptor, IRemoteConnection target) throws CoreException {
        ILaunchConfiguration config;
        List<String> targetTypeIds = this.descriptorTargets.get(this.getDescriptorTypeId(descriptor.getType()));
        if (targetTypeIds == null && (config = (ILaunchConfiguration)descriptor.getAdapter(ILaunchConfiguration.class)) != null) {
            targetTypeIds = this.configTargetTypes.get(config.getType().getIdentifier());
        }
        LaunchTargetTypeInfo targetTypeInfo = null;
        if (targetTypeIds != null) {
            for (String targetTypeId : targetTypeIds) {
                LaunchTargetTypeInfo info = this.targetTypes.get(targetTypeId);
                if (info == null || !info.matches(target)) continue;
                if (targetTypeInfo == null) {
                    targetTypeInfo = info;
                    continue;
                }
                if ((!targetTypeInfo.getOsName().isEmpty() || info.getOsName().isEmpty()) && (!targetTypeInfo.getOsArch().isEmpty() || info.getOsArch().isEmpty())) continue;
                targetTypeInfo = info;
            }
        }
        return targetTypeInfo;
    }

    private ILaunchConfigurationProvider getConfigProvider(ILaunchDescriptor descriptor, IRemoteConnection target) throws CoreException {
        String configProviderId;
        LaunchConfigProviderInfo providerInfo;
        if (descriptor == null || target == null) {
            return null;
        }
        LaunchTargetTypeInfo targetTypeInfo = this.getTargetTypeInfo(descriptor, target);
        if (targetTypeInfo == null) {
            return null;
        }
        Map<String, String> targetMap = this.configTypes.get(this.getDescriptorTypeId(descriptor.getType()));
        if (targetMap != null && (providerInfo = this.configProviders.get(configProviderId = targetMap.get(targetTypeInfo.getId()))) != null) {
            return providerInfo.getProvider();
        }
        return null;
    }

    public ILaunchConfigurationType getLaunchConfigurationType(ILaunchDescriptor descriptor, IRemoteConnection target) throws CoreException {
        Map<String, String> targetMap;
        if (descriptor == null) {
            return null;
        }
        LaunchTargetTypeInfo targetTypeInfo = this.getTargetTypeInfo(descriptor, target);
        if (targetTypeInfo != null && (targetMap = this.configTypes.get(this.getDescriptorTypeId(descriptor.getType()))) != null) {
            String configTypeId = targetMap.get(targetTypeInfo.getId());
            return this.getLaunchManager().getLaunchConfigurationType(configTypeId);
        }
        ILaunchConfiguration config = (ILaunchConfiguration)descriptor.getAdapter(ILaunchConfiguration.class);
        if (config != null) {
            return config.getType();
        }
        return null;
    }

    private ILaunchDescriptorType ownsLaunchObject(Object launchObject) throws CoreException {
        for (LaunchDescriptorTypeInfo descriptorInfo : this.orderedDescriptorTypes) {
            ILaunchDescriptorType descriptorType = descriptorInfo.getType();
            try {
                if (!descriptorType.ownsLaunchObject(launchObject)) continue;
                return descriptorType;
            }
            catch (Throwable e) {
                Activator.log(e);
            }
        }
        return null;
    }

    @Override
    public ILaunchDescriptor launchObjectAdded(Object launchObject) {
        Activator.trace("launch object added " + launchObject);
        ILaunchDescriptor desc = this.objectDescriptorMap.get(launchObject);
        if (desc != null) {
            return desc;
        }
        try {
            ILaunchDescriptorType type = this.ownsLaunchObject(launchObject);
            if (type != null && (desc = type.getDescriptor(launchObject)) != null) {
                this.addDescriptor(launchObject, desc);
            }
        }
        catch (Throwable e) {
            Activator.log(e);
        }
        return desc;
    }

    @Override
    public void launchObjectRemoved(Object launchObject) throws CoreException {
        Activator.trace("launch object removed " + launchObject);
        ILaunchDescriptor desc = this.objectDescriptorMap.get(launchObject);
        this.removeDescriptor(launchObject, desc);
    }

    @Override
    public void launchObjectChanged(Object launchObject) throws CoreException {
        ILaunchDescriptor origDesc = this.objectDescriptorMap.get(launchObject);
        ILaunchDescriptorType newDescType = this.ownsLaunchObject(launchObject);
        if (!(newDescType == null || origDesc != null && origDesc.getType().equals(newDescType))) {
            ILaunchDescriptor newDesc;
            if (origDesc != null) {
                this.removeDescriptor(launchObject, origDesc);
            }
            if ((newDesc = newDescType.getDescriptor(launchObject)) != null) {
                this.addDescriptor(launchObject, newDesc);
            }
        }
    }

    protected ILaunchDescriptor getLastUsedDescriptor() {
        if (this.descriptors.size() == 0) {
            return null;
        }
        ILaunchDescriptor[] descs = this.descriptors.values().toArray(new ILaunchDescriptor[this.descriptors.size()]);
        return descs[descs.length - 1];
    }

    public ILaunchDescriptor[] getLaunchDescriptors() {
        ArrayList<ILaunchDescriptor> values = new ArrayList<ILaunchDescriptor>(this.descriptors.values());
        Collections.reverse(values);
        return values.toArray(new ILaunchDescriptor[values.size()]);
    }

    public ILaunchDescriptor getActiveLaunchDescriptor() {
        return this.activeLaunchDesc;
    }

    public void setActiveLaunchDescriptor(ILaunchDescriptor descriptor) throws CoreException {
        Activator.trace("set active descriptor " + descriptor);
        if (this.activeLaunchDesc == descriptor) {
            this.syncActiveTarget();
            this.syncActiveMode();
            Activator.trace("resync for " + descriptor);
            return;
        }
        if (descriptor != null && !this.descriptors.containsValue(descriptor)) {
            throw new IllegalStateException(Messages.LaunchBarManager_1);
        }
        if (descriptor == null) {
            descriptor = this.getLastUsedDescriptor();
        }
        this.activeLaunchDesc = descriptor;
        if (descriptor != null) {
            Pair<String, String> id = this.getDescriptorId(descriptor);
            this.descriptors.remove(id);
            this.descriptors.put(id, descriptor);
        }
        this.storeActiveDescriptor(this.activeLaunchDesc);
        this.fireActiveLaunchDescriptorChanged();
        this.syncActiveTarget();
        this.syncActiveMode();
    }

    private void storeActiveDescriptor(ILaunchDescriptor descriptor) {
        Activator.trace("new active config is stored " + descriptor);
        StringBuffer buff = new StringBuffer();
        for (Pair<String, String> key : this.descriptors.keySet()) {
            if (buff.length() > 0) {
                buff.append(',');
            }
            buff.append(this.toString(key));
        }
        this.setPreference((Preferences)this.getPreferenceStore(), PREF_CONFIG_DESC_ORDER, buff.toString());
    }

    private void syncActiveTarget() throws CoreException {
        IRemoteConnection storedTarget;
        Pair<String, String> id;
        IRemoteConnectionType remoteServices;
        if (this.activeLaunchDesc == null) {
            this.setActiveLaunchTarget(null);
            return;
        }
        String activeTargetId = this.getPerDescriptorStore().get(PREF_ACTIVE_LAUNCH_TARGET, null);
        if (activeTargetId != null && (remoteServices = this.remoteServicesManager.getConnectionType((id = this.toId(activeTargetId)).getFirst())) != null && (storedTarget = remoteServices.getConnection(id.getSecond())) != null && this.supportsTargetType(this.activeLaunchDesc, storedTarget)) {
            this.setActiveLaunchTarget(storedTarget);
            return;
        }
        this.setActiveLaunchTarget(this.getDefaultLaunchTarget(this.activeLaunchDesc));
    }

    private void syncActiveMode() throws CoreException {
        if (this.activeLaunchDesc == null || this.activeLaunchTarget == null) {
            this.setActiveLaunchMode(null);
            return;
        }
        ILaunchMode foundMode = null;
        String storedModeId = this.getPerDescriptorStore().get(PREF_ACTIVE_LAUNCH_MODE, null);
        String lastActiveModeId = this.activeLaunchMode == null ? null : this.activeLaunchMode.getIdentifier();
        ILaunchMode[] supportedModes = this.getLaunchModes();
        if (supportedModes.length > 0) {
            String[] modeNames = new String[]{storedModeId, lastActiveModeId, "run", "debug", supportedModes[0].getIdentifier()};
            int i = 0;
            while (i < modeNames.length) {
                foundMode = this.getLaunchManager().getLaunchMode(modeNames[i]);
                if (this.supportsMode(foundMode)) break;
                ++i;
            }
        }
        this.setActiveLaunchMode(foundMode);
    }

    private boolean supportsMode(ILaunchMode mode) throws CoreException {
        if (mode == null) {
            return false;
        }
        ILaunchMode[] supportedModes = this.getLaunchModes();
        int j = 0;
        while (j < supportedModes.length) {
            ILaunchMode lm = supportedModes[j];
            if (lm.equals(mode)) {
                return true;
            }
            ++j;
        }
        return false;
    }

    private void setPreference(Preferences store, String prefId, String value) {
        if (value != null) {
            store.put(prefId, value);
        } else {
            store.remove(prefId);
        }
        try {
            store.flush();
        }
        catch (BackingStoreException e) {
            Activator.log(e);
        }
    }

    private Preferences getPerDescriptorStore() {
        return this.getPerDescriptorStore(this.activeLaunchDesc);
    }

    private Preferences getPerDescriptorStore(ILaunchDescriptor launchDesc) {
        String string;
        if (launchDesc == null) {
            return this.getPreferenceStore();
        }
        try {
            string = this.toString(this.getDescriptorId(launchDesc));
        }
        catch (Exception e) {
            Activator.log(e);
            string = launchDesc.getName();
        }
        return this.getPreferenceStore().node(string);
    }

    IEclipsePreferences getPreferenceStore() {
        return InstanceScope.INSTANCE.getNode("org.eclipse.launchbar.core");
    }

    private void fireActiveLaunchDescriptorChanged() {
        if (!this.initialized) {
            return;
        }
        for (Listener listener : this.listeners) {
            try {
                listener.activeLaunchDescriptorChanged();
            }
            catch (Exception e) {
                Activator.log(e);
            }
        }
    }

    public ILaunchMode[] getLaunchModes() throws CoreException {
        ILaunchMode[] modes;
        if (this.activeLaunchTarget == null) {
            return new ILaunchMode[0];
        }
        ILaunchConfigurationType configType = this.getLaunchConfigurationType(this.activeLaunchDesc, this.activeLaunchTarget);
        if (configType == null) {
            return new ILaunchMode[0];
        }
        ArrayList<ILaunchMode> modeList = new ArrayList<ILaunchMode>();
        ILaunchMode[] iLaunchModeArray = modes = this.getLaunchManager().getLaunchModes();
        int n = modes.length;
        int n2 = 0;
        while (n2 < n) {
            ILaunchMode mode = iLaunchModeArray[n2];
            if (configType.supportsMode(mode.getIdentifier())) {
                modeList.add(mode);
            }
            ++n2;
        }
        return modeList.toArray(new ILaunchMode[modeList.size()]);
    }

    public ILaunchMode getActiveLaunchMode() {
        return this.activeLaunchMode;
    }

    public void setLaunchMode(ILaunchDescriptor desc, ILaunchMode mode) throws CoreException {
        if (desc == this.activeLaunchDesc) {
            this.setActiveLaunchMode(mode);
        } else {
            this.storeLaunchMode(desc, mode);
        }
    }

    public void setActiveLaunchMode(ILaunchMode mode) throws CoreException {
        if (this.activeLaunchMode == mode) {
            return;
        }
        if (this.activeLaunchDesc != null && mode != null && !this.supportsMode(mode)) {
            throw new IllegalStateException(Messages.LaunchBarManager_2);
        }
        this.activeLaunchMode = mode;
        this.storeLaunchMode(this.activeLaunchDesc, mode);
        this.fireActiveLaunchModeChanged();
    }

    private void fireActiveLaunchModeChanged() {
        if (!this.initialized) {
            return;
        }
        for (Listener listener : this.listeners) {
            try {
                listener.activeLaunchModeChanged();
            }
            catch (Exception e) {
                Activator.log(e);
            }
        }
    }

    private void storeLaunchMode(ILaunchDescriptor desc, ILaunchMode mode) {
        if (mode != null) {
            this.setPreference(this.getPerDescriptorStore(desc), PREF_ACTIVE_LAUNCH_MODE, mode.getIdentifier());
        }
    }

    public List<IRemoteConnection> getLaunchTargets(ILaunchDescriptor descriptor) throws CoreException {
        ILaunchConfiguration config;
        if (descriptor == null) {
            return Collections.emptyList();
        }
        List<String> targetTypeIds = this.descriptorTargets.get(this.getDescriptorTypeId(descriptor.getType()));
        if (targetTypeIds == null && (config = (ILaunchConfiguration)descriptor.getAdapter(ILaunchConfiguration.class)) != null) {
            targetTypeIds = this.configTargetTypes.get(config.getType().getIdentifier());
        }
        return this.getLaunchTargets(targetTypeIds);
    }

    List<IRemoteConnection> getLaunchTargets(List<String> targetTypeIds) {
        if (targetTypeIds != null && targetTypeIds.size() > 0) {
            ArrayList<IRemoteConnection> targetList = new ArrayList<IRemoteConnection>();
            block0: for (IRemoteConnection connection : this.remoteServicesManager.getAllRemoteConnections()) {
                for (String targetTypeId : targetTypeIds) {
                    LaunchTargetTypeInfo info = this.targetTypes.get(targetTypeId);
                    if (info == null || !info.matches(connection)) continue;
                    targetList.add(connection);
                    continue block0;
                }
            }
            return targetList;
        }
        IRemoteConnectionType localServices = this.remoteServicesManager.getLocalConnectionType();
        return localServices.getConnections();
    }

    public IRemoteConnection getActiveLaunchTarget() {
        return this.activeLaunchTarget;
    }

    public void setLaunchTarget(ILaunchDescriptor desc, IRemoteConnection target) throws CoreException {
        if (desc == this.activeLaunchDesc) {
            this.setActiveLaunchTarget(target);
        } else {
            this.storeLaunchTarget(desc, target);
        }
    }

    public void setActiveLaunchTarget(IRemoteConnection target) throws CoreException {
        if (this.activeLaunchTarget == target) {
            return;
        }
        this.activeLaunchTarget = target;
        this.storeLaunchTarget(this.activeLaunchDesc, target);
        this.fireActiveLaunchTargetChanged();
    }

    private void storeLaunchTarget(ILaunchDescriptor desc, IRemoteConnection target) {
        if (target == null) {
            return;
        }
        this.setPreference(this.getPerDescriptorStore(desc), PREF_ACTIVE_LAUNCH_TARGET, this.toString(this.getTargetId(target)));
        try {
            ILaunchConfiguration config = this.getLaunchConfiguration(desc, target, false);
            if (config != null) {
                this.remoteLaunchConfigService.setActiveConnection(config, target);
            }
        }
        catch (CoreException e) {
            Activator.log(e);
        }
    }

    private void fireActiveLaunchTargetChanged() {
        if (!this.initialized) {
            return;
        }
        for (Listener listener : this.listeners) {
            try {
                listener.activeLaunchTargetChanged();
            }
            catch (Exception e) {
                Activator.log(e);
            }
        }
    }

    private IRemoteConnection getDefaultLaunchTarget(ILaunchDescriptor descriptor) throws CoreException {
        List<IRemoteConnection> targets = this.getLaunchTargets(descriptor);
        return targets.isEmpty() ? null : targets.get(0);
    }

    boolean supportsTargetType(ILaunchDescriptor descriptor, IRemoteConnection target) throws CoreException {
        return this.getConfigProvider(descriptor, target) != null;
    }

    public ILaunchConfiguration getActiveLaunchConfiguration() throws CoreException {
        return this.getLaunchConfiguration(this.activeLaunchDesc, this.activeLaunchTarget);
    }

    public ILaunchConfiguration getLaunchConfiguration(ILaunchDescriptor descriptor, IRemoteConnection target) throws CoreException {
        return this.getLaunchConfiguration(descriptor, target, true);
    }

    private ILaunchConfiguration getLaunchConfiguration(ILaunchDescriptor descriptor, IRemoteConnection target, boolean create) throws CoreException {
        if (descriptor == null) {
            return null;
        }
        ILaunchConfigurationProvider configProvider = this.getConfigProvider(descriptor, target);
        if (configProvider != null) {
            ILaunchConfiguration config;
            Map<ILaunchConfigurationProvider, ILaunchConfiguration> configMap = this.configs.get(descriptor);
            if (configMap != null) {
                config = configMap.get(configProvider);
                if (config != null) {
                    return config;
                }
            } else {
                configMap = new HashMap<ILaunchConfigurationProvider, ILaunchConfiguration>();
                this.configs.put(descriptor, configMap);
            }
            if (!create) {
                return null;
            }
            config = configProvider.createLaunchConfiguration(this.getLaunchManager(), descriptor);
            if (config != null) {
                configMap.put(configProvider, config);
                this.storeLaunchTarget(descriptor, target);
                return config;
            }
        }
        return (ILaunchConfiguration)descriptor.getAdapter(ILaunchConfiguration.class);
    }

    public void addListener(Listener listener) {
        if (listener == null) {
            return;
        }
        this.listeners.add(listener);
    }

    public void removeListener(Listener listener) {
        if (listener == null) {
            return;
        }
        this.listeners.remove(listener);
    }

    public void launchConfigurationAdded(ILaunchConfiguration configuration) {
        Activator.trace("launch config added " + configuration);
        try {
            ILaunchConfigurationProvider provider;
            Object launchObject;
            LaunchConfigProviderInfo info = this.configProviders.get(configuration.getType().getIdentifier());
            if (info != null && (launchObject = (provider = info.getProvider()).launchConfigurationAdded(configuration)) != null) {
                ILaunchDescriptor descriptor = this.objectDescriptorMap.get(launchObject);
                if (descriptor != null) {
                    Map<ILaunchConfigurationProvider, ILaunchConfiguration> configMap = this.configs.get(descriptor);
                    if (configMap == null) {
                        configMap = new HashMap<ILaunchConfigurationProvider, ILaunchConfiguration>();
                        this.configs.put(descriptor, configMap);
                    }
                    configMap.put(provider, configuration);
                }
                Activator.trace("launch config claimed by " + provider);
                return;
            }
        }
        catch (Throwable e) {
            Activator.log(e);
        }
        Activator.trace("launch config not claimed");
        try {
            ILaunchDescriptor desc = this.defaultDescriptorType.getDescriptor(configuration);
            this.addDescriptor(configuration, desc);
        }
        catch (CoreException e) {
            Activator.log(e.getStatus());
        }
    }

    public void launchConfigurationRemoved(ILaunchConfiguration configuration) {
        Activator.trace("launch config removed " + configuration);
        if (configuration.exists()) {
            try {
                ILaunchConfigurationProvider provider;
                LaunchConfigProviderInfo info = this.configProviders.get(configuration.getType().getIdentifier());
                if (info != null && (provider = info.getProvider()).launchConfigurationRemoved(configuration)) {
                    Activator.trace("launch config removed by " + provider);
                    return;
                }
            }
            catch (Throwable e) {
                Activator.log(e);
            }
        }
        Activator.trace("launch config not claimed");
        ILaunchDescriptor desc = this.objectDescriptorMap.get(configuration);
        if (desc == null) {
            for (Map.Entry<ILaunchDescriptor, Map<ILaunchConfigurationProvider, ILaunchConfiguration>> e1 : this.configs.entrySet()) {
                if (!e1.getValue().containsValue(configuration)) continue;
                for (Map.Entry<ILaunchConfigurationProvider, ILaunchConfiguration> e2 : e1.getValue().entrySet()) {
                    if (!e2.getValue().equals(configuration)) continue;
                    ILaunchConfigurationProvider provider = e2.getKey();
                    try {
                        provider.launchConfigurationRemoved(e2.getValue());
                        Activator.trace("launch config removed by " + provider);
                    }
                    catch (Throwable e) {
                        Activator.log(e);
                    }
                    e1.getValue().remove(provider);
                    return;
                }
                break;
            }
        } else {
            Map<ILaunchConfigurationProvider, ILaunchConfiguration> configMap = this.configs.get(desc);
            if (configMap != null) {
                for (ILaunchConfigurationProvider provider : configMap.keySet()) {
                    try {
                        if (!provider.launchConfigurationRemoved(configuration)) continue;
                        Activator.trace("launch config removed by " + provider);
                        return;
                    }
                    catch (Throwable e) {
                        Activator.log(e);
                    }
                }
            }
        }
        try {
            this.removeDescriptor(configuration, desc);
        }
        catch (CoreException e) {
            Activator.log(e.getStatus());
        }
    }

    public void launchConfigurationChanged(ILaunchConfiguration configuration) {
    }

    public void dispose() {
        ILaunchManager launchManager = this.getLaunchManager();
        launchManager.removeLaunchConfigurationListener((ILaunchConfigurationListener)this);
        for (ILaunchObjectProvider o : this.objectProviders) {
            try {
                o.dispose();
            }
            catch (Exception e) {
                Activator.log(e);
            }
        }
    }

    public void connectionChanged(RemoteConnectionChangeEvent event) {
        switch (event.getType()) {
            case 16: {
                try {
                    this.launchTargetAdded(event.getConnection());
                }
                catch (CoreException e) {
                    Activator.log(e);
                }
                break;
            }
            case 32: {
                try {
                    this.launchTargetRemoved(event.getConnection());
                }
                catch (CoreException e) {
                    Activator.log(e);
                }
                break;
            }
            case 8: {
                this.fireLaunchTargetsChanged();
                break;
            }
        }
    }

    private void fireLaunchTargetsChanged() {
        if (!this.initialized) {
            return;
        }
        for (Listener listener : this.listeners) {
            try {
                listener.launchTargetsChanged();
            }
            catch (Exception e) {
                Activator.log(e);
            }
        }
    }

    private void launchTargetAdded(IRemoteConnection target) throws CoreException {
        if (!this.initialized) {
            return;
        }
        this.fireLaunchTargetsChanged();
        if (this.activeLaunchDesc != null && this.supportsTargetType(this.activeLaunchDesc, target)) {
            this.setActiveLaunchTarget(target);
        }
    }

    private void launchTargetRemoved(IRemoteConnection target) throws CoreException {
        if (!this.initialized) {
            return;
        }
        this.fireLaunchTargetsChanged();
        if (this.activeLaunchTarget == target) {
            this.setActiveLaunchTarget(this.getDefaultLaunchTarget(this.activeLaunchDesc));
        }
    }

    public DefaultLaunchDescriptorType getDefaultDescriptorType() {
        return this.defaultDescriptorType;
    }

    public static interface Listener {
        public void activeLaunchDescriptorChanged();

        public void activeLaunchModeChanged();

        public void activeLaunchTargetChanged();

        public void launchDescriptorRemoved(ILaunchDescriptor var1);

        public void launchTargetsChanged();
    }
}

