/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.launchbar.core.internal;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.launchbar.core.ILaunchDescriptorType;
import org.eclipse.launchbar.core.internal.Activator;

public class LaunchDescriptorTypeInfo {
    private final String id;
    private int priority;
    private IConfigurationElement element;
    private ILaunchDescriptorType type;

    public LaunchDescriptorTypeInfo(IConfigurationElement element) {
        this.id = element.getAttribute("id");
        String priorityStr = element.getAttribute("priority");
        this.priority = 1;
        if (priorityStr != null) {
            try {
                this.priority = Integer.parseInt(priorityStr);
            }
            catch (NumberFormatException e) {
                Activator.log(e);
            }
        }
        this.element = element;
    }

    public LaunchDescriptorTypeInfo(String id, int priority, ILaunchDescriptorType type) {
        this.id = id;
        this.priority = priority;
        this.type = type;
    }

    public String getId() {
        return this.id;
    }

    public int getPriority() {
        return this.priority;
    }

    public ILaunchDescriptorType getType() throws CoreException {
        if (this.type == null) {
            this.type = (ILaunchDescriptorType)this.element.createExecutableExtension("class");
            this.element = null;
        }
        return this.type;
    }
}

