/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.launchbar.core.internal;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.remote.core.IRemoteConnection;

class LaunchTargetTypeInfo {
    private static final String ANY = "";
    private final String id;
    private final String connectionTypeId;
    private String osname;
    private String osarch;

    public LaunchTargetTypeInfo(IConfigurationElement ce) {
        this.id = ce.getAttribute("id");
        this.connectionTypeId = ce.getAttribute("connectionTypeId");
        if (this.id == null || this.connectionTypeId == null) {
            throw new NullPointerException();
        }
        this.osname = ce.getAttribute("osname");
        if (this.osname == null) {
            this.osname = ANY;
        }
        this.osarch = ce.getAttribute("osarch");
        if (this.osarch == null) {
            this.osarch = ANY;
        }
    }

    public String getId() {
        return this.id;
    }

    public String getRemoteServicesId() {
        return this.connectionTypeId;
    }

    public String getOsName() {
        return this.osname;
    }

    public String getOsArch() {
        return this.osarch;
    }

    public boolean matches(IRemoteConnection connection) {
        if (!this.connectionTypeId.equals(connection.getConnectionType().getId())) {
            return false;
        }
        if (!this.osname.isEmpty() && !this.osname.equals(connection.getProperty("os.name"))) {
            return false;
        }
        return this.osarch.isEmpty() || this.osarch.equals(connection.getProperty("os.arch"));
    }
}

