/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.launchbar.ui.internal.controls;

import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.eclipse.debug.core.ILaunchMode;
import org.eclipse.launchbar.core.ILaunchDescriptor;
import org.eclipse.launchbar.core.internal.LaunchBarManager;
import org.eclipse.launchbar.ui.internal.Activator;
import org.eclipse.launchbar.ui.internal.Messages;
import org.eclipse.launchbar.ui.internal.controls.CButton;
import org.eclipse.launchbar.ui.internal.controls.ConfigSelector;
import org.eclipse.launchbar.ui.internal.controls.ModeSelector;
import org.eclipse.launchbar.ui.internal.controls.TargetSelector;
import org.eclipse.remote.core.IRemoteConnection;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class LaunchBarControl
implements LaunchBarManager.Listener {
    public static final String ID = "org.eclipse.launchbar";
    public static final String CLASS_URI = "bundleclass://org.eclipse.launchbar.ui/" + LaunchBarControl.class.getName();
    private LaunchBarManager manager = Activator.getDefault().getLaunchBarUIManager().getManager();
    private ConfigSelector configSelector;
    private ModeSelector modeSelector;
    private TargetSelector targetSelector;
    private static final int SELECTION_DELAY = 200;

    @PostConstruct
    public void createControl(Composite parent) {
        this.manager.addListener((LaunchBarManager.Listener)this);
        Composite container = new Composite(parent, 0);
        container.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        GridLayout layout = new GridLayout(7, false);
        layout.marginHeight = 8;
        layout.marginWidth = 8;
        container.setLayout((Layout)layout);
        container.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                LaunchBarControl.this.dispose();
            }
        });
        this.createButton(container, "build", Messages.LaunchBarControl_Build, "org.eclipse.launchbar.ui.command.buildActive");
        this.createButton(container, "launch", Messages.LaunchBarControl_Launch, "org.eclipse.launchbar.ui.command.launchActive");
        this.createButton(container, "stop", Messages.LaunchBarControl_Stop, "org.eclipse.launchbar.ui.command.stop");
        this.modeSelector = new ModeSelector(container, 0);
        this.modeSelector.setLayoutData(new GridData(16384, 0x1000000, false, false));
        this.modeSelector.setInput(this.manager);
        this.configSelector = new ConfigSelector(container, 0);
        this.configSelector.setLayoutData(new GridData(16384, 0x1000000, false, false));
        this.configSelector.setInput(this.manager);
        Label label = new Label(container, 0);
        label.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        label.setText(String.valueOf(Messages.LaunchBarControl_0) + ":");
        this.targetSelector = new TargetSelector(container, 0);
        this.targetSelector.setLayoutData(new GridData(16384, 0x1000000, false, false));
        this.targetSelector.setInput(this.manager);
        this.syncSelectors();
    }

    protected void syncSelectors() {
        if (this.configSelector != null) {
            this.configSelector.setSelection(this.manager.getActiveLaunchDescriptor());
        }
        if (this.modeSelector != null) {
            this.modeSelector.setSelection(this.manager.getActiveLaunchMode());
        }
        if (this.targetSelector != null) {
            this.targetSelector.setSelection(this.manager.getActiveLaunchTarget());
        }
    }

    @PreDestroy
    public void dispose() {
        this.manager.removeListener((LaunchBarManager.Listener)this);
    }

    private void createButton(Composite parent, String imageName, String toolTipText, final String command) {
        CButton button = new CButton(parent, 0);
        button.setLayoutData(new GridData(4, 4, false, false));
        Image srcImage = Activator.getDefault().getImage(imageName);
        Image image = new Image((Device)parent.getDisplay(), srcImage, 0);
        button.setHotImage(image);
        button.setToolTipText(toolTipText);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Activator.runCommand(command, new String[0]);
            }
        });
    }

    public void activeLaunchDescriptorChanged() {
        if (this.configSelector != null) {
            ILaunchDescriptor descriptor = this.manager.getActiveLaunchDescriptor();
            this.configSelector.setDelayedSelection(descriptor, 200L);
        }
    }

    public void activeLaunchModeChanged() {
        if (this.modeSelector != null) {
            ILaunchMode mode = this.manager.getActiveLaunchMode();
            this.modeSelector.setDelayedSelection(mode, 200L);
        }
    }

    public void activeLaunchTargetChanged() {
        if (this.targetSelector != null) {
            IRemoteConnection target = this.manager.getActiveLaunchTarget();
            this.targetSelector.setDelayedSelection(target, 200L);
        }
    }

    public void launchDescriptorRemoved(ILaunchDescriptor descriptor) {
    }

    public void launchTargetsChanged() {
    }

    public ConfigSelector getConfigSelector() {
        return this.configSelector;
    }
}

