/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.launchbar.ui.internal.controls;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchMode;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.ui.ILaunchGroup;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.launchbar.core.internal.LaunchBarManager;
import org.eclipse.launchbar.ui.internal.Activator;
import org.eclipse.launchbar.ui.internal.Messages;
import org.eclipse.launchbar.ui.internal.controls.CSelector;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;

public class ModeSelector
extends CSelector {
    private static final String[] noModes = new String[]{"---"};
    private final LaunchBarManager manager = Activator.getDefault().getLaunchBarUIManager().getManager();

    public ModeSelector(Composite parent, int style) {
        super(parent, style);
        this.setToolTipText(Messages.ModeSelector_0);
        this.setContentProvider(new IStructuredContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                try {
                    Object[] modes = ModeSelector.this.manager.getLaunchModes();
                    if (modes.length > 0) {
                        return modes;
                    }
                }
                catch (CoreException e) {
                    Activator.log(e.getStatus());
                }
                return noModes;
            }
        });
        this.setLabelProvider((ILabelProvider)new LabelProvider(){
            private Map<ImageDescriptor, Image> images = new HashMap<ImageDescriptor, Image>();

            public void dispose() {
                super.dispose();
                for (Image image : this.images.values()) {
                    image.dispose();
                }
            }

            public Image getImage(Object element) {
                if (element instanceof ILaunchMode) {
                    ILaunchMode mode = (ILaunchMode)element;
                    try {
                        ILaunchGroup group = ModeSelector.this.getLaunchGroup(mode.getIdentifier());
                        if (group == null) {
                            group = ModeSelector.this.getDefaultLaunchGroup(mode.getIdentifier());
                        }
                        if (group != null) {
                            ImageDescriptor imageDesc = group.getImageDescriptor();
                            Image image = this.images.get(imageDesc);
                            if (image == null) {
                                image = imageDesc.createImage();
                                this.images.put(imageDesc, image);
                            }
                            return image;
                        }
                    }
                    catch (CoreException e) {
                        Activator.log(e.getStatus());
                    }
                }
                return super.getImage(element);
            }

            public String getText(Object element) {
                if (element instanceof ILaunchMode) {
                    ILaunchMode mode = (ILaunchMode)element;
                    try {
                        ILaunchGroup group = ModeSelector.this.getLaunchGroup(mode.getIdentifier());
                        if (group == null) {
                            group = ModeSelector.this.getDefaultLaunchGroup(mode.getIdentifier());
                        }
                        if (group != null) {
                            return group.getLabel().replace("&", "");
                        }
                    }
                    catch (CoreException e) {
                        Activator.log(e.getStatus());
                    }
                }
                return super.getText(element);
            }
        });
        this.setSorter(new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                if (o1 instanceof ILaunchMode && o2 instanceof ILaunchMode) {
                    String mode1 = ((ILaunchMode)o1).getIdentifier();
                    String mode2 = ((ILaunchMode)o2).getIdentifier();
                    if (mode1.equals("run")) {
                        if (mode2.equals("run")) {
                            return 0;
                        }
                        return -1;
                    }
                    if (mode2.equals("run")) {
                        return 1;
                    }
                    if (mode1.equals("debug")) {
                        if (mode2.equals("debug")) {
                            return 0;
                        }
                        return -1;
                    }
                    if (mode2.equals("debug")) {
                        return 1;
                    }
                }
                return 0;
            }
        });
    }

    protected ILaunchGroup getDefaultLaunchGroup(String mode) throws CoreException {
        String groupId = null;
        groupId = mode.equals("debug") ? "org.eclipse.debug.ui.launchGroup.debug" : (mode.equals("profile") ? "org.eclipse.debug.ui.launchGroup.profile" : "org.eclipse.debug.ui.launchGroup.run");
        if (groupId != null) {
            return DebugUIPlugin.getDefault().getLaunchConfigurationManager().getLaunchGroup(groupId);
        }
        return null;
    }

    protected ILaunchGroup getLaunchGroup(String mode) throws CoreException {
        ILaunchConfigurationType type = this.manager.getLaunchConfigurationType(this.manager.getActiveLaunchDescriptor(), this.manager.getActiveLaunchTarget());
        if (type == null) {
            return null;
        }
        return DebugUIPlugin.getDefault().getLaunchConfigurationManager().getLaunchGroup(type, mode);
    }

    @Override
    protected void fireSelectionChanged() {
        Object selected = this.getSelection();
        if (selected instanceof ILaunchMode) {
            ILaunchMode mode = (ILaunchMode)selected;
            try {
                this.manager.setActiveLaunchMode(mode);
            }
            catch (CoreException e) {
                Activator.log(e.getStatus());
            }
            catch (Exception e) {
                Activator.log(e);
            }
        }
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        return super.computeSize(150, hHint, changed);
    }

    @Override
    public void setSelection(Object element) {
        if (element == null) {
            element = noModes[0];
        }
        super.setSelection(element);
    }
}

