/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.launchbar.core;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.launchbar.core.AbstractLaunchConfigProvider;
import org.eclipse.launchbar.core.ILaunchBarManager;
import org.eclipse.launchbar.core.ILaunchDescriptor;
import org.eclipse.launchbar.core.internal.Activator;
import org.eclipse.remote.core.IRemoteConnection;

public abstract class PerTargetLaunchConfigProvider
extends AbstractLaunchConfigProvider {
    private final Map<ILaunchDescriptor, Map<IRemoteConnection, ILaunchConfiguration>> configMap = new HashMap<ILaunchDescriptor, Map<IRemoteConnection, ILaunchConfiguration>>();
    private final Map<ILaunchDescriptor, ILaunchConfiguration> defaultConfigs = new HashMap<ILaunchDescriptor, ILaunchConfiguration>();
    private final Collection<ILaunchConfiguration> ownedConfigs = new LinkedHashSet<ILaunchConfiguration>();

    protected ILaunchBarManager getManager() {
        return Activator.getService(ILaunchBarManager.class);
    }

    @Override
    public ILaunchConfiguration getLaunchConfiguration(ILaunchDescriptor descriptor, IRemoteConnection target) throws CoreException {
        if (target != null) {
            ILaunchConfiguration config;
            Map<IRemoteConnection, ILaunchConfiguration> targetMap = this.configMap.get(descriptor);
            if (targetMap != null && (config = targetMap.get(target)) != null) {
                return config;
            }
        } else {
            ILaunchConfiguration config = this.defaultConfigs.get(descriptor);
            if (config != null) {
                return config;
            }
        }
        return this.createLaunchConfiguration(descriptor, target);
    }

    protected abstract ILaunchDescriptor getLaunchDescriptor(ILaunchConfiguration var1) throws CoreException;

    protected abstract IRemoteConnection getLaunchTarget(ILaunchConfiguration var1) throws CoreException;

    protected boolean providesForNullTarget() {
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean addLaunchConfiguration(ILaunchConfiguration configuration) throws CoreException {
        ILaunchDescriptor desc = this.getLaunchDescriptor(configuration);
        if (desc == null) {
            return false;
        }
        IRemoteConnection target = this.getLaunchTarget(configuration);
        if (target == null) {
            if (!this.providesForNullTarget()) return false;
            this.defaultConfigs.put(desc, configuration);
        } else {
            Map<IRemoteConnection, ILaunchConfiguration> targetMap = this.configMap.get(desc);
            if (targetMap == null) {
                targetMap = new HashMap<IRemoteConnection, ILaunchConfiguration>();
                this.configMap.put(desc, targetMap);
            }
            targetMap.put(target, configuration);
        }
        this.ownedConfigs.add(configuration);
        return true;
    }

    @Override
    public boolean launchConfigurationAdded(ILaunchConfiguration configuration) throws CoreException {
        if (this.ownsLaunchConfiguration(configuration)) {
            return this.addLaunchConfiguration(configuration);
        }
        return false;
    }

    @Override
    public boolean launchConfigurationChanged(ILaunchConfiguration configuration) throws CoreException {
        if (this.ownsLaunchConfiguration(configuration)) {
            this.launchConfigurationRemoved(configuration);
            return this.addLaunchConfiguration(configuration);
        }
        if (this.ownedConfigs.contains(configuration)) {
            ILaunchBarManager manager = this.getManager();
            manager.launchConfigurationRemoved(configuration);
            manager.launchConfigurationAdded(configuration);
            return true;
        }
        return false;
    }

    @Override
    public boolean launchConfigurationRemoved(ILaunchConfiguration configuration) throws CoreException {
        this.ownedConfigs.remove(configuration);
        for (Map.Entry<ILaunchDescriptor, Map<IRemoteConnection, ILaunchConfiguration>> descEntry : this.configMap.entrySet()) {
            for (Map.Entry<IRemoteConnection, ILaunchConfiguration> targetEntry : descEntry.getValue().entrySet()) {
                if (!targetEntry.getValue().equals(configuration)) continue;
                descEntry.getValue().remove(targetEntry.getKey());
                if (descEntry.getValue().isEmpty()) {
                    this.configMap.remove(descEntry.getKey());
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public void launchDescriptorRemoved(ILaunchDescriptor descriptor) throws CoreException {
        ILaunchConfiguration config2;
        Map<IRemoteConnection, ILaunchConfiguration> map = this.configMap.remove(descriptor);
        if (map != null) {
            for (ILaunchConfiguration config2 : map.values()) {
                this.ownedConfigs.remove(config2);
                config2.delete();
            }
        }
        if ((config2 = this.defaultConfigs.remove(descriptor)) != null) {
            this.ownedConfigs.remove(config2);
            config2.delete();
        }
    }

    @Override
    public void launchTargetRemoved(IRemoteConnection target) throws CoreException {
        Iterator<Map.Entry<ILaunchDescriptor, Map<IRemoteConnection, ILaunchConfiguration>>> iterator = this.configMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<ILaunchDescriptor, Map<IRemoteConnection, ILaunchConfiguration>> descEntry = iterator.next();
            Map<IRemoteConnection, ILaunchConfiguration> map = descEntry.getValue();
            ILaunchConfiguration config = map.remove(target);
            if (config != null) {
                config.delete();
            }
            if (!map.isEmpty()) continue;
            iterator.remove();
        }
    }
}

