/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.launchbar.core.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationListener;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.ILaunchMode;
import org.eclipse.launchbar.core.ILaunchBarManager;
import org.eclipse.launchbar.core.ILaunchConfigurationProvider;
import org.eclipse.launchbar.core.ILaunchDescriptor;
import org.eclipse.launchbar.core.ILaunchDescriptorType;
import org.eclipse.launchbar.core.ILaunchObjectProvider;
import org.eclipse.launchbar.core.internal.Activator;
import org.eclipse.launchbar.core.internal.LaunchConfigProviderInfo;
import org.eclipse.launchbar.core.internal.LaunchDescriptorTypeInfo;
import org.eclipse.launchbar.core.internal.Messages;
import org.eclipse.launchbar.core.internal.Pair;
import org.eclipse.remote.core.IRemoteConnection;
import org.eclipse.remote.core.IRemoteConnectionChangeListener;
import org.eclipse.remote.core.IRemoteConnectionType;
import org.eclipse.remote.core.IRemoteServicesManager;
import org.eclipse.remote.core.RemoteConnectionChangeEvent;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class LaunchBarManager
implements ILaunchBarManager,
IRemoteConnectionChangeListener {
    private final List<Listener> listeners = new LinkedList<Listener>();
    private final List<ILaunchObjectProvider> objectProviders = new ArrayList<ILaunchObjectProvider>();
    private final Map<String, LaunchDescriptorTypeInfo> descriptorTypes = new HashMap<String, LaunchDescriptorTypeInfo>();
    private List<LaunchDescriptorTypeInfo> orderedDescriptorTypes;
    private final Map<ILaunchDescriptorType, LaunchDescriptorTypeInfo> descriptorTypeInfo = new HashMap<ILaunchDescriptorType, LaunchDescriptorTypeInfo>();
    private final Map<String, List<LaunchConfigProviderInfo>> configProviders = new HashMap<String, List<LaunchConfigProviderInfo>>();
    private final Map<Pair<String, String>, ILaunchDescriptor> descriptors = new LinkedHashMap<Pair<String, String>, ILaunchDescriptor>();
    private final Map<Object, ILaunchDescriptor> objectDescriptorMap = new HashMap<Object, ILaunchDescriptor>();
    private final IRemoteServicesManager remoteServicesManager = this.getRemoteServicesManager();
    private ILaunchDescriptor activeLaunchDesc;
    private ILaunchMode activeLaunchMode;
    private IRemoteConnection activeLaunchTarget;
    private static final String PREF_ACTIVE_LAUNCH_MODE = "activeLaunchMode";
    private static final String PREF_ACTIVE_LAUNCH_TARGET = "activeLaunchTarget";
    private static final String PREF_CONFIG_DESC_ORDER = "configDescList";
    boolean initialized = false;

    public LaunchBarManager() {
        this(true);
    }

    LaunchBarManager(boolean doInit) {
        this.remoteServicesManager.addRemoteConnectionChangeListener((IRemoteConnectionChangeListener)this);
        if (doInit) {
            new Job(Messages.LaunchBarManager_0){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        LaunchBarManager.this.init();
                        return Status.OK_STATUS;
                    }
                    catch (CoreException e) {
                        return e.getStatus();
                    }
                }
            }.schedule();
        }
    }

    IRemoteServicesManager getRemoteServicesManager() {
        return Activator.getService(IRemoteServicesManager.class);
    }

    IExtensionPoint getExtensionPoint() throws CoreException {
        return Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.launchbar.core", "launchBarContributions");
    }

    ILaunchManager getLaunchManager() {
        return DebugPlugin.getDefault().getLaunchManager();
    }

    void init() throws CoreException {
        try {
            IEclipsePreferences store = this.getPreferenceStore();
            String configDescIds = store.get(PREF_CONFIG_DESC_ORDER, "");
            this.loadExtensions();
            ILaunchManager launchManager = this.getLaunchManager();
            ILaunchConfiguration[] iLaunchConfigurationArray = launchManager.getLaunchConfigurations();
            int n = iLaunchConfigurationArray.length;
            int n2 = 0;
            while (n2 < n) {
                ILaunchConfiguration configuration = iLaunchConfigurationArray[n2];
                this.launchConfigurationAdded(configuration);
                ++n2;
            }
            launchManager.addLaunchConfigurationListener((ILaunchConfigurationListener)this);
            if (!configDescIds.isEmpty()) {
                String[] split = configDescIds.split(",");
                ILaunchDescriptor last = null;
                String[] stringArray = split;
                int n3 = split.length;
                int n4 = 0;
                while (n4 < n3) {
                    String id = stringArray[n4];
                    Pair<String, String> key = this.toId(id);
                    ILaunchDescriptor desc = this.descriptors.get(key);
                    if (desc != null) {
                        this.descriptors.remove(key);
                        this.descriptors.put(key, desc);
                        last = desc;
                    }
                    ++n4;
                }
                if (last != null) {
                    this.setActiveLaunchDescriptor(last);
                }
            }
        }
        finally {
            this.initialized = true;
        }
        this.fireActiveLaunchDescriptorChanged();
        this.fireActiveLaunchTargetChanged();
        this.fireActiveLaunchModeChanged();
        this.fireLaunchTargetsChanged();
    }

    private void loadExtensions() throws CoreException {
        String elementName;
        IConfigurationElement element;
        int n;
        int n2;
        IConfigurationElement[] iConfigurationElementArray;
        IExtension extension;
        IExtension[] extensions;
        IExtensionPoint point = this.getExtensionPoint();
        IExtension[] iExtensionArray = extensions = point.getExtensions();
        int n3 = extensions.length;
        int n4 = 0;
        while (n4 < n3) {
            extension = iExtensionArray[n4];
            iConfigurationElementArray = extension.getConfigurationElements();
            n2 = iConfigurationElementArray.length;
            n = 0;
            while (n < n2) {
                element = iConfigurationElementArray[n];
                try {
                    elementName = element.getName();
                    if (elementName.equals("descriptorType")) {
                        LaunchDescriptorTypeInfo typeInfo = new LaunchDescriptorTypeInfo(element);
                        this.descriptorTypes.put(typeInfo.getId(), typeInfo);
                        if (this.configProviders.get(typeInfo.getId()) == null) {
                            this.configProviders.put(typeInfo.getId(), new ArrayList());
                        }
                    } else if (elementName.equals("configProvider")) {
                        LaunchConfigProviderInfo info = new LaunchConfigProviderInfo(element);
                        List<LaunchConfigProviderInfo> providers = this.configProviders.get(info.getDescriptorTypeId());
                        if (providers == null) {
                            providers = new ArrayList<LaunchConfigProviderInfo>();
                            this.configProviders.put(info.getDescriptorTypeId(), providers);
                        }
                        providers.add(info);
                    }
                }
                catch (Exception e) {
                    Activator.log(e);
                }
                ++n;
            }
            ++n4;
        }
        this.orderedDescriptorTypes = new ArrayList<LaunchDescriptorTypeInfo>(this.descriptorTypes.values());
        Collections.sort(this.orderedDescriptorTypes, new Comparator<LaunchDescriptorTypeInfo>(){

            @Override
            public int compare(LaunchDescriptorTypeInfo o1, LaunchDescriptorTypeInfo o2) {
                int p2;
                int p1 = o1.getPriority();
                if (p1 < (p2 = o2.getPriority())) {
                    return 1;
                }
                if (p1 > p2) {
                    return -1;
                }
                return 0;
            }
        });
        for (List<LaunchConfigProviderInfo> providers : this.configProviders.values()) {
            Collections.sort(providers, new Comparator<LaunchConfigProviderInfo>(){

                @Override
                public int compare(LaunchConfigProviderInfo o1, LaunchConfigProviderInfo o2) {
                    int p2;
                    int p1 = o1.getPriority();
                    if (p1 < (p2 = o2.getPriority())) {
                        return 1;
                    }
                    if (p1 > p2) {
                        return -1;
                    }
                    return 0;
                }
            });
        }
        iExtensionArray = extensions;
        n3 = extensions.length;
        int n5 = 0;
        while (n5 < n3) {
            extension = iExtensionArray[n5];
            iConfigurationElementArray = extension.getConfigurationElements();
            n2 = iConfigurationElementArray.length;
            n = 0;
            while (n < n2) {
                element = iConfigurationElementArray[n];
                try {
                    elementName = element.getName();
                    if (elementName.equals("objectProvider")) {
                        ILaunchObjectProvider objectProvider = (ILaunchObjectProvider)element.createExecutableExtension("class");
                        this.objectProviders.add(objectProvider);
                        objectProvider.init(this);
                    }
                }
                catch (Exception e) {
                    Activator.log(e);
                }
                ++n;
            }
            ++n5;
        }
    }

    private String toString(Pair<String, String> key) {
        return String.valueOf(key.getFirst()) + ":" + key.getSecond();
    }

    private Pair<String, String> toId(String key) {
        int i = key.indexOf(58);
        if (i < 0) {
            return null;
        }
        return new Pair<String, String>(key.substring(0, i), key.substring(i + 1));
    }

    public String getDescriptorTypeId(ILaunchDescriptorType type) {
        return this.descriptorTypeInfo.get(type).getId();
    }

    private Pair<String, String> getDescriptorId(ILaunchDescriptor descriptor) {
        return new Pair<String, String>(this.getDescriptorTypeId(descriptor.getType()), descriptor.getName());
    }

    private Pair<String, String> getTargetId(IRemoteConnection target) {
        return new Pair<String, String>(target.getConnectionType().getId(), target.getName());
    }

    private void addDescriptor(Object launchObject, ILaunchDescriptor descriptor) throws CoreException {
        this.descriptors.put(this.getDescriptorId(descriptor), descriptor);
        this.objectDescriptorMap.put(launchObject, descriptor);
        this.setActiveLaunchDescriptor(descriptor);
    }

    public ILaunchConfigurationType getLaunchConfigurationType(ILaunchDescriptor descriptor, IRemoteConnection target) throws CoreException {
        if (descriptor == null) {
            return null;
        }
        for (LaunchConfigProviderInfo providerInfo : this.configProviders.get(this.getDescriptorTypeId(descriptor.getType()))) {
            ILaunchConfigurationType type;
            if (!providerInfo.enabled(descriptor) || !providerInfo.enabled(target) || (type = providerInfo.getProvider().getLaunchConfigurationType(descriptor, target)) == null) continue;
            return type;
        }
        return null;
    }

    @Override
    public ILaunchDescriptor launchObjectAdded(Object launchObject) {
        Activator.trace("launch object added " + launchObject);
        ILaunchDescriptor desc = this.objectDescriptorMap.get(launchObject);
        if (desc != null) {
            return desc;
        }
        for (LaunchDescriptorTypeInfo descriptorInfo : this.orderedDescriptorTypes) {
            try {
                if (!descriptorInfo.enabled(launchObject)) continue;
                ILaunchDescriptorType type = descriptorInfo.getType();
                this.descriptorTypeInfo.put(type, descriptorInfo);
                desc = type.getDescriptor(launchObject);
                if (desc == null) continue;
                this.addDescriptor(launchObject, desc);
                return desc;
            }
            catch (Throwable e) {
                Activator.log(e);
            }
        }
        return null;
    }

    @Override
    public void launchObjectRemoved(Object launchObject) throws CoreException {
        Activator.trace("launch object removed " + launchObject);
        ILaunchDescriptor descriptor = this.objectDescriptorMap.remove(launchObject);
        if (descriptor != null) {
            this.descriptors.remove(this.getDescriptorId(descriptor));
            if (descriptor.equals(this.activeLaunchDesc)) {
                this.setActiveLaunchDescriptor(this.getLastUsedDescriptor());
            }
            for (LaunchConfigProviderInfo providerInfo : this.configProviders.get(this.getDescriptorTypeId(descriptor.getType()))) {
                if (!providerInfo.enabled(descriptor)) continue;
                providerInfo.getProvider().launchDescriptorRemoved(descriptor);
            }
        }
    }

    @Override
    public void launchObjectChanged(Object launchObject) throws CoreException {
        ILaunchDescriptor origDesc = this.objectDescriptorMap.get(launchObject);
        if (origDesc == null) {
            this.launchObjectAdded(launchObject);
            return;
        }
        ILaunchDescriptorType origDescType = origDesc.getType();
        try {
            ILaunchDescriptor newDesc = origDescType.getDescriptor(launchObject);
            if (newDesc == null) {
                this.objectDescriptorMap.remove(launchObject);
                this.launchObjectAdded(launchObject);
            } else if (!newDesc.equals(origDesc)) {
                this.objectDescriptorMap.put(launchObject, newDesc);
            }
        }
        catch (Throwable e) {
            Activator.log(e);
        }
    }

    private ILaunchDescriptor getLastUsedDescriptor() {
        if (this.descriptors.size() == 0) {
            return null;
        }
        ILaunchDescriptor[] descs = this.descriptors.values().toArray(new ILaunchDescriptor[this.descriptors.size()]);
        return descs[descs.length - 1];
    }

    public ILaunchDescriptor[] getLaunchDescriptors() {
        ArrayList<ILaunchDescriptor> values = new ArrayList<ILaunchDescriptor>(this.descriptors.values());
        Collections.reverse(values);
        return values.toArray(new ILaunchDescriptor[values.size()]);
    }

    public ILaunchDescriptor getActiveLaunchDescriptor() {
        return this.activeLaunchDesc;
    }

    public void setActiveLaunchDescriptor(ILaunchDescriptor descriptor) throws CoreException {
        Activator.trace("set active descriptor " + descriptor);
        if (this.activeLaunchDesc == descriptor) {
            this.syncActiveTarget();
            this.syncActiveMode();
            Activator.trace("resync for " + descriptor);
            return;
        }
        if (descriptor != null && !this.descriptors.containsValue(descriptor)) {
            throw new IllegalStateException(Messages.LaunchBarManager_1);
        }
        if (descriptor == null) {
            descriptor = this.getLastUsedDescriptor();
        }
        this.activeLaunchDesc = descriptor;
        if (descriptor != null) {
            Pair<String, String> id = this.getDescriptorId(descriptor);
            this.descriptors.remove(id);
            this.descriptors.put(id, descriptor);
        }
        this.storeActiveDescriptor(this.activeLaunchDesc);
        this.fireActiveLaunchDescriptorChanged();
        this.syncActiveTarget();
        this.syncActiveMode();
    }

    private void storeActiveDescriptor(ILaunchDescriptor descriptor) {
        Activator.trace("new active config is stored " + descriptor);
        StringBuffer buff = new StringBuffer();
        for (Pair<String, String> key : this.descriptors.keySet()) {
            if (buff.length() > 0) {
                buff.append(',');
            }
            buff.append(this.toString(key));
        }
        this.setPreference((Preferences)this.getPreferenceStore(), PREF_CONFIG_DESC_ORDER, buff.toString());
    }

    private void syncActiveTarget() throws CoreException {
        IRemoteConnection storedTarget;
        Pair<String, String> id;
        IRemoteConnectionType remoteServices;
        if (this.activeLaunchDesc == null) {
            this.setActiveLaunchTarget(null);
            return;
        }
        String activeTargetId = this.getPerDescriptorStore().get(PREF_ACTIVE_LAUNCH_TARGET, null);
        if (activeTargetId != null && (remoteServices = this.remoteServicesManager.getConnectionType((id = this.toId(activeTargetId)).getFirst())) != null && (storedTarget = remoteServices.getConnection(id.getSecond())) != null && this.supportsTarget(this.activeLaunchDesc, storedTarget)) {
            this.setActiveLaunchTarget(storedTarget);
            return;
        }
        this.setActiveLaunchTarget(this.getDefaultLaunchTarget(this.activeLaunchDesc));
    }

    private void syncActiveMode() throws CoreException {
        if (this.activeLaunchDesc == null || this.activeLaunchTarget == null) {
            this.setActiveLaunchMode(null);
            return;
        }
        ILaunchMode foundMode = null;
        String storedModeId = this.getPerDescriptorStore().get(PREF_ACTIVE_LAUNCH_MODE, null);
        String lastActiveModeId = this.activeLaunchMode == null ? null : this.activeLaunchMode.getIdentifier();
        ILaunchMode[] supportedModes = this.getLaunchModes();
        if (supportedModes.length > 0) {
            String[] modeNames = new String[]{storedModeId, lastActiveModeId, "run", "debug", supportedModes[0].getIdentifier()};
            int i = 0;
            while (i < modeNames.length) {
                foundMode = this.getLaunchManager().getLaunchMode(modeNames[i]);
                if (this.supportsMode(foundMode)) break;
                ++i;
            }
        }
        this.setActiveLaunchMode(foundMode);
    }

    private boolean supportsMode(ILaunchMode mode) throws CoreException {
        if (mode == null) {
            return false;
        }
        ILaunchMode[] supportedModes = this.getLaunchModes();
        int j = 0;
        while (j < supportedModes.length) {
            ILaunchMode lm = supportedModes[j];
            if (lm.equals(mode)) {
                return true;
            }
            ++j;
        }
        return false;
    }

    private void setPreference(Preferences store, String prefId, String value) {
        if (value != null) {
            store.put(prefId, value);
        } else {
            store.remove(prefId);
        }
        try {
            store.flush();
        }
        catch (BackingStoreException e) {
            Activator.log(e);
        }
    }

    private Preferences getPerDescriptorStore() {
        return this.getPerDescriptorStore(this.activeLaunchDesc);
    }

    private Preferences getPerDescriptorStore(ILaunchDescriptor launchDesc) {
        String string;
        if (launchDesc == null) {
            return this.getPreferenceStore();
        }
        try {
            string = this.toString(this.getDescriptorId(launchDesc));
        }
        catch (Exception e) {
            Activator.log(e);
            string = launchDesc.getName();
        }
        return this.getPreferenceStore().node(string);
    }

    IEclipsePreferences getPreferenceStore() {
        return InstanceScope.INSTANCE.getNode("org.eclipse.launchbar.core");
    }

    private void fireActiveLaunchDescriptorChanged() {
        if (!this.initialized) {
            return;
        }
        for (Listener listener : this.listeners) {
            try {
                listener.activeLaunchDescriptorChanged();
            }
            catch (Exception e) {
                Activator.log(e);
            }
        }
    }

    public ILaunchMode[] getLaunchModes() throws CoreException {
        ILaunchMode[] modes;
        if (this.activeLaunchTarget == null) {
            return new ILaunchMode[0];
        }
        ILaunchConfigurationType configType = this.getLaunchConfigurationType(this.activeLaunchDesc, this.activeLaunchTarget);
        if (configType == null) {
            return new ILaunchMode[0];
        }
        ArrayList<ILaunchMode> modeList = new ArrayList<ILaunchMode>();
        ILaunchMode[] iLaunchModeArray = modes = this.getLaunchManager().getLaunchModes();
        int n = modes.length;
        int n2 = 0;
        while (n2 < n) {
            ILaunchMode mode = iLaunchModeArray[n2];
            if (configType.supportsMode(mode.getIdentifier())) {
                modeList.add(mode);
            }
            ++n2;
        }
        return modeList.toArray(new ILaunchMode[modeList.size()]);
    }

    public ILaunchMode getActiveLaunchMode() {
        return this.activeLaunchMode;
    }

    public void setLaunchMode(ILaunchDescriptor desc, ILaunchMode mode) throws CoreException {
        if (desc == this.activeLaunchDesc) {
            this.setActiveLaunchMode(mode);
        } else {
            this.storeLaunchMode(desc, mode);
        }
    }

    public void setActiveLaunchMode(ILaunchMode mode) throws CoreException {
        if (this.activeLaunchMode == mode) {
            return;
        }
        if (this.activeLaunchDesc != null && mode != null && !this.supportsMode(mode)) {
            throw new IllegalStateException(Messages.LaunchBarManager_2);
        }
        this.activeLaunchMode = mode;
        this.storeLaunchMode(this.activeLaunchDesc, mode);
        this.fireActiveLaunchModeChanged();
    }

    private void fireActiveLaunchModeChanged() {
        if (!this.initialized) {
            return;
        }
        for (Listener listener : this.listeners) {
            try {
                listener.activeLaunchModeChanged();
            }
            catch (Exception e) {
                Activator.log(e);
            }
        }
    }

    private void storeLaunchMode(ILaunchDescriptor desc, ILaunchMode mode) {
        if (mode != null) {
            this.setPreference(this.getPerDescriptorStore(desc), PREF_ACTIVE_LAUNCH_MODE, mode.getIdentifier());
        }
    }

    public List<IRemoteConnection> getLaunchTargets(ILaunchDescriptor descriptor) throws CoreException {
        if (descriptor == null) {
            return Collections.emptyList();
        }
        ArrayList<IRemoteConnection> targets = new ArrayList<IRemoteConnection>();
        for (IRemoteConnection target : this.remoteServicesManager.getAllRemoteConnections()) {
            if (!this.supportsTarget(descriptor, target)) continue;
            targets.add(target);
        }
        return targets;
    }

    boolean supportsTarget(ILaunchDescriptor descriptor, IRemoteConnection target) throws CoreException {
        String descriptorTypeId = this.getDescriptorTypeId(descriptor.getType());
        for (LaunchConfigProviderInfo providerInfo : this.configProviders.get(descriptorTypeId)) {
            try {
                if (!providerInfo.enabled(descriptor) || !providerInfo.enabled(target) || !providerInfo.getProvider().supports(descriptor, target)) continue;
                return true;
            }
            catch (Throwable e) {
                Activator.log(e);
            }
        }
        return false;
    }

    public IRemoteConnection getActiveLaunchTarget() {
        return this.activeLaunchTarget;
    }

    public void setLaunchTarget(ILaunchDescriptor desc, IRemoteConnection target) throws CoreException {
        if (desc == this.activeLaunchDesc) {
            this.setActiveLaunchTarget(target);
        } else {
            this.storeLaunchTarget(desc, target);
        }
    }

    public void setActiveLaunchTarget(IRemoteConnection target) throws CoreException {
        if (this.activeLaunchTarget == target) {
            return;
        }
        this.activeLaunchTarget = target;
        this.storeLaunchTarget(this.activeLaunchDesc, target);
        this.syncActiveMode();
        this.fireActiveLaunchTargetChanged();
    }

    private void storeLaunchTarget(ILaunchDescriptor desc, IRemoteConnection target) {
        if (target == null) {
            return;
        }
        this.setPreference(this.getPerDescriptorStore(desc), PREF_ACTIVE_LAUNCH_TARGET, this.toString(this.getTargetId(target)));
    }

    private void fireActiveLaunchTargetChanged() {
        if (!this.initialized) {
            return;
        }
        for (Listener listener : this.listeners) {
            try {
                listener.activeLaunchTargetChanged();
            }
            catch (Exception e) {
                Activator.log(e);
            }
        }
    }

    private IRemoteConnection getDefaultLaunchTarget(ILaunchDescriptor descriptor) throws CoreException {
        List<IRemoteConnection> targets = this.getLaunchTargets(descriptor);
        return targets.isEmpty() ? null : targets.get(0);
    }

    public ILaunchConfiguration getActiveLaunchConfiguration() throws CoreException {
        return this.getLaunchConfiguration(this.activeLaunchDesc, this.activeLaunchTarget);
    }

    public ILaunchConfiguration getLaunchConfiguration(ILaunchDescriptor descriptor, IRemoteConnection target) throws CoreException {
        if (descriptor == null) {
            return null;
        }
        String descTypeId = this.getDescriptorTypeId(descriptor.getType());
        for (LaunchConfigProviderInfo providerInfo : this.configProviders.get(descTypeId)) {
            try {
                ILaunchConfiguration config;
                ILaunchConfigurationProvider provider;
                if (!providerInfo.enabled(descriptor) || !providerInfo.enabled(target) || !(provider = providerInfo.getProvider()).supports(descriptor, target) || (config = provider.getLaunchConfiguration(descriptor, target)) == null) continue;
                return config;
            }
            catch (Throwable e) {
                Activator.log(e);
            }
        }
        return null;
    }

    public void addListener(Listener listener) {
        if (listener == null) {
            return;
        }
        this.listeners.add(listener);
    }

    public void removeListener(Listener listener) {
        if (listener == null) {
            return;
        }
        this.listeners.remove(listener);
    }

    public void launchConfigurationAdded(ILaunchConfiguration configuration) {
        for (LaunchDescriptorTypeInfo descTypeInfo : this.orderedDescriptorTypes) {
            for (LaunchConfigProviderInfo providerInfo : this.configProviders.get(descTypeInfo.getId())) {
                try {
                    if (!providerInfo.enabled(configuration) || !providerInfo.getProvider().launchConfigurationAdded(configuration)) continue;
                    return;
                }
                catch (Throwable e) {
                    Activator.log(e);
                }
            }
        }
        this.launchObjectAdded(configuration);
    }

    public void launchConfigurationRemoved(ILaunchConfiguration configuration) {
        try {
            this.launchObjectRemoved(configuration);
        }
        catch (Throwable e) {
            Activator.log(e);
        }
        for (LaunchDescriptorTypeInfo descTypeInfo : this.orderedDescriptorTypes) {
            for (LaunchConfigProviderInfo providerInfo : this.configProviders.get(descTypeInfo.getId())) {
                try {
                    if (!providerInfo.enabled(configuration) || !providerInfo.getProvider().launchConfigurationRemoved(configuration)) continue;
                    return;
                }
                catch (Throwable e) {
                    Activator.log(e);
                }
            }
        }
    }

    public void launchConfigurationChanged(ILaunchConfiguration configuration) {
        if (configuration.isWorkingCopy()) {
            return;
        }
        for (LaunchDescriptorTypeInfo descTypeInfo : this.orderedDescriptorTypes) {
            for (LaunchConfigProviderInfo providerInfo : this.configProviders.get(descTypeInfo.getId())) {
                try {
                    if (!providerInfo.enabled(configuration) || !providerInfo.getProvider().launchConfigurationChanged(configuration)) continue;
                    return;
                }
                catch (Throwable e) {
                    Activator.log(e);
                }
            }
        }
    }

    public void dispose() {
        ILaunchManager launchManager = this.getLaunchManager();
        launchManager.removeLaunchConfigurationListener((ILaunchConfigurationListener)this);
        for (ILaunchObjectProvider o : this.objectProviders) {
            try {
                o.dispose();
            }
            catch (Exception e) {
                Activator.log(e);
            }
        }
    }

    public void connectionChanged(RemoteConnectionChangeEvent event) {
        switch (event.getType()) {
            case 16: {
                try {
                    this.launchTargetAdded(event.getConnection());
                }
                catch (CoreException e) {
                    Activator.log(e);
                }
                break;
            }
            case 32: {
                try {
                    this.launchTargetRemoved(event.getConnection());
                }
                catch (CoreException e) {
                    Activator.log(e);
                }
                break;
            }
            case 8: {
                this.fireLaunchTargetsChanged();
                break;
            }
        }
    }

    private void fireLaunchTargetsChanged() {
        if (!this.initialized) {
            return;
        }
        for (Listener listener : this.listeners) {
            try {
                listener.launchTargetsChanged();
            }
            catch (Exception e) {
                Activator.log(e);
            }
        }
    }

    private void launchTargetAdded(IRemoteConnection target) throws CoreException {
        if (!this.initialized) {
            return;
        }
        this.fireLaunchTargetsChanged();
        if (this.activeLaunchDesc != null && this.supportsTarget(this.activeLaunchDesc, target)) {
            this.setActiveLaunchTarget(target);
        }
    }

    private void launchTargetRemoved(IRemoteConnection target) throws CoreException {
        if (!this.initialized) {
            return;
        }
        this.fireLaunchTargetsChanged();
        if (this.activeLaunchTarget == target) {
            this.setActiveLaunchTarget(this.getDefaultLaunchTarget(this.activeLaunchDesc));
        }
    }

    public static interface Listener {
        public void activeLaunchDescriptorChanged();

        public void activeLaunchModeChanged();

        public void activeLaunchTargetChanged();

        public void launchDescriptorRemoved(ILaunchDescriptor var1);

        public void launchTargetsChanged();
    }
}

