/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.launchbar.core;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.launchbar.core.AbstractLaunchConfigProvider;
import org.eclipse.launchbar.core.ILaunchDescriptor;
import org.eclipse.launchbar.core.internal.Activator;
import org.eclipse.remote.core.IRemoteConnection;
import org.eclipse.remote.core.IRemoteConnectionType;
import org.eclipse.remote.core.IRemoteServicesManager;

public abstract class PerTargetLaunchConfigProvider
extends AbstractLaunchConfigProvider {
    public static final String ATTR_CONNECTION_TYPE = "connectionType";
    public static final String ATTR_CONNECTION_NAME = "connectionName";
    private final Map<ILaunchDescriptor, Map<IRemoteConnection, ILaunchConfiguration>> configMap = new HashMap<ILaunchDescriptor, Map<IRemoteConnection, ILaunchConfiguration>>();

    @Override
    public ILaunchConfiguration getLaunchConfiguration(ILaunchDescriptor descriptor, IRemoteConnection target) throws CoreException {
        ILaunchConfiguration config;
        Map<IRemoteConnection, ILaunchConfiguration> targetMap = this.configMap.get(descriptor);
        if (targetMap != null && (config = targetMap.get(target)) != null) {
            return config;
        }
        config = this.createLaunchConfiguration(descriptor, target);
        if (targetMap == null) {
            targetMap = new HashMap<IRemoteConnection, ILaunchConfiguration>();
            this.configMap.put(descriptor, targetMap);
        }
        targetMap.put(target, config);
        return config;
    }

    @Override
    protected void populateLaunchConfiguration(ILaunchDescriptor descriptor, IRemoteConnection target, ILaunchConfigurationWorkingCopy workingCopy) throws CoreException {
        super.populateLaunchConfiguration(descriptor, target, workingCopy);
        workingCopy.setAttribute(ATTR_CONNECTION_TYPE, target.getConnectionType().getId());
        workingCopy.setAttribute(ATTR_CONNECTION_NAME, target.getName());
    }

    public static IRemoteConnection getTarget(ILaunchConfiguration configuration) throws CoreException {
        IRemoteServicesManager remoteManager = Activator.getService(IRemoteServicesManager.class);
        String connectionTypeId = configuration.getAttribute(ATTR_CONNECTION_TYPE, "");
        if (connectionTypeId.isEmpty()) {
            return null;
        }
        IRemoteConnectionType connectionType = remoteManager.getConnectionType(connectionTypeId);
        if (connectionType == null) {
            return null;
        }
        String connectionName = configuration.getAttribute(ATTR_CONNECTION_NAME, "");
        if (connectionName.isEmpty()) {
            return null;
        }
        return connectionType.getConnection(connectionName);
    }

    @Override
    public boolean launchConfigurationRemoved(ILaunchConfiguration configuration) throws CoreException {
        for (Map.Entry<ILaunchDescriptor, Map<IRemoteConnection, ILaunchConfiguration>> descEntry : this.configMap.entrySet()) {
            for (Map.Entry<IRemoteConnection, ILaunchConfiguration> targetEntry : descEntry.getValue().entrySet()) {
                if (!targetEntry.getValue().equals(configuration)) continue;
                descEntry.getValue().remove(targetEntry.getKey());
                if (descEntry.getValue().isEmpty()) {
                    this.configMap.remove(descEntry.getKey());
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public void launchDescriptorRemoved(ILaunchDescriptor descriptor) throws CoreException {
        this.configMap.remove(descriptor);
    }

    @Override
    public void launchTargetRemoved(IRemoteConnection target) throws CoreException {
        for (Map.Entry<ILaunchDescriptor, Map<IRemoteConnection, ILaunchConfiguration>> descEntry : this.configMap.entrySet()) {
            descEntry.getValue().remove(target);
            if (!descEntry.getValue().isEmpty()) continue;
            this.configMap.remove(descEntry.getKey());
        }
    }
}

