/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.launchbar.core;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.launchbar.core.ILaunchDescriptor;
import org.eclipse.launchbar.core.PerTargetLaunchConfigProvider;
import org.eclipse.remote.core.IRemoteConnection;

public abstract class ProjectPerTargetLaunchConfigProvider
extends PerTargetLaunchConfigProvider {
    @Override
    public boolean supports(ILaunchDescriptor descriptor, IRemoteConnection target) throws CoreException {
        return descriptor.getAdapter(IProject.class) != null;
    }

    @Override
    protected void populateLaunchConfiguration(ILaunchDescriptor descriptor, IRemoteConnection target, ILaunchConfigurationWorkingCopy workingCopy) throws CoreException {
        super.populateLaunchConfiguration(descriptor, target, workingCopy);
        IProject project = (IProject)descriptor.getAdapter(IProject.class);
        IResource[] mappedResources = workingCopy.getMappedResources();
        if (mappedResources == null || mappedResources.length == 0) {
            workingCopy.setMappedResources(new IResource[]{project});
        } else {
            IResource[] newResources = new IResource[mappedResources.length + 1];
            System.arraycopy(mappedResources, 0, newResources, 0, mappedResources.length);
            newResources[mappedResources.length] = project;
            workingCopy.setMappedResources(newResources);
        }
    }
}

