/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.launchbar.core.internal;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.launchbar.core.ILaunchDescriptor;
import org.eclipse.launchbar.core.ILaunchDescriptorType;
import org.eclipse.launchbar.core.internal.Activator;
import org.eclipse.launchbar.core.internal.DefaultLaunchDescriptor;

public class DefaultLaunchDescriptorType
implements ILaunchDescriptorType {
    public static final String ID = "org.eclipse.launchbar.core.descriptorType.default";
    private Map<ILaunchConfiguration, DefaultLaunchDescriptor> descriptors = new HashMap<ILaunchConfiguration, DefaultLaunchDescriptor>();

    @Override
    public boolean ownsLaunchObject(Object element) {
        return element instanceof ILaunchConfiguration;
    }

    @Override
    public ILaunchDescriptor getDescriptor(Object element) {
        if (element instanceof ILaunchConfiguration) {
            ILaunchConfiguration config = (ILaunchConfiguration)element;
            try {
                if (config.getType() != null && config.getType().isPublic() && !config.getAttribute("org.eclipse.debug.ui.private", false)) {
                    DefaultLaunchDescriptor descriptor = this.descriptors.get(config);
                    if (descriptor == null) {
                        descriptor = new DefaultLaunchDescriptor(this, config);
                        this.descriptors.put(config, descriptor);
                    }
                    return descriptor;
                }
            }
            catch (CoreException ce) {
                Activator.log(ce.getStatus());
            }
        }
        return null;
    }
}

