/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.launchbar.ui.internal.controls;

import java.util.Comparator;
import java.util.List;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.NotEnabledException;
import org.eclipse.core.commands.NotHandledException;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.launchbar.core.internal.LaunchBarManager;
import org.eclipse.launchbar.ui.internal.Activator;
import org.eclipse.launchbar.ui.internal.LaunchBarUIManager;
import org.eclipse.launchbar.ui.internal.Messages;
import org.eclipse.launchbar.ui.internal.controls.CSelector;
import org.eclipse.remote.core.IRemoteConnection;
import org.eclipse.remote.ui.RemoteConnectionsLabelProvider;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;

public class TargetSelector
extends CSelector {
    private final LaunchBarUIManager uiManager = Activator.getDefault().getLaunchBarUIManager();
    private static final String[] noTargets = new String[]{"---"};

    public TargetSelector(Composite parent, int style) {
        super(parent, style);
        this.setContentProvider(new IStructuredContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                LaunchBarManager manager = TargetSelector.this.uiManager.getManager();
                try {
                    List targets = manager.getLaunchTargets(manager.getActiveLaunchDescriptor());
                    if (!targets.isEmpty()) {
                        return targets.toArray();
                    }
                }
                catch (CoreException e) {
                    Activator.log((Exception)((Object)e));
                }
                return noTargets;
            }
        });
        this.setLabelProvider((ILabelProvider)new RemoteConnectionsLabelProvider());
        this.setSorter(new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                String s1 = String.valueOf(o1);
                String s2 = String.valueOf(o2);
                return s1.compareTo(s2);
            }
        });
    }

    @Override
    public boolean isEditable(Object element) {
        return false;
    }

    @Override
    public void handleEdit(Object element) {
    }

    @Override
    public boolean hasActionArea() {
        return true;
    }

    @Override
    public void createActionArea(Composite parent) {
        Composite actionArea = new Composite(parent, 0);
        GridLayout actionLayout = new GridLayout();
        actionLayout.marginHeight = 0;
        actionLayout.marginWidth = 0;
        actionArea.setLayout((Layout)actionLayout);
        actionArea.setLayoutData((Object)new GridData(4, 4, true, false));
        final Composite createButton = new Composite(actionArea, 0);
        createButton.setLayoutData((Object)new GridData(4, 4, true, false));
        GridLayout buttonLayout = new GridLayout();
        buttonLayout.marginHeight = 7;
        buttonLayout.marginWidth = 7;
        createButton.setLayout((Layout)buttonLayout);
        createButton.setBackground(this.backgroundColor);
        createButton.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                Point size = createButton.getSize();
                GC gc = e.gc;
                gc.setForeground(TargetSelector.this.outlineColor);
                gc.drawLine(0, 0, size.x, 0);
            }
        });
        final Label createLabel = new Label(createButton, 0);
        createLabel.setLayoutData((Object)new GridData(4, 4, true, false));
        createLabel.setText(Messages.TargetSelector_CreateNewTarget);
        createLabel.setBackground(this.backgroundColor);
        MouseAdapter mouseListener = new MouseAdapter(){

            public void mouseUp(MouseEvent event) {
                try {
                    ICommandService commandService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
                    Command newConnectionCmd = commandService.getCommand("org.eclipse.remote.ui.command.newConnection");
                    newConnectionCmd.executeWithChecks(new ExecutionEvent());
                }
                catch (ExecutionException | NotEnabledException | NotHandledException | NotDefinedException e) {
                    Activator.log((Exception)e);
                }
            }
        };
        createButton.addMouseListener((MouseListener)mouseListener);
        createLabel.addMouseListener((MouseListener)mouseListener);
        MouseTrackAdapter mouseTrackListener = new MouseTrackAdapter(){

            public void mouseEnter(MouseEvent e) {
                createButton.setBackground(TargetSelector.this.highlightColor);
                createLabel.setBackground(TargetSelector.this.highlightColor);
            }

            public void mouseExit(MouseEvent e) {
                createButton.setBackground(TargetSelector.this.white);
                createLabel.setBackground(TargetSelector.this.white);
            }
        };
        createButton.addMouseTrackListener((MouseTrackListener)mouseTrackListener);
        createLabel.addMouseTrackListener((MouseTrackListener)mouseTrackListener);
    }

    @Override
    protected void fireSelectionChanged() {
        Object selection = this.getSelection();
        if (selection instanceof IRemoteConnection) {
            IRemoteConnection target = (IRemoteConnection)selection;
            try {
                this.uiManager.getManager().setActiveLaunchTarget(target);
            }
            catch (CoreException e) {
                Activator.log((Exception)((Object)e));
            }
        }
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        return super.computeSize(200, hHint, changed);
    }

    @Override
    public void setSelection(Object element) {
        if (element == null) {
            element = noTargets[0];
        }
        super.setSelection(element);
    }
}

