/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.launchbar.ui.internal.dialogs;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.internal.core.LaunchManager;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationManager;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationPresentationManager;
import org.eclipse.debug.ui.ILaunchConfigurationDialog;
import org.eclipse.debug.ui.ILaunchConfigurationTab;
import org.eclipse.debug.ui.ILaunchConfigurationTabGroup;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.launchbar.ui.internal.Activator;
import org.eclipse.launchbar.ui.internal.Messages;
import org.eclipse.launchbar.ui.internal.dialogs.NewLaunchConfigWizard;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class NewLaunchConfigEditPage
extends WizardPage {
    ILaunchConfigurationWorkingCopy workingCopy;
    ILaunchConfigurationTabGroup tabGroup;
    private Text nameText;
    private CTabFolder tabFolder;
    private LaunchConfigurationDialog launchConfigurationDialog = new LaunchConfigurationDialog();
    private LaunchConfigurationManager launchConfigurationMgr = DebugUIPlugin.getDefault().getLaunchConfigurationManager();

    public NewLaunchConfigEditPage() {
        super(Messages.NewLaunchConfigEditPage_0);
        this.setTitle(Messages.NewLaunchConfigEditPage_1);
        this.setDescription(Messages.NewLaunchConfigEditPage_2);
    }

    public void createControl(Composite parent) {
        Composite comp = new Composite(parent, 0);
        comp.setLayout((Layout)new GridLayout(2, false));
        Label label = new Label(comp, 0);
        label.setLayoutData((Object)new GridData());
        label.setText(String.valueOf(Messages.NewLaunchConfigEditPage_3) + ":");
        this.nameText = new Text(comp, 2048);
        this.nameText.setLayoutData((Object)new GridData(4, 4, true, false));
        ColorRegistry reg = JFaceResources.getColorRegistry();
        Color c1 = reg.get("org.eclipse.ui.workbench.ACTIVE_TAB_BG_START");
        Color c2 = reg.get("org.eclipse.ui.workbench.ACTIVE_TAB_BG_END");
        this.tabFolder = new CTabFolder(comp, 0x900800);
        GridData gridData = new GridData(4, 4, true, true);
        gridData.horizontalSpan = 2;
        this.tabFolder.setLayoutData((Object)gridData);
        this.tabFolder.setSimple(false);
        this.tabFolder.setSelectionBackground(new Color[]{c1, c2}, new int[]{100}, true);
        this.tabFolder.setSelectionForeground(reg.get("org.eclipse.ui.workbench.ACTIVE_TAB_TEXT_COLOR"));
        this.setControl((Control)comp);
        this.nameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String name = NewLaunchConfigEditPage.this.nameText.getText().trim();
                NewLaunchConfigEditPage.this.workingCopy.rename(name);
                String errMessage = NewLaunchConfigEditPage.this.checkName(name);
                if (errMessage == null) {
                    NewLaunchConfigEditPage.this.validateFields();
                } else {
                    NewLaunchConfigEditPage.this.setErrorMessage(errMessage);
                }
            }
        });
        this.validateFields();
    }

    private String checkName(String name) {
        try {
            ILaunchConfiguration config;
            if (name.isEmpty()) {
                return Messages.NewLaunchConfigEditPage_4;
            }
            ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
            if (manager.isExistingLaunchConfigurationName(name) && (config = ((LaunchManager)manager).findLaunchConfiguration(name)) != this.workingCopy.getOriginal()) {
                return Messages.NewLaunchConfigEditPage_5;
            }
        }
        catch (Exception e) {
            Activator.log(e);
            return e.getLocalizedMessage();
        }
        return null;
    }

    void changeLaunchConfigType(ILaunchConfigurationType type) {
        if (type == null) {
            return;
        }
        try {
            String initialMode = ((NewLaunchConfigWizard)this.getWizard()).modePage.selectedGroup.getMode();
            this.workingCopy = type.newInstance(null, Messages.NewLaunchConfigEditPage_6);
            this.tabGroup = LaunchConfigurationPresentationManager.getDefault().getTabGroup((ILaunchConfiguration)this.workingCopy, initialMode);
            CTabItem[] cTabItemArray = this.tabFolder.getItems();
            int n = cTabItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                CTabItem item = cTabItemArray[n2];
                item.dispose();
                ++n2;
            }
            this.tabGroup.createTabs((ILaunchConfigurationDialog)this.launchConfigurationDialog, initialMode);
            boolean firstTab = true;
            ILaunchConfigurationTab[] iLaunchConfigurationTabArray = this.tabGroup.getTabs();
            int n3 = iLaunchConfigurationTabArray.length;
            n = 0;
            while (n < n3) {
                ILaunchConfigurationTab tab = iLaunchConfigurationTabArray[n];
                tab.setLaunchConfigurationDialog((ILaunchConfigurationDialog)this.launchConfigurationDialog);
                tab.createControl((Composite)this.tabFolder);
                tab.setDefaults(this.workingCopy);
                if (firstTab) {
                    firstTab = false;
                }
                ++n;
            }
            iLaunchConfigurationTabArray = this.tabGroup.getTabs();
            n3 = iLaunchConfigurationTabArray.length;
            n = 0;
            while (n < n3) {
                ILaunchConfigurationTab tab = iLaunchConfigurationTabArray[n];
                tab.initializeFrom((ILaunchConfiguration)this.workingCopy);
                CTabItem tabItem = new CTabItem(this.tabFolder, 0);
                tabItem.setText(tab.getName());
                tabItem.setImage(!tab.isValid((ILaunchConfiguration)this.workingCopy) && tab.getErrorMessage() != null ? this.launchConfigurationMgr.getErrorTabImage(tab) : tab.getImage());
                tabItem.setControl(tab.getControl());
                ++n;
            }
            ((NewLaunchConfigWizard)this.getWizard()).cleanUpConfigs();
            this.tabFolder.setSelection(0);
            this.nameText.setText(this.workingCopy.getName());
        }
        catch (CoreException e) {
            Activator.log((Exception)((Object)e));
            return;
        }
    }

    boolean performFinish() {
        if (this.workingCopy == null) {
            return false;
        }
        ILaunchConfigurationTab[] iLaunchConfigurationTabArray = this.tabGroup.getTabs();
        int n = iLaunchConfigurationTabArray.length;
        int n2 = 0;
        while (n2 < n) {
            ILaunchConfigurationTab tab = iLaunchConfigurationTabArray[n2];
            tab.performApply(this.workingCopy);
            ++n2;
        }
        return true;
    }

    public void validateFields() {
        this.setPageComplete(false);
        if (this.workingCopy == null) {
            return;
        }
        String message = null;
        String old_msg = this.getErrorMessage();
        this.setErrorMessage(null);
        message = this.checkName(this.workingCopy.getName());
        if (message == null) {
            ILaunchConfigurationTab[] tabs = this.tabGroup.getTabs();
            int tLen = tabs.length;
            int tfLen = this.tabFolder.getItems().length;
            int i = 0;
            while (i < tLen) {
                CTabItem item;
                ILaunchConfigurationTab tab = tabs[i];
                try {
                    tab.isValid((ILaunchConfiguration)this.workingCopy);
                    message = tab.getErrorMessage();
                }
                catch (Exception e) {
                    message = e.getMessage();
                }
                if (tLen == tfLen && (old_msg == null && message != null || old_msg != null && message == null) && (item = this.tabFolder.getItem(i)) != null) {
                    item.setImage(message != null ? this.launchConfigurationMgr.getErrorTabImage(tab) : tab.getImage());
                }
                if (message != null) break;
                ++i;
            }
        }
        this.setErrorMessage(message);
        if (this.getErrorMessage() != null) {
            this.setPageComplete(false);
        } else {
            this.setPageComplete(true);
        }
    }

    private class LaunchConfigurationDialog
    implements ILaunchConfigurationDialog {
        private LaunchConfigurationDialog() {
        }

        public void run(boolean fork, boolean cancelable, IRunnableWithProgress runnable) throws InvocationTargetException, InterruptedException {
        }

        public void updateButtons() {
        }

        public void updateMessage() {
            NewLaunchConfigEditPage.this.validateFields();
        }

        public void setName(String name) {
        }

        public String generateName(String name) {
            if (name == null) {
                return "";
            }
            return DebugPlugin.getDefault().getLaunchManager().generateLaunchConfigurationName(name);
        }

        public ILaunchConfigurationTab[] getTabs() {
            return NewLaunchConfigEditPage.this.tabGroup.getTabs();
        }

        public ILaunchConfigurationTab getActiveTab() {
            int i = NewLaunchConfigEditPage.this.tabFolder.getSelectionIndex();
            return NewLaunchConfigEditPage.this.tabGroup.getTabs()[i];
        }

        public String getMode() {
            return ((NewLaunchConfigWizard)NewLaunchConfigEditPage.this.getWizard()).modePage.selectedGroup.getMode();
        }

        public void setActiveTab(ILaunchConfigurationTab tab) {
            ILaunchConfigurationTab[] tabs = NewLaunchConfigEditPage.this.tabGroup.getTabs();
            int tLen = tabs.length;
            int i = 0;
            while (i < tLen) {
                ILaunchConfigurationTab tabi = tabs[i];
                if (tabi.equals(tab)) {
                    this.setActiveTab(i);
                    break;
                }
                ++i;
            }
        }

        public void setActiveTab(int index) {
            NewLaunchConfigEditPage.this.tabFolder.setSelection(index);
        }
    }
}

