/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.launchbar.ui.controls.internal;

import java.util.Comparator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.CompositeImageDescriptor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.jface.window.SameShellProvider;
import org.eclipse.launchbar.core.ILaunchBarManager;
import org.eclipse.launchbar.core.target.ILaunchTarget;
import org.eclipse.launchbar.core.target.ILaunchTargetListener;
import org.eclipse.launchbar.core.target.ILaunchTargetManager;
import org.eclipse.launchbar.core.target.TargetStatus;
import org.eclipse.launchbar.ui.controls.internal.Activator;
import org.eclipse.launchbar.ui.controls.internal.CSelector;
import org.eclipse.launchbar.ui.controls.internal.Messages;
import org.eclipse.launchbar.ui.target.ILaunchTargetUIManager;
import org.eclipse.launchbar.ui.target.NewLaunchTargetWizardAction;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PropertyDialogAction;

public class TargetSelector
extends CSelector
implements ILaunchTargetListener {
    private final ILaunchBarManager manager = Activator.getService(ILaunchBarManager.class);
    private final ILaunchTargetUIManager targetUIManager = Activator.getService(ILaunchTargetUIManager.class);
    private final ILaunchTargetManager targetManager = Activator.getService(ILaunchTargetManager.class);
    private static final ILaunchTarget[] noTargets = new ILaunchTarget[]{ILaunchTarget.NULL_TARGET};

    public TargetSelector(Composite parent, int style) {
        super(parent, style);
        this.targetManager.addListener((ILaunchTargetListener)this);
        this.setContentProvider(new IStructuredContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                try {
                    return TargetSelector.this.manager.getLaunchTargets(TargetSelector.this.manager.getActiveLaunchDescriptor());
                }
                catch (CoreException e) {
                    Activator.log(e);
                    return noTargets;
                }
            }
        });
        this.setLabelProvider((ILabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof ILaunchTarget) {
                    ILaunchTarget target = (ILaunchTarget)element;
                    ILabelProvider provider = TargetSelector.this.targetUIManager.getLabelProvider(target);
                    return provider != null ? provider.getText((Object)target) : target.getId();
                }
                return super.getText(element);
            }

            public Image getImage(Object element) {
                if (element == ILaunchTarget.NULL_TARGET) {
                    return null;
                }
                if (element instanceof ILaunchTarget) {
                    ILaunchTarget target = (ILaunchTarget)element;
                    ILabelProvider provider = TargetSelector.this.targetUIManager.getLabelProvider(target);
                    if (provider != null) {
                        final Image baseImage = provider.getImage((Object)target);
                        final TargetStatus status = TargetSelector.this.targetManager.getStatus(target);
                        if (status.getCode() == TargetStatus.Code.OK) {
                            return baseImage;
                        }
                        String compId = String.format("%s.%s.%s", target.getTypeId(), target.getId(), status.getCode());
                        Image image = Activator.getDefault().getImageRegistry().get(compId);
                        if (image == null && baseImage != null) {
                            CompositeImageDescriptor desc = new CompositeImageDescriptor(){

                                protected Point getSize() {
                                    Rectangle bounds = baseImage.getBounds();
                                    return new Point(bounds.width, bounds.height);
                                }

                                protected void drawCompositeImage(int width, int height) {
                                    Image overlay = PlatformUI.getWorkbench().getSharedImages().getImage(status.getCode() == TargetStatus.Code.ERROR ? "IMG_DEC_FIELD_ERROR" : "IMG_DEC_FIELD_WARNING");
                                    this.drawImage(baseImage.getImageData(), 0, 0);
                                    int y = baseImage.getBounds().height - overlay.getBounds().height;
                                    this.drawImage(overlay.getImageData(), 0, y);
                                }
                            };
                            image = desc.createImage();
                            Activator.getDefault().getImageRegistry().put(compId, image);
                        }
                        return image;
                    }
                }
                return super.getImage(element);
            }
        });
        this.setSorter(new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                String s1 = String.valueOf(o1);
                String s2 = String.valueOf(o2);
                return s1.compareTo(s2);
            }
        });
    }

    @Override
    public boolean isEditable(Object element) {
        return true;
    }

    private ISelectionProvider getSelectionProvider() {
        return new ISelectionProvider(){

            public void setSelection(ISelection selection) {
            }

            public void removeSelectionChangedListener(ISelectionChangedListener listener) {
            }

            public ISelection getSelection() {
                return new StructuredSelection(TargetSelector.this.getSelection());
            }

            public void addSelectionChangedListener(ISelectionChangedListener listener) {
            }
        };
    }

    @Override
    public void handleEdit(Object element) {
        new PropertyDialogAction((IShellProvider)new SameShellProvider((Control)this.getShell()), this.getSelectionProvider()).run();
    }

    @Override
    public boolean hasActionArea() {
        return true;
    }

    @Override
    public void createActionArea(Composite parent) {
        final Composite createButton = new Composite(parent, 2048);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)createButton);
        GridLayoutFactory.fillDefaults().margins(7, 7).applyTo(createButton);
        createButton.setBackground(this.getBackground());
        final Label createLabel = new Label(createButton, 0);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)createLabel);
        createLabel.setBackground(this.getBackground());
        createLabel.setText(Messages.TargetSelector_CreateNewTarget);
        MouseAdapter mouseListener = new MouseAdapter(){

            public void mouseUp(MouseEvent event) {
                new NewLaunchTargetWizardAction().run();
            }
        };
        createButton.addMouseListener((MouseListener)mouseListener);
        createLabel.addMouseListener((MouseListener)mouseListener);
        MouseTrackAdapter mouseTrackListener = new MouseTrackAdapter(){

            public void mouseEnter(MouseEvent e) {
                Color highlightColor = TargetSelector.this.getHighlightColor();
                createButton.setBackground(highlightColor);
                createLabel.setBackground(highlightColor);
            }

            public void mouseExit(MouseEvent e) {
                Color backgroundColor = TargetSelector.this.getBackground();
                createButton.setBackground(backgroundColor);
                createLabel.setBackground(backgroundColor);
            }
        };
        createButton.addMouseTrackListener((MouseTrackListener)mouseTrackListener);
        createLabel.addMouseTrackListener((MouseTrackListener)mouseTrackListener);
    }

    @Override
    protected void fireSelectionChanged() {
        Object selection = this.getSelection();
        if (selection instanceof ILaunchTarget) {
            ILaunchTarget target = (ILaunchTarget)selection;
            try {
                this.manager.setActiveLaunchTarget(target);
            }
            catch (CoreException e) {
                Activator.log(e);
            }
        }
    }

    public void setToolTipText(ILaunchTarget target) {
        String text = String.valueOf(Messages.TargetSelector_ToolTipPrefix) + ": " + this.targetManager.getStatus(target).getMessage();
        this.setToolTipText(text);
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        return super.computeSize(200, hHint, changed);
    }

    @Override
    public void setSelection(Object element) {
        if (this.isDisposed()) {
            return;
        }
        if (element == null) {
            element = noTargets[0];
        } else if (element instanceof ILaunchTarget) {
            this.setToolTipText((ILaunchTarget)element);
        }
        super.setSelection(element);
    }

    @Override
    public void dispose() {
        super.dispose();
        this.targetManager.removeListener((ILaunchTargetListener)this);
    }

    @Override
    public void update(Object element) {
        super.update(element);
        if (element != null && element instanceof ILaunchTarget) {
            this.setToolTipText((ILaunchTarget)element);
        } else {
            this.setToolTipText(Messages.TargetSelector_ToolTipPrefix);
        }
    }

    public void launchTargetStatusChanged(ILaunchTarget target) {
        try {
            if (target.equals(this.manager.getActiveLaunchTarget())) {
                this.refresh();
            }
        }
        catch (CoreException e) {
            Activator.log(e);
        }
    }
}

