/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.launchbar.ui;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationListener;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchMode;
import org.eclipse.debug.ui.ILaunchGroup;
import org.eclipse.jface.dialogs.IPageChangingListener;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.launchbar.ui.internal.Activator;
import org.eclipse.launchbar.ui.internal.Messages;
import org.eclipse.launchbar.ui.internal.dialogs.NewLaunchConfigEditPage;
import org.eclipse.launchbar.ui.internal.dialogs.NewLaunchConfigModePage;
import org.eclipse.launchbar.ui.internal.dialogs.NewLaunchConfigTypePage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;

public class NewLaunchConfigWizard
extends Wizard
implements ILaunchConfigurationListener {
    private NewLaunchConfigModePage modePage = new NewLaunchConfigModePage();
    private NewLaunchConfigTypePage typePage = new NewLaunchConfigTypePage();
    private NewLaunchConfigEditPage editPage = new NewLaunchConfigEditPage();
    private List<ILaunchConfiguration> configsToDelete = new ArrayList<ILaunchConfiguration>();

    public NewLaunchConfigWizard() {
        this.setWindowTitle(Messages.NewLaunchConfigWizard_0);
        DebugPlugin.getDefault().getLaunchManager().addLaunchConfigurationListener((ILaunchConfigurationListener)this);
    }

    public void createPageControls(Composite pageContainer) {
        super.createPageControls(pageContainer);
        SelectionListener modePageListener = new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ILaunchGroup selectedGroup = NewLaunchConfigWizard.this.modePage.getSelectedGroup();
                NewLaunchConfigWizard.this.typePage.setLaunchGroup(selectedGroup);
                NewLaunchConfigWizard.this.editPage.setLaunchGroup(selectedGroup);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
                NewLaunchConfigWizard.this.getContainer().showPage(NewLaunchConfigWizard.this.modePage.getNextPage());
            }
        };
        this.modePage.addGroupSelectionListener(modePageListener);
        modePageListener.widgetSelected(null);
        SelectionListener typePageListener = new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                NewLaunchConfigWizard.this.editPage.setLaunchConfigType(NewLaunchConfigWizard.this.typePage.getSelectedType());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
                NewLaunchConfigWizard.this.getContainer().showPage(NewLaunchConfigWizard.this.typePage.getNextPage());
            }
        };
        this.typePage.addTypeSelectionListener(typePageListener);
        typePageListener.widgetSelected(null);
        this.editPage.setLaunchConfigType(this.typePage.getSelectedType());
    }

    public void setContainer(IWizardContainer wizardContainer) {
        super.setContainer(wizardContainer);
        if (wizardContainer != null) {
            ((WizardDialog)wizardContainer).addPageChangingListener((IPageChangingListener)this.editPage);
        }
    }

    public void addPages() {
        this.addPage((IWizardPage)this.modePage);
        this.addPage((IWizardPage)this.typePage);
        this.addPage((IWizardPage)this.editPage);
    }

    public boolean canFinish() {
        if (this.getPage(this.editPage.getName()) == null) {
            return false;
        }
        return super.canFinish();
    }

    public ILaunchConfigurationWorkingCopy getWorkingCopy() {
        return this.editPage.getWorkingCopy();
    }

    public ILaunchMode getLaunchMode() {
        String initMode = this.modePage.getSelectedGroup().getMode();
        return DebugPlugin.getDefault().getLaunchManager().getLaunchMode(initMode);
    }

    public boolean performFinish() {
        this.cleanUpConfigs();
        return this.editPage.performFinish();
    }

    public boolean performCancel() {
        this.cleanUpConfigs();
        return super.performCancel();
    }

    void cleanUpConfigs() {
        DebugPlugin.getDefault().getLaunchManager().removeLaunchConfigurationListener((ILaunchConfigurationListener)this);
        for (ILaunchConfiguration config : this.configsToDelete) {
            try {
                config.delete();
            }
            catch (CoreException e) {
                Activator.log((Exception)((Object)e));
            }
        }
    }

    public void launchConfigurationAdded(ILaunchConfiguration configuration) {
        if (!configuration.isWorkingCopy()) {
            this.configsToDelete.add(configuration);
        }
    }

    public void launchConfigurationChanged(ILaunchConfiguration configuration) {
    }

    public void launchConfigurationRemoved(ILaunchConfiguration configuration) {
        if (!configuration.isWorkingCopy()) {
            this.configsToDelete.remove(configuration);
        }
    }
}

