/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.launchbar.ui.internal.dialogs;

import java.util.HashSet;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.ILaunchGroup;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.launchbar.ui.internal.Messages;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public class NewLaunchConfigModePage
extends WizardPage {
    private Table table;

    public NewLaunchConfigModePage() {
        super(Messages.NewLaunchConfigModePage_0);
        this.setTitle(Messages.NewLaunchConfigModePage_1);
        this.setDescription(Messages.NewLaunchConfigModePage_2);
    }

    public void createControl(Composite parent) {
        ILaunchGroup group;
        Composite comp = new Composite(parent, 0);
        comp.setLayout((Layout)new GridLayout(1, false));
        this.table = new Table(comp, 2052);
        GridData data = new GridData(4, 4, true, true);
        this.table.setLayoutData((Object)data);
        HashSet<ILaunchGroup> done = new HashSet<ILaunchGroup>();
        ILaunchGroup[] iLaunchGroupArray = DebugUITools.getLaunchGroups();
        int n = iLaunchGroupArray.length;
        int n2 = 0;
        while (n2 < n) {
            group = iLaunchGroupArray[n2];
            if (group.getMode().equals("run")) {
                this.createModeItem(group);
                done.add(group);
            }
            ++n2;
        }
        iLaunchGroupArray = DebugUITools.getLaunchGroups();
        n = iLaunchGroupArray.length;
        n2 = 0;
        while (n2 < n) {
            group = iLaunchGroupArray[n2];
            if (group.getMode().equals("debug")) {
                this.createModeItem(group);
                done.add(group);
            }
            ++n2;
        }
        iLaunchGroupArray = DebugUITools.getLaunchGroups();
        n = iLaunchGroupArray.length;
        n2 = 0;
        while (n2 < n) {
            group = iLaunchGroupArray[n2];
            if (!done.contains(group)) {
                this.createModeItem(group);
            }
            ++n2;
        }
        if (this.table.getItemCount() > 0) {
            int i = 0;
            boolean hasDebug = false;
            TableItem[] tableItemArray = this.table.getItems();
            int n3 = tableItemArray.length;
            int n4 = 0;
            while (n4 < n3) {
                TableItem item = tableItemArray[n4];
                if ("debug".equals(((ILaunchGroup)item.getData()).getMode())) {
                    hasDebug = true;
                    this.table.select(i);
                    break;
                }
                ++i;
                ++n4;
            }
            if (!hasDebug) {
                this.table.select(0);
            }
        }
        this.setControl((Control)comp);
    }

    private void createModeItem(ILaunchGroup group) {
        if (group.getCategory() != null || !group.isPublic()) {
            return;
        }
        TableItem item = new TableItem(this.table, 0);
        item.setText(group.getLabel().replace("&", ""));
        ImageDescriptor imageDesc = group.getImageDescriptor();
        if (imageDesc != null) {
            item.setImage(imageDesc.createImage());
        }
        item.setData((Object)group);
    }

    public ILaunchGroup getSelectedGroup() {
        return (ILaunchGroup)this.table.getSelection()[0].getData();
    }

    public void addGroupSelectionListener(SelectionListener listener) {
        this.table.addSelectionListener(listener);
    }
}

