/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.cmake.is.core.internal.builtins;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import org.eclipse.cdt.cmake.is.core.IParserPreferences;
import org.eclipse.cdt.cmake.is.core.IParserPreferencesAccess;
import org.eclipse.cdt.cmake.is.core.internal.Plugin;
import org.eclipse.cdt.cmake.is.core.internal.builtins.Messages;
import org.eclipse.cdt.cmake.is.core.internal.builtins.RawIndexerInfo;
import org.eclipse.cdt.cmake.is.core.participant.IRawIndexerInfo;
import org.eclipse.cdt.cmake.is.core.participant.builtins.IBuiltinsDetectionBehavior;
import org.eclipse.cdt.cmake.is.core.participant.builtins.IBuiltinsOutputProcessor;
import org.eclipse.cdt.cmake.is.core.participant.builtins.OutputSniffer;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.ConsoleOutputStream;
import org.eclipse.cdt.core.ICommandLauncher;
import org.eclipse.cdt.core.envvar.IEnvironmentVariable;
import org.eclipse.cdt.core.envvar.IEnvironmentVariableManager;
import org.eclipse.cdt.core.resources.IConsole;
import org.eclipse.core.resources.IBuildConfiguration;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;

public class CompilerBuiltinsDetector {
    private static final String MARKER_ID = "org.eclipse.cdt.cmake.is.core.CompilerBuiltinsDetectorMarker";
    private final String sourceFileExtension;
    private final String command;
    private final List<String> builtinsDetectionArgs;
    private final IBuiltinsDetectionBehavior builtinsDetectionBehavior;
    private IBuildConfiguration buildConfiguration;
    private java.nio.file.Path buildDirectory;

    public CompilerBuiltinsDetector(IBuiltinsDetectionBehavior builtinsDetectionBehavior, String command, List<String> builtinsDetectionArgs, String sourceFileExtension) {
        this.sourceFileExtension = Objects.requireNonNull(sourceFileExtension, "sourceFileExtension");
        this.builtinsDetectionBehavior = Objects.requireNonNull(builtinsDetectionBehavior, "builtinsDetectionBehavior");
        this.command = Objects.requireNonNull(command, "command");
        this.builtinsDetectionArgs = Objects.requireNonNull(builtinsDetectionArgs, "builtinsDetectionArgs");
    }

    public IRawIndexerInfo detectBuiltins(IBuildConfiguration buildConfiguration, java.nio.file.Path theBuildDirectory, ICommandLauncher launcher, IConsole console, IProgressMonitor monitor) throws CoreException {
        this.buildConfiguration = Objects.requireNonNull(buildConfiguration, "buildConfiguration");
        this.buildDirectory = Objects.requireNonNull(theBuildDirectory, "buildDirectory");
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        RawIndexerInfo result = new RawIndexerInfo();
        List<String> argList = this.getCompilerArguments();
        argList.addAll(this.builtinsDetectionArgs);
        console = this.startOutputConsole(console);
        launcher.setProject(buildConfiguration.getProject());
        launcher.showCommand(console != null);
        Process proc = launcher.execute((IPath)new Path(this.command), argList.toArray(new String[argList.size()]), this.getEnvp(), (IPath)new Path(this.buildDirectory.toString()), monitor);
        if (proc != null) {
            int exitValue;
            try {
                proc.getOutputStream().close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            IBuiltinsOutputProcessor bopOut = this.builtinsDetectionBehavior.createCompilerOutputProcessor();
            IBuiltinsOutputProcessor bopErr = this.builtinsDetectionBehavior.createCompilerOutputProcessor();
            long start = System.currentTimeMillis();
            int state = launcher.waitAndRead((OutputStream)new OutputSniffer(bopOut, (OutputStream)(console == null ? null : console.getOutputStream()), result), (OutputStream)new OutputSniffer(bopErr, (OutputStream)(console == null ? null : console.getErrorStream()), result), monitor);
            if (console != null) {
                ConsoleOutputStream cis = console.getInfoStream();
                try {
                    cis.write(String.format(Messages.CompilerBuiltinsDetector_msg_detection_finished, System.currentTimeMillis() - start).getBytes());
                    cis.write("\n".getBytes());
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (state != 1 && (exitValue = proc.exitValue()) != 0 && !this.builtinsDetectionBehavior.suppressErrormessage()) {
                String errMsg = String.format(Messages.CompilerBuiltinsDetector_errmsg_command_failed, this.command, exitValue);
                this.createMarker(errMsg);
            }
        } else {
            this.createMarker(launcher.getErrorMessage());
        }
        return result;
    }

    private List<String> getCompilerArguments() {
        ArrayList<String> args = new ArrayList<String>();
        args.addAll(this.builtinsDetectionBehavior.getBuiltinsOutputEnablingArgs());
        String inputFile = this.getInputFile();
        if (inputFile != null) {
            args.add(inputFile);
        }
        return args;
    }

    private String[] getEnvp() {
        IEnvironmentVariableManager mngr = CCorePlugin.getDefault().getBuildEnvironmentManager();
        IEnvironmentVariable[] vars = mngr.getVariables(this.buildConfiguration, true);
        HashSet<String> strings = new HashSet<String>(vars.length);
        IEnvironmentVariable[] iEnvironmentVariableArray = vars;
        int n = vars.length;
        int n2 = 0;
        while (n2 < n) {
            IEnvironmentVariable var = iEnvironmentVariableArray[n2];
            if (!var.getName().startsWith("LANGUAGE=") && !var.getName().startsWith("LC_ALL=")) {
                strings.add(String.valueOf(var.getName()) + '=' + var.getValue());
            }
            ++n2;
        }
        strings.add("LANGUAGE=en");
        strings.add("LC_ALL=C.UTF-8");
        return strings.toArray(new String[strings.size()]);
    }

    private String getInputFile() {
        String specFileName = "detect_compiler_builtins." + this.sourceFileExtension;
        java.nio.file.Path specFile = this.buildDirectory.resolve(specFileName);
        if (!Files.exists(specFile, new LinkOption[0])) {
            try {
                Files.createDirectories(specFile.getParent(), new FileAttribute[0]);
                Files.createFile(specFile, new FileAttribute[0]);
            }
            catch (IOException e) {
                Plugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.cdt.cmake.is.core", "getInputFile()", (Throwable)e));
            }
        }
        return specFile.toString();
    }

    private void createMarker(String message) throws CoreException {
        IMarker marker = this.buildConfiguration.getProject().createMarker(MARKER_ID);
        marker.setAttribute("severity", 0);
        marker.setAttribute("message", (Object)message);
    }

    private IConsole startOutputConsole(IConsole console) throws CoreException {
        IParserPreferences prefs = ((IParserPreferencesAccess)EclipseContextFactory.getServiceContext((BundleContext)FrameworkUtil.getBundle(this.getClass()).getBundleContext()).get(IParserPreferencesAccess.class)).getWorkspacePreferences();
        if (console != null && prefs.getAllocateConsole()) {
            IProject project = this.buildConfiguration.getProject();
            console.start(project);
            try {
                ConsoleOutputStream cis = console.getInfoStream();
                String msg = String.format(Messages.CompilerBuiltinsDetector_msg_detection_start, SimpleDateFormat.getTimeInstance().format(new Date()), project.getName(), this.buildConfiguration.getName().isEmpty() ? "?" : this.buildConfiguration.getName(), String.join((CharSequence)" ", this.builtinsDetectionArgs));
                cis.write(msg.getBytes());
                cis.write("\n".getBytes());
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return console;
        }
        return null;
    }
}

