/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.gdbjtag.core;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;
import org.eclipse.cdt.debug.core.CDebugUtils;
import org.eclipse.cdt.debug.gdbjtag.core.Activator;
import org.eclipse.cdt.debug.gdbjtag.core.IGDBJtagConnection;
import org.eclipse.cdt.debug.gdbjtag.core.Messages;
import org.eclipse.cdt.debug.gdbjtag.core.jtagdevice.GDBJtagDeviceContribution;
import org.eclipse.cdt.debug.gdbjtag.core.jtagdevice.GDBJtagDeviceContributionFactory;
import org.eclipse.cdt.debug.gdbjtag.core.jtagdevice.IGDBJtagDevice;
import org.eclipse.cdt.dsf.concurrent.CountingRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.DsfExecutor;
import org.eclipse.cdt.dsf.concurrent.ImmediateDataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.ImmediateRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.ReflectionSequence;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.concurrent.RequestMonitorWithProgress;
import org.eclipse.cdt.dsf.datamodel.DMContexts;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.service.IMemory;
import org.eclipse.cdt.dsf.debug.service.IRunControl;
import org.eclipse.cdt.dsf.debug.service.command.ICommand;
import org.eclipse.cdt.dsf.debug.service.command.IEventListener;
import org.eclipse.cdt.dsf.gdb.launching.FinalLaunchSequence;
import org.eclipse.cdt.dsf.gdb.launching.GdbLaunch;
import org.eclipse.cdt.dsf.gdb.service.IGDBBackend;
import org.eclipse.cdt.dsf.gdb.service.IGDBMemory;
import org.eclipse.cdt.dsf.gdb.service.SessionType;
import org.eclipse.cdt.dsf.gdb.service.command.IGDBControl;
import org.eclipse.cdt.dsf.mi.service.IMIContainerDMContext;
import org.eclipse.cdt.dsf.mi.service.IMIProcesses;
import org.eclipse.cdt.dsf.mi.service.MIBreakpointsManager;
import org.eclipse.cdt.dsf.mi.service.command.commands.CLICommand;
import org.eclipse.cdt.dsf.mi.service.command.output.MIOOBRecord;
import org.eclipse.cdt.dsf.mi.service.command.output.MIOutput;
import org.eclipse.cdt.dsf.mi.service.command.output.MIResult;
import org.eclipse.cdt.dsf.mi.service.command.output.MIStatusAsyncOutput;
import org.eclipse.cdt.dsf.mi.service.command.output.MITuple;
import org.eclipse.cdt.dsf.service.DsfServicesTracker;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.cdt.utils.CommandLineUtil;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.variables.VariablesPlugin;

public class GDBJtagDSFFinalLaunchSequence
extends FinalLaunchSequence {
    private static final String ATTR_JTAG_DEVICE = "org.eclipse.cdt.debug.gdbjtag.core.jtagDevice";
    private IGDBControl fCommandControl;
    private IGDBBackend fGDBBackend;
    private IMIProcesses fProcService;
    private IGDBJtagDevice fGdbJtagDevice;
    private DsfServicesTracker fTracker;
    private IMIContainerDMContext fContainerCtx;
    private IProgressMonitor fProgressMonitor;
    protected static final String GROUP_JTAG = "GROUP_JTAG";

    private void queueCommands(List<String> commands, RequestMonitor rm) {
        if (!commands.isEmpty()) {
            this.fCommandControl.queueCommand((ICommand)new CLICommand((IDMContext)this.fCommandControl.getContext(), this.composeCommand(commands)), new DataRequestMonitor((Executor)this.getExecutor(), rm));
        } else {
            rm.done();
        }
    }

    public GDBJtagDSFFinalLaunchSequence(DsfSession session, Map<String, Object> attributes, RequestMonitorWithProgress rm) {
        super(session, attributes, rm);
        this.fProgressMonitor = rm.getProgressMonitor();
    }

    public GDBJtagDSFFinalLaunchSequence(DsfExecutor executor, GdbLaunch launch, SessionType sessionType, boolean attach, RequestMonitorWithProgress rm) {
        this(launch.getSession(), GDBJtagDSFFinalLaunchSequence.getAttributes(launch), rm);
    }

    private static Map<String, Object> getAttributes(GdbLaunch launch) {
        try {
            return launch.getLaunchConfiguration().getAttributes();
        }
        catch (CoreException coreException) {
            return new HashMap<String, Object>();
        }
    }

    protected IMIContainerDMContext getContainerContext() {
        return this.fContainerCtx;
    }

    protected void setContainerContext(IMIContainerDMContext ctx) {
        this.fContainerCtx = ctx;
    }

    protected String[] getExecutionOrder(String group) {
        if ("GROUP_TOP_LEVEL".equals(group)) {
            ArrayList<String> orderList = new ArrayList<String>(Arrays.asList(super.getExecutionOrder("GROUP_TOP_LEVEL")));
            orderList.removeAll(Arrays.asList("stepNewProcess"));
            orderList.add(orderList.indexOf("stepDataModelInitializationComplete"), GROUP_JTAG);
            return orderList.toArray(new String[orderList.size()]);
        }
        if (GROUP_JTAG.equals(group)) {
            return new String[]{"stepInitializeJTAGFinalLaunchSequence", "stepRetrieveJTAGDevice", "stepLoadSymbols", "stepConnectToTarget", "stepResetBoard", "stepDelayStartup", "stepHaltBoard", "stepUserInitCommands", "stepLoadImage", "stepUpdateContainer", "stepInitializeMemory", "stepSetArguments", "stepSetEnvironmentVariables", "stepStartTrackingBreakpoints", "stepSetProgramCounter", "stepStopScript", "stepUserDebugCommands", "stepResumeScript", "stepJTAGCleanup"};
        }
        return super.getExecutionOrder(group);
    }

    @ReflectionSequence.Execute
    public void stepInitializeJTAGFinalLaunchSequence(RequestMonitor rm) {
        this.fTracker = new DsfServicesTracker(Activator.getBundleContext(), this.getSession().getId());
        this.fGDBBackend = (IGDBBackend)this.fTracker.getService(IGDBBackend.class);
        if (this.fGDBBackend == null) {
            rm.done((IStatus)new Status(4, "org.eclipse.cdt.debug.gdbjtag.core", -1, "Cannot obtain GDBBackend service", null));
            return;
        }
        this.fCommandControl = (IGDBControl)this.fTracker.getService(IGDBControl.class);
        if (this.fCommandControl == null) {
            rm.done((IStatus)new Status(4, "org.eclipse.cdt.debug.gdbjtag.core", -1, "Cannot obtain control service", null));
            return;
        }
        this.fProcService = (IMIProcesses)this.fTracker.getService(IMIProcesses.class);
        if (this.fProcService == null) {
            rm.done((IStatus)new Status(4, "org.eclipse.cdt.debug.gdbjtag.core", -1, "Cannot obtain process service", null));
            return;
        }
        this.setContainerContext(this.fProcService.createContainerContextFromGroupId(this.fCommandControl.getContext(), ""));
        rm.done();
    }

    @ReflectionSequence.RollBack(value="stepInitializeJTAGFinalLaunchSequence")
    public void rollBackInitializeFinalLaunchSequence(RequestMonitor rm) {
        if (this.fTracker != null) {
            this.fTracker.dispose();
        }
        this.fTracker = null;
        rm.done();
    }

    @ReflectionSequence.Execute
    public void stepRetrieveJTAGDevice(RequestMonitor rm) {
        NullPointerException exception = null;
        try {
            this.fGdbJtagDevice = this.getGDBJtagDeviceContribution().getDevice();
        }
        catch (NullPointerException e) {
            exception = e;
        }
        if (this.fGdbJtagDevice == null) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.debug.gdbjtag.core", -1, "Cannot get Jtag device", (Throwable)exception));
        }
        rm.done();
    }

    @ReflectionSequence.Execute
    public void stepLoadSymbols(RequestMonitor rm) {
        try {
            if (((Boolean)CDebugUtils.getAttribute((Map)this.getAttributes(), (String)"org.eclipse.cdt.debug.gdbjtag.core.loadSymbols", (Object)true)).booleanValue()) {
                String symbolsFileName = null;
                if (this.getAttributes().containsKey("org.eclipse.cdt.debug.gdbjtag.core.useProjBinaryForSymbols") && ((Boolean)CDebugUtils.getAttribute((Map)this.getAttributes(), (String)"org.eclipse.cdt.debug.gdbjtag.core.useProjBinaryForSymbols", (Object)true)).booleanValue()) {
                    IPath programFile = this.fGDBBackend.getProgramPath();
                    if (programFile != null) {
                        symbolsFileName = programFile.toOSString();
                    }
                } else {
                    symbolsFileName = (String)CDebugUtils.getAttribute((Map)this.getAttributes(), (String)"org.eclipse.cdt.debug.gdbjtag.core.symbolsFileName", (Object)"");
                    symbolsFileName = symbolsFileName.length() > 0 ? VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(symbolsFileName) : null;
                }
                if (symbolsFileName == null) {
                    rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.debug.gdbjtag.core", -1, Messages.getString("GDBJtagDebugger.err_no_sym_file"), null));
                    rm.done();
                    return;
                }
                symbolsFileName = symbolsFileName.replace("\\", "\\\\");
                String symbolsOffset = (String)CDebugUtils.getAttribute((Map)this.getAttributes(), (String)"org.eclipse.cdt.debug.gdbjtag.core.symbolsOffset", (Object)"");
                if (symbolsOffset.length() > 0) {
                    symbolsOffset = "0x" + symbolsOffset;
                }
                ArrayList<String> commands = new ArrayList<String>();
                this.fGdbJtagDevice.doLoadSymbol(symbolsFileName, symbolsOffset, commands);
                this.queueCommands(commands, rm);
            } else {
                rm.done();
            }
        }
        catch (CoreException e) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.debug.gdbjtag.core", -1, "Cannot load symbol", (Throwable)e));
            rm.done();
        }
    }

    @ReflectionSequence.Execute
    public void stepConnectToTarget(RequestMonitor rm) {
        try {
            if (((Boolean)CDebugUtils.getAttribute((Map)this.getAttributes(), (String)"org.eclipse.cdt.debug.gdbjtag.core.useRemoteTarget", (Object)true)).booleanValue()) {
                ArrayList<String> commands = new ArrayList<String>();
                if (this.fGdbJtagDevice instanceof IGDBJtagConnection) {
                    String connection = "unspecified-ip-address:unspecified-port-number";
                    String connectionUri = (String)CDebugUtils.getAttribute((Map)this.getAttributes(), (String)"org.eclipse.cdt.debug.gdbjtag.core.connection", (Object)"unspecified-ip-address:unspecified-port-number");
                    if (!"unspecified-ip-address:unspecified-port-number".equals(connectionUri)) {
                        connection = new URI(connectionUri).getSchemeSpecificPart();
                    } else {
                        String ipAddress = (String)CDebugUtils.getAttribute((Map)this.getAttributes(), (String)"org.eclipse.cdt.debug.gdbjtag.core.ipAddress", (Object)"unspecified-ip-address");
                        int portNumber = (Integer)CDebugUtils.getAttribute((Map)this.getAttributes(), (String)"org.eclipse.cdt.debug.gdbjtag.core.portNumber", (Object)0);
                        if (!"unspecified-ip-address".equals(ipAddress)) {
                            connection = String.format("%s:%d", ipAddress, portNumber);
                        }
                    }
                    IGDBJtagConnection device = (IGDBJtagConnection)((Object)this.fGdbJtagDevice);
                    device.doRemote(connection, commands);
                    this.queueCommands(commands, rm);
                } else {
                    rm.done();
                }
            } else {
                rm.done();
            }
        }
        catch (URISyntaxException e) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.debug.gdbjtag.core", -1, "Invalid remote target connection syntax", (Throwable)e));
            rm.done();
        }
    }

    @ReflectionSequence.Execute
    public void stepResetBoard(RequestMonitor rm) {
        if (((Boolean)CDebugUtils.getAttribute((Map)this.getAttributes(), (String)"org.eclipse.cdt.debug.gdbjtag.core.doReset", (Object)false)).booleanValue()) {
            ArrayList<String> commands = new ArrayList<String>();
            if (this.useResetAndHalt()) {
                this.fGdbJtagDevice.doResetAndHalt(commands);
            } else {
                this.fGdbJtagDevice.doReset(commands);
            }
            if (commands.isEmpty()) {
                this.setError(String.format(Messages.getString("GDBJtagDebugger.reset_not_defined"), this.getGDBJtagDeviceName()), rm);
            } else {
                this.queueCommands(commands, rm);
            }
        } else {
            rm.done();
        }
    }

    @ReflectionSequence.Execute
    public void stepDelayStartup(RequestMonitor rm) {
        if (((Boolean)CDebugUtils.getAttribute((Map)this.getAttributes(), (String)"org.eclipse.cdt.debug.gdbjtag.core.doReset", (Object)false)).booleanValue()) {
            int defaultDelay = this.fGdbJtagDevice.getDefaultDelay();
            ArrayList<String> commands = new ArrayList<String>();
            int delay = (Integer)CDebugUtils.getAttribute((Map)this.getAttributes(), (String)"org.eclipse.cdt.debug.gdbjtag.core.delay", (Object)defaultDelay);
            this.fGdbJtagDevice.doDelay(delay, commands);
            if (delay == 0) {
                rm.done();
            } else if (commands.isEmpty()) {
                this.setError(String.format(Messages.getString("GDBJtagDebugger.delay_not_defined"), this.getGDBJtagDeviceName()), rm);
            } else {
                this.queueCommands(commands, rm);
            }
        } else {
            rm.done();
        }
    }

    @ReflectionSequence.Execute
    public void stepHaltBoard(RequestMonitor rm) {
        if (!this.useResetAndHalt() && ((Boolean)CDebugUtils.getAttribute((Map)this.getAttributes(), (String)"org.eclipse.cdt.debug.gdbjtag.core.doHalt", (Object)false)).booleanValue()) {
            ArrayList<String> commands = new ArrayList<String>();
            this.fGdbJtagDevice.doHalt(commands);
            if (commands.isEmpty()) {
                this.setError(String.format(Messages.getString("GDBJtagDebugger.halt_not_defined"), this.getGDBJtagDeviceName()), rm);
            } else {
                this.queueCommands(commands, rm);
            }
        } else {
            rm.done();
        }
    }

    @ReflectionSequence.Execute
    public void stepUserInitCommands(RequestMonitor rm) {
        try {
            String userCmd = (String)CDebugUtils.getAttribute((Map)this.getAttributes(), (String)"org.eclipse.cdt.debug.gdbjtag.core.initCommands", (Object)"");
            userCmd = VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(userCmd);
            if (userCmd.length() > 0) {
                String[] commands = userCmd.split("\\r?\\n");
                commands = (String[])Arrays.stream(commands).filter(line -> !line.trim().isEmpty() && !line.trim().startsWith("#")).toArray(String[]::new);
                CountingRequestMonitor crm = new CountingRequestMonitor((Executor)this.getExecutor(), rm);
                crm.setDoneCount(commands.length);
                int i = 0;
                while (i < commands.length) {
                    this.fCommandControl.queueCommand((ICommand)new CLICommand((IDMContext)this.fCommandControl.getContext(), commands[i]), new DataRequestMonitor((Executor)this.getExecutor(), (RequestMonitor)crm));
                    ++i;
                }
            } else {
                rm.done();
            }
        }
        catch (CoreException e) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.debug.gdbjtag.core", -1, "Cannot run user defined init commands", (Throwable)e));
            rm.done();
        }
    }

    @ReflectionSequence.Execute
    public void stepLoadImage(final RequestMonitor rm) {
        try {
            String imageFileName = null;
            if (((Boolean)CDebugUtils.getAttribute((Map)this.getAttributes(), (String)"org.eclipse.cdt.debug.gdbjtag.core.loadImage", (Object)true)).booleanValue()) {
                if (this.getAttributes().containsKey("org.eclipse.cdt.debug.gdbjtag.core.useProjBinaryForImage") && ((Boolean)CDebugUtils.getAttribute((Map)this.getAttributes(), (String)"org.eclipse.cdt.debug.gdbjtag.core.useProjBinaryForImage", (Object)true)).booleanValue()) {
                    IPath programFile = this.fGDBBackend.getProgramPath();
                    if (programFile != null) {
                        imageFileName = programFile.toOSString();
                    }
                } else {
                    imageFileName = (String)CDebugUtils.getAttribute((Map)this.getAttributes(), (String)"org.eclipse.cdt.debug.gdbjtag.core.imageFileName", (Object)"");
                    imageFileName = imageFileName.length() > 0 ? VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(imageFileName) : null;
                }
                if (imageFileName == null) {
                    rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.debug.gdbjtag.core", -1, Messages.getString("GDBJtagDebugger.err_no_img_file"), null));
                    rm.done();
                    return;
                }
                imageFileName = imageFileName.replace("\\", "\\\\");
                String imageOffset = (String)CDebugUtils.getAttribute((Map)this.getAttributes(), (String)"org.eclipse.cdt.debug.gdbjtag.core.imageOffset", (Object)"");
                if (imageOffset.length() > 0) {
                    imageOffset = imageFileName.endsWith(".elf") ? "" : "0x" + (String)CDebugUtils.getAttribute((Map)this.getAttributes(), (String)"org.eclipse.cdt.debug.gdbjtag.core.imageOffset", (Object)"");
                }
                ArrayList<String> commands = new ArrayList<String>();
                this.fGdbJtagDevice.doLoadImage(imageFileName, imageOffset, commands);
                final DownloadStatusListener downloadStatusListener = new DownloadStatusListener(this){

                    @Override
                    protected void handleStatus(String status) {
                        fProgressMonitor.subTask("- " + status);
                    }
                };
                this.fCommandControl.addEventListener((IEventListener)downloadStatusListener);
                this.queueCommands(commands, (RequestMonitor)new ImmediateRequestMonitor(rm){

                    protected void handleCompleted() {
                        GDBJtagDSFFinalLaunchSequence.this.fCommandControl.removeEventListener(downloadStatusListener);
                        rm.done();
                    }
                });
            } else {
                rm.done();
            }
        }
        catch (CoreException e) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.debug.gdbjtag.core", -1, "Cannot load image", (Throwable)e));
            rm.done();
        }
    }

    @ReflectionSequence.Execute
    public void stepUpdateContainer(RequestMonitor rm) {
        String groupId = this.getContainerContext().getGroupId();
        this.setContainerContext(this.fProcService.createContainerContextFromGroupId(this.fCommandControl.getContext(), groupId));
        rm.done();
    }

    @ReflectionSequence.Execute
    public void stepSetArguments(RequestMonitor rm) {
        try {
            String args = (String)CDebugUtils.getAttribute((Map)this.getAttributes(), (String)"org.eclipse.cdt.launch.PROGRAM_ARGUMENTS", (Object)"");
            if (args.length() != 0) {
                args = VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(args);
                String[] argArray = CommandLineUtil.argumentsToArray((String)args);
                this.fCommandControl.queueCommand(this.fCommandControl.getCommandFactory().createMIGDBSetArgs(this.getContainerContext(), argArray), (DataRequestMonitor)new ImmediateDataRequestMonitor(rm));
            } else {
                rm.done();
            }
        }
        catch (CoreException e) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.debug.gdbjtag.core", -1, "Cannot get inferior arguments", (Throwable)e));
            rm.done();
        }
    }

    @ReflectionSequence.Execute
    public void stepSetEnvironmentVariables(RequestMonitor rm) {
        boolean clear = false;
        Properties properties = new Properties();
        try {
            clear = this.fGDBBackend.getClearEnvironment();
            properties = this.fGDBBackend.getEnvironmentVariables();
        }
        catch (CoreException e) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.debug.gdbjtag.core", -1, "Cannot get environment information", (Throwable)e));
            rm.done();
            return;
        }
        if (clear || properties.size() > 0) {
            this.fCommandControl.setEnvironment(properties, clear, rm);
        } else {
            rm.done();
        }
    }

    @ReflectionSequence.Execute
    public void stepStartTrackingBreakpoints(RequestMonitor rm) {
        MIBreakpointsManager bpmService = (MIBreakpointsManager)this.fTracker.getService(MIBreakpointsManager.class);
        bpmService.startTrackingBpForProcess((IRunControl.IContainerDMContext)this.getContainerContext(), rm);
    }

    @ReflectionSequence.Execute
    public void stepSetProgramCounter(RequestMonitor rm) {
        if (((Boolean)CDebugUtils.getAttribute((Map)this.getAttributes(), (String)"org.eclipse.cdt.debug.gdbjtag.core.setPcRegister", (Object)false)).booleanValue()) {
            String pcRegister = (String)CDebugUtils.getAttribute((Map)this.getAttributes(), (String)"org.eclipse.cdt.debug.gdbjtag.core.pcRegister", (Object)((String)CDebugUtils.getAttribute((Map)this.getAttributes(), (String)"org.eclipse.cdt.debug.gdbjtag.core.imageOffset", (Object)"")));
            ArrayList<String> commands = new ArrayList<String>();
            this.fGdbJtagDevice.doSetPC(pcRegister, commands);
            this.queueCommands(commands, rm);
        } else {
            rm.done();
        }
    }

    @ReflectionSequence.Execute
    public void stepStopScript(RequestMonitor rm) {
        if (((Boolean)CDebugUtils.getAttribute((Map)this.getAttributes(), (String)"org.eclipse.cdt.debug.gdbjtag.core.setStopAt", (Object)false)).booleanValue()) {
            String stopAt = (String)CDebugUtils.getAttribute((Map)this.getAttributes(), (String)"org.eclipse.cdt.debug.gdbjtag.core.stopAt", (Object)"");
            ArrayList<String> commands = new ArrayList<String>();
            this.fGdbJtagDevice.doStopAt(stopAt, commands);
            this.queueCommands(commands, rm);
        } else {
            rm.done();
        }
    }

    @ReflectionSequence.Execute
    public void stepResumeScript(RequestMonitor rm) {
        if (((Boolean)CDebugUtils.getAttribute((Map)this.getAttributes(), (String)"org.eclipse.cdt.debug.gdbjtag.core.setResume", (Object)false)).booleanValue()) {
            ArrayList<String> commands = new ArrayList<String>();
            this.fGdbJtagDevice.doContinue(commands);
            this.queueCommands(commands, rm);
        } else {
            rm.done();
        }
    }

    @ReflectionSequence.Execute
    public void stepUserDebugCommands(RequestMonitor rm) {
        try {
            String userCmd = (String)CDebugUtils.getAttribute((Map)this.getAttributes(), (String)"org.eclipse.cdt.debug.gdbjtag.core.runCommands", (Object)"");
            if (userCmd.length() > 0) {
                userCmd = VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(userCmd);
                String[] commands = userCmd.split("\\r?\\n");
                commands = (String[])Arrays.stream(commands).filter(line -> !line.trim().isEmpty() && !line.trim().startsWith("#")).toArray(String[]::new);
                CountingRequestMonitor crm = new CountingRequestMonitor((Executor)this.getExecutor(), rm);
                crm.setDoneCount(commands.length);
                int i = 0;
                while (i < commands.length) {
                    this.fCommandControl.queueCommand((ICommand)new CLICommand((IDMContext)this.fCommandControl.getContext(), commands[i]), new DataRequestMonitor((Executor)this.getExecutor(), (RequestMonitor)crm));
                    ++i;
                }
            } else {
                rm.done();
            }
        }
        catch (CoreException e) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.debug.gdbjtag.core", -1, "Cannot run user defined run commands", (Throwable)e));
            rm.done();
        }
    }

    private void setError(String message, RequestMonitor rm) {
        rm.done((IStatus)new Status(4, "org.eclipse.cdt.debug.gdbjtag.core", message));
    }

    private String getGDBJtagDeviceName() {
        GDBJtagDeviceContribution contribution = this.getGDBJtagDeviceContribution();
        if (contribution != null) {
            return contribution.getDeviceName();
        }
        return "";
    }

    private GDBJtagDeviceContribution getGDBJtagDeviceContribution() {
        String deviceName;
        String deviceId;
        Map attributes = this.getAttributes();
        if (attributes.containsKey("org.eclipse.cdt.debug.gdbjtag.core.jtagDeviceId") && !(deviceId = (String)CDebugUtils.getAttribute((Map)attributes, (String)"org.eclipse.cdt.debug.gdbjtag.core.jtagDeviceId", (Object)"")).isEmpty()) {
            return GDBJtagDeviceContributionFactory.getInstance().findByDeviceId(deviceId);
        }
        if (attributes.containsKey(ATTR_JTAG_DEVICE) && !(deviceName = (String)CDebugUtils.getAttribute((Map)attributes, (String)ATTR_JTAG_DEVICE, (Object)"")).isEmpty()) {
            return GDBJtagDeviceContributionFactory.getInstance().findByDeviceName(deviceName);
        }
        return null;
    }

    private String composeCommand(Collection<String> commands) {
        if (commands.isEmpty()) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        Iterator<String> it = commands.iterator();
        while (it.hasNext()) {
            sb.append(it.next());
        }
        return sb.toString();
    }

    private boolean useResetAndHalt() {
        boolean doReset = (Boolean)CDebugUtils.getAttribute((Map)this.getAttributes(), (String)"org.eclipse.cdt.debug.gdbjtag.core.doReset", (Object)false);
        boolean doHalt = (Boolean)CDebugUtils.getAttribute((Map)this.getAttributes(), (String)"org.eclipse.cdt.debug.gdbjtag.core.doHalt", (Object)false);
        int defaultDelay = this.fGdbJtagDevice.getDefaultDelay();
        int delay = (Integer)CDebugUtils.getAttribute((Map)this.getAttributes(), (String)"org.eclipse.cdt.debug.gdbjtag.core.delay", (Object)defaultDelay);
        ArrayList<String> resetAndHaltCommands = new ArrayList<String>();
        this.fGdbJtagDevice.doResetAndHalt(resetAndHaltCommands);
        return doReset && doHalt && delay == 0 && !resetAndHaltCommands.isEmpty();
    }

    @ReflectionSequence.Execute
    public void stepJTAGCleanup(RequestMonitor requestMonitor) {
        this.fTracker.dispose();
        this.fTracker = null;
        requestMonitor.done();
    }

    @ReflectionSequence.Execute
    public void stepInitializeMemory(RequestMonitor rm) {
        IGDBMemory memory = (IGDBMemory)this.fTracker.getService(IGDBMemory.class);
        IMemory.IMemoryDMContext memContext = (IMemory.IMemoryDMContext)DMContexts.getAncestorOfType((IDMContext)this.getContainerContext(), IMemory.IMemoryDMContext.class);
        if (memory == null || memContext == null) {
            rm.done();
            return;
        }
        memory.initializeMemoryData(memContext, rm);
    }

    private abstract class DownloadStatusListener
    implements IEventListener {
        private static final String ASYNC_CLASS_DOWNLOAD = "download";
        private static final String VAR_SECTION = "section";
        private static final String VAR_SECTION_SENT = "section-sent";
        private static final String VAR_SECTION_SIZE = "section-size";

        private DownloadStatusListener() {
        }

        abstract void handleStatus(String var1);

        public void eventReceived(Object output) {
            if (output instanceof MIOutput) {
                MIOOBRecord[] mIOOBRecordArray = ((MIOutput)output).getMIOOBRecords();
                int n = mIOOBRecordArray.length;
                int n2 = 0;
                while (n2 < n) {
                    MIOOBRecord oobr = mIOOBRecordArray[n2];
                    if (oobr instanceof MIStatusAsyncOutput) {
                        this.asyncOutputReceived((MIStatusAsyncOutput)oobr);
                    }
                    ++n2;
                }
            }
        }

        private void asyncOutputReceived(MIStatusAsyncOutput output) {
            if (ASYNC_CLASS_DOWNLOAD.equals(output.getAsyncClass())) {
                HashMap<String, String> results = new HashMap<String, String>();
                MIResult[] mIResultArray = output.getMIResults();
                int n = mIResultArray.length;
                int n2 = 0;
                while (n2 < n) {
                    MIResult result = mIResultArray[n2];
                    if (result.getMIValue() instanceof MITuple) {
                        MIResult[] mIResultArray2 = ((MITuple)result.getMIValue()).getMIResults();
                        int n3 = mIResultArray2.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            MIResult field = mIResultArray2[n4];
                            results.put(field.getVariable(), field.getMIValue().toString());
                            ++n4;
                        }
                    }
                    ++n2;
                }
                String section = (String)results.get(VAR_SECTION);
                if (section != null) {
                    StringBuilder status = new StringBuilder();
                    status.append(String.format(Messages.getString("GDBJtagDebugger.downloading"), section));
                    String sectionSent = (String)results.get(VAR_SECTION_SENT);
                    String sectionSize = (String)results.get(VAR_SECTION_SIZE);
                    if (sectionSent != null && sectionSize != null) {
                        status.append(String.format(" (%s/%s)", sectionSent, sectionSize));
                    }
                    this.handleStatus(status.toString());
                }
            }
        }
    }
}

