/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.docker.launcher.ui.launchbar;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import org.eclipse.cdt.core.build.IToolChainManager;
import org.eclipse.cdt.debug.core.CDebugCorePlugin;
import org.eclipse.cdt.debug.ui.CDebugUIPlugin;
import org.eclipse.cdt.internal.docker.launcher.ui.launchbar.Messages;
import org.eclipse.cdt.internal.docker.launcher.ui.launchbar.NewContainerTargetWizardPage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.launchbar.core.target.ILaunchTarget;
import org.eclipse.launchbar.core.target.ILaunchTargetManager;
import org.eclipse.launchbar.core.target.ILaunchTargetWorkingCopy;
import org.eclipse.launchbar.ui.internal.Activator;
import org.eclipse.launchbar.ui.target.LaunchTargetWizard;

public class NewContainerTargetWizard
extends LaunchTargetWizard {
    private NewContainerTargetWizardPage page;
    protected IToolChainManager toolChainManager = (IToolChainManager)CDebugCorePlugin.getService(IToolChainManager.class);

    public NewContainerTargetWizard() {
        if (this.getLaunchTarget() == null) {
            this.setWindowTitle(Messages.NewContainerTargetWizard_title);
        } else {
            this.setWindowTitle(Messages.EditContainerTargetWizard_title);
        }
    }

    public void addPages() {
        super.addPages();
        this.page = new NewContainerTargetWizardPage(this.getLaunchTarget());
        this.addPage((IWizardPage)this.page);
    }

    public boolean performFinish() {
        ILaunchTargetManager manager = (ILaunchTargetManager)CDebugUIPlugin.getService(ILaunchTargetManager.class);
        String typeId = "org.eclipse.cdt.docker.launcher.launchTargetType.container";
        String id = this.page.getTargetName();
        ILaunchTarget target = this.getLaunchTarget();
        if (target == null) {
            target = manager.addLaunchTarget(typeId, id);
        }
        ILaunchTargetWorkingCopy wc = target.getWorkingCopy();
        wc.setId(id);
        wc.setAttribute("os", Platform.getOS());
        wc.setAttribute("arch", "linux-container");
        wc.setAttribute("connection_uri", this.page.getConnectionURI());
        wc.setAttribute("image_id", this.page.getImageId());
        wc.save();
        HashMap properties = new HashMap();
        properties.putAll(wc.getAttributes());
        Collection<Object> toolChains = Collections.emptyList();
        try {
            toolChains = this.toolChainManager.getToolChainsMatching(properties);
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        return true;
    }

    public boolean canDelete() {
        return true;
    }

    public void performDelete() {
        ILaunchTargetManager manager = (ILaunchTargetManager)Activator.getService(ILaunchTargetManager.class);
        ILaunchTarget target = this.getLaunchTarget();
        if (target != null) {
            manager.removeLaunchTarget(this.getLaunchTarget());
        }
    }
}

