/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.Collection;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.CollectorManager;
import org.apache.lucene.search.FieldDoc;
import org.apache.lucene.search.HitQueue;
import org.apache.lucene.search.HitsThresholdChecker;
import org.apache.lucene.search.LeafCollector;
import org.apache.lucene.search.MaxScoreAccumulator;
import org.apache.lucene.search.Scorable;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopDocsCollector;
import org.apache.lucene.search.TotalHits;

public abstract class TopScoreDocCollector
extends TopDocsCollector<ScoreDoc> {
    int docBase;
    ScoreDoc pqTop;
    final HitsThresholdChecker hitsThresholdChecker;
    final MaxScoreAccumulator minScoreAcc;
    float minCompetitiveScore;

    public static TopScoreDocCollector create(int numHits, int totalHitsThreshold) {
        return TopScoreDocCollector.create(numHits, null, totalHitsThreshold);
    }

    public static TopScoreDocCollector create(int numHits, ScoreDoc after, int totalHitsThreshold) {
        return TopScoreDocCollector.create(numHits, after, HitsThresholdChecker.create(totalHitsThreshold), null);
    }

    static TopScoreDocCollector create(int numHits, ScoreDoc after, HitsThresholdChecker hitsThresholdChecker, MaxScoreAccumulator minScoreAcc) {
        if (numHits <= 0) {
            throw new IllegalArgumentException("numHits must be > 0; please use TotalHitCountCollector if you just need the total hit count");
        }
        if (hitsThresholdChecker == null) {
            throw new IllegalArgumentException("hitsThresholdChecker must be non null");
        }
        if (after == null) {
            return new SimpleTopScoreDocCollector(numHits, hitsThresholdChecker, minScoreAcc);
        }
        return new PagingTopScoreDocCollector(numHits, after, hitsThresholdChecker, minScoreAcc);
    }

    public static CollectorManager<TopScoreDocCollector, TopDocs> createSharedManager(final int numHits, final FieldDoc after, final int totalHitsThreshold) {
        return new CollectorManager<TopScoreDocCollector, TopDocs>(){
            private final HitsThresholdChecker hitsThresholdChecker;
            private final MaxScoreAccumulator minScoreAcc;
            {
                this.hitsThresholdChecker = HitsThresholdChecker.createShared(totalHitsThreshold);
                this.minScoreAcc = new MaxScoreAccumulator();
            }

            @Override
            public TopScoreDocCollector newCollector() throws IOException {
                return TopScoreDocCollector.create(numHits, after, this.hitsThresholdChecker, this.minScoreAcc);
            }

            @Override
            public TopDocs reduce(Collection<TopScoreDocCollector> collectors) throws IOException {
                TopDocs[] topDocs = new TopDocs[collectors.size()];
                int i = 0;
                for (TopScoreDocCollector collector : collectors) {
                    topDocs[i++] = collector.topDocs();
                }
                return TopDocs.merge(numHits, topDocs);
            }
        };
    }

    TopScoreDocCollector(int numHits, HitsThresholdChecker hitsThresholdChecker, MaxScoreAccumulator minScoreAcc) {
        super(new HitQueue(numHits, true));
        assert (hitsThresholdChecker != null);
        this.pqTop = (ScoreDoc)this.pq.top();
        this.hitsThresholdChecker = hitsThresholdChecker;
        this.minScoreAcc = minScoreAcc;
    }

    @Override
    protected TopDocs newTopDocs(ScoreDoc[] results, int start) {
        if (results == null) {
            return EMPTY_TOPDOCS;
        }
        return new TopDocs(new TotalHits(this.totalHits, this.totalHitsRelation), results);
    }

    @Override
    public ScoreMode scoreMode() {
        return this.hitsThresholdChecker.scoreMode();
    }

    protected void updateGlobalMinCompetitiveScore(Scorable scorer) throws IOException {
        assert (this.minScoreAcc != null);
        MaxScoreAccumulator.DocAndScore maxMinScore = this.minScoreAcc.get();
        if (maxMinScore != null) {
            float score;
            float f = score = this.docBase > maxMinScore.docID ? Math.nextUp(maxMinScore.score) : maxMinScore.score;
            if (score > this.minCompetitiveScore) {
                assert (this.hitsThresholdChecker.isThresholdReached());
                scorer.setMinCompetitiveScore(score);
                this.minCompetitiveScore = score;
                this.totalHitsRelation = TotalHits.Relation.GREATER_THAN_OR_EQUAL_TO;
            }
        }
    }

    protected void updateMinCompetitiveScore(Scorable scorer) throws IOException {
        float localMinScore;
        if (this.hitsThresholdChecker.isThresholdReached() && this.pqTop != null && this.pqTop.score != Float.NEGATIVE_INFINITY && (localMinScore = Math.nextUp(this.pqTop.score)) > this.minCompetitiveScore) {
            scorer.setMinCompetitiveScore(localMinScore);
            this.totalHitsRelation = TotalHits.Relation.GREATER_THAN_OR_EQUAL_TO;
            this.minCompetitiveScore = localMinScore;
            if (this.minScoreAcc != null) {
                this.minScoreAcc.accumulate(this.pqTop.doc, this.pqTop.score);
            }
        }
    }

    private static class PagingTopScoreDocCollector
    extends TopScoreDocCollector {
        private final ScoreDoc after;
        private int collectedHits;

        PagingTopScoreDocCollector(int numHits, ScoreDoc after, HitsThresholdChecker hitsThresholdChecker, MaxScoreAccumulator minScoreAcc) {
            super(numHits, hitsThresholdChecker, minScoreAcc);
            this.after = after;
            this.collectedHits = 0;
        }

        @Override
        protected int topDocsSize() {
            return this.collectedHits < this.pq.size() ? this.collectedHits : this.pq.size();
        }

        @Override
        protected TopDocs newTopDocs(ScoreDoc[] results, int start) {
            return results == null ? new TopDocs(new TotalHits(this.totalHits, this.totalHitsRelation), new ScoreDoc[0]) : new TopDocs(new TotalHits(this.totalHits, this.totalHitsRelation), results);
        }

        @Override
        public LeafCollector getLeafCollector(LeafReaderContext context) throws IOException {
            this.docBase = context.docBase;
            final int afterDoc = this.after.doc - context.docBase;
            return new ScorerLeafCollector(){

                @Override
                public void collect(int doc) throws IOException {
                    float score = this.scorer.score();
                    assert (score >= 0.0f);
                    ++totalHits;
                    hitsThresholdChecker.incrementHitCount();
                    if (minScoreAcc != null && ((long)totalHits & minScoreAcc.modInterval) == 0L) {
                        this.updateGlobalMinCompetitiveScore(this.scorer);
                    }
                    if (score > ((PagingTopScoreDocCollector)this).after.score || score == ((PagingTopScoreDocCollector)this).after.score && doc <= afterDoc) {
                        if (totalHitsRelation == TotalHits.Relation.EQUAL_TO) {
                            this.updateMinCompetitiveScore(this.scorer);
                        }
                        return;
                    }
                    if (score <= pqTop.score) {
                        if (totalHitsRelation == TotalHits.Relation.EQUAL_TO) {
                            this.updateMinCompetitiveScore(this.scorer);
                        }
                        return;
                    }
                    collectedHits++;
                    pqTop.doc = doc + docBase;
                    pqTop.score = score;
                    pqTop = (ScoreDoc)pq.updateTop();
                    this.updateMinCompetitiveScore(this.scorer);
                }
            };
        }
    }

    static abstract class ScorerLeafCollector
    implements LeafCollector {
        Scorable scorer;

        ScorerLeafCollector() {
        }

        @Override
        public void setScorer(Scorable scorer) throws IOException {
            this.scorer = scorer;
        }
    }

    private static class SimpleTopScoreDocCollector
    extends TopScoreDocCollector {
        SimpleTopScoreDocCollector(int numHits, HitsThresholdChecker hitsThresholdChecker, MaxScoreAccumulator minScoreAcc) {
            super(numHits, hitsThresholdChecker, minScoreAcc);
        }

        @Override
        public LeafCollector getLeafCollector(LeafReaderContext context) throws IOException {
            this.docBase = context.docBase;
            return new ScorerLeafCollector(){

                @Override
                public void setScorer(Scorable scorer) throws IOException {
                    super.setScorer(scorer);
                    minCompetitiveScore = 0.0f;
                    this.updateMinCompetitiveScore(scorer);
                    if (minScoreAcc != null) {
                        this.updateGlobalMinCompetitiveScore(scorer);
                    }
                }

                @Override
                public void collect(int doc) throws IOException {
                    float score = this.scorer.score();
                    assert (score >= 0.0f);
                    ++totalHits;
                    hitsThresholdChecker.incrementHitCount();
                    if (minScoreAcc != null && ((long)totalHits & minScoreAcc.modInterval) == 0L) {
                        this.updateGlobalMinCompetitiveScore(this.scorer);
                    }
                    if (score <= pqTop.score) {
                        if (totalHitsRelation == TotalHits.Relation.EQUAL_TO) {
                            this.updateMinCompetitiveScore(this.scorer);
                        }
                        return;
                    }
                    pqTop.doc = doc + docBase;
                    pqTop.score = score;
                    pqTop = (ScoreDoc)pq.updateTop();
                    this.updateMinCompetitiveScore(this.scorer);
                }
            };
        }
    }
}

