/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.debug.internal.ui.disassembly;

import org.eclipse.cdt.dsf.debug.internal.ui.disassembly.DisassemblyPart;
import org.eclipse.cdt.internal.ui.text.CWordFinder;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.hyperlink.AbstractHyperlinkDetector;
import org.eclipse.jface.text.hyperlink.IHyperlink;

class DisassemblyHyperlinkDetector
extends AbstractHyperlinkDetector {
    private DisassemblyPart fPart;

    public DisassemblyHyperlinkDetector(DisassemblyPart part) {
        this.fPart = part;
    }

    public IHyperlink[] detectHyperlinks(ITextViewer textViewer, IRegion region, boolean canShowMultipleHyperlinks) {
        IDocument document = textViewer.getDocument();
        if (document == null) {
            return null;
        }
        IRegion wordRegion = CWordFinder.findWord((IDocument)document, (int)region.getOffset());
        if (wordRegion != null && wordRegion.getLength() != 0) {
            try {
                String word = document.get(wordRegion.getOffset(), wordRegion.getLength());
                return new IHyperlink[]{new DisassemblyHyperlink(word, wordRegion)};
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        return null;
    }

    public class DisassemblyHyperlink
    implements IHyperlink {
        private String fSymbol;
        private IRegion fRegion;

        public DisassemblyHyperlink(String symbol, IRegion region) {
            this.fSymbol = symbol;
            this.fRegion = region;
        }

        public IRegion getHyperlinkRegion() {
            return this.fRegion;
        }

        public String getHyperlinkText() {
            return null;
        }

        public String getTypeLabel() {
            return null;
        }

        public void open() {
            if (DisassemblyHyperlinkDetector.this.fPart != null) {
                DisassemblyHyperlinkDetector.this.fPart.gotoSymbol(this.fSymbol);
            }
        }
    }
}

