/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.views.properties.tabbed.view;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.viewers.IFilter;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.views.properties.tabbed.ISectionDescriptor;
import org.eclipse.ui.views.properties.tabbed.ITypeMapper;

public class TabbedPropertyRegistryClassSectionFilter {
    private ITypeMapper typeMapper = null;

    public TabbedPropertyRegistryClassSectionFilter(ITypeMapper typeMapper) {
        this.typeMapper = typeMapper;
    }

    public boolean appliesToSelection(ISectionDescriptor descriptor, ISelection selection) {
        if (selection instanceof IStructuredSelection && !selection.isEmpty()) {
            if (descriptor.getEnablesFor() != -1 && ((IStructuredSelection)selection).size() != descriptor.getEnablesFor()) {
                return false;
            }
            IFilter filter = descriptor.getFilter();
            if (filter != null) {
                for (Object object : (IStructuredSelection)selection) {
                    if (filter.select(object)) continue;
                    return false;
                }
                return true;
            }
            HashSet<Class> effectiveTypes = new HashSet<Class>();
            for (Object object : (IStructuredSelection)selection) {
                Class remapType = object.getClass();
                if (this.typeMapper != null) {
                    remapType = this.typeMapper.mapType(object);
                }
                if (!effectiveTypes.add(remapType) || this.appliesToEffectiveType(descriptor, remapType)) continue;
                return false;
            }
        } else if (descriptor.getFilter() != null) {
            return descriptor.getFilter().select((Object)selection);
        }
        return true;
    }

    private boolean appliesToEffectiveType(ISectionDescriptor descriptor, Class<?> inputClass) {
        ArrayList<String> classTypes = this.getClassTypes(inputClass);
        List sectionInputTypes = descriptor.getInputTypes();
        for (String type : sectionInputTypes) {
            if (!classTypes.contains(type)) continue;
            return true;
        }
        return false;
    }

    protected ArrayList<String> getClassTypes(Class<?> target) {
        ArrayList<String> result = new ArrayList<String>();
        List<Class<?>> classes = this.computeClassOrder(target);
        for (Class<?> curclass : classes) {
            result.add(curclass.getName());
        }
        result.addAll(this.computeInterfaceOrder(classes));
        return result;
    }

    private List<Class<?>> computeClassOrder(Class<?> target) {
        ArrayList result = new ArrayList(4);
        Class<?> clazz = target;
        while (clazz != null) {
            result.add(clazz);
            clazz = clazz.getSuperclass();
        }
        return result;
    }

    private List<String> computeInterfaceOrder(List<Class<?>> classes) {
        ArrayList<String> result = new ArrayList<String>(4);
        HashMap seen = new HashMap(4);
        for (Class<?> curclass : classes) {
            Class<?>[] interfaces = curclass.getInterfaces();
            this.internalComputeInterfaceOrder(interfaces, result, seen);
        }
        return result;
    }

    private void internalComputeInterfaceOrder(Class<?>[] interfaces, List<String> result, Map<Class<?>, Class<?>> seen) {
        ArrayList newInterfaces = new ArrayList(seen.size());
        Class<?>[] classArray = interfaces;
        int n = interfaces.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> clazz = classArray[n2];
            if (seen.get(clazz) == null) {
                result.add(clazz.getName());
                seen.put(clazz, clazz);
                newInterfaces.add(clazz);
            }
            ++n2;
        }
        for (Class clazz : newInterfaces) {
            this.internalComputeInterfaceOrder(clazz.getInterfaces(), result, seen);
        }
    }
}

