/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.gdb.internal.ui.viewmodel.breakpoints;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import org.eclipse.cdt.debug.core.model.ICBreakpoint;
import org.eclipse.cdt.dsf.concurrent.CountingRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.DsfRunnable;
import org.eclipse.cdt.dsf.concurrent.ImmediateCountingRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.ImmediateDataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.ImmediateExecutor;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.datamodel.DMContexts;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.service.IBreakpoints;
import org.eclipse.cdt.dsf.debug.service.IBreakpointsExtension;
import org.eclipse.cdt.dsf.debug.service.IRunControl;
import org.eclipse.cdt.dsf.debug.ui.viewmodel.breakpoints.BreakpointVMProvider;
import org.eclipse.cdt.dsf.gdb.internal.ui.GdbUIPlugin;
import org.eclipse.cdt.dsf.gdb.internal.ui.viewmodel.breakpoints.GdbBreakpointVMNode;
import org.eclipse.cdt.dsf.mi.service.IMIContainerDMContext;
import org.eclipse.cdt.dsf.mi.service.IMIExecutionDMContext;
import org.eclipse.cdt.dsf.mi.service.MIBreakpointDMData;
import org.eclipse.cdt.dsf.mi.service.MIBreakpointsManager;
import org.eclipse.cdt.dsf.mi.service.MIBreakpointsSynchronizer;
import org.eclipse.cdt.dsf.service.DsfServicesTracker;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.cdt.dsf.ui.viewmodel.AbstractVMAdapter;
import org.eclipse.cdt.dsf.ui.viewmodel.IVMNode;
import org.eclipse.cdt.dsf.ui.viewmodel.datamodel.IDMVMContext;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IPresentationContext;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class GdbBreakpointVMProvider
extends BreakpointVMProvider {
    private final DsfSession fSession;
    private final DsfServicesTracker fServicesTracker;
    private boolean fUseAggressiveBpFilter = false;
    private IPropertyChangeListener fPropertyChangeListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            if ("org.eclipse.cdt.dsf.gdb.aggressiveBpFilter".equals(event.getProperty())) {
                GdbBreakpointVMProvider.this.fUseAggressiveBpFilter = (Boolean)event.getNewValue();
                GdbBreakpointVMProvider.this.getPresentationContext().setProperty("org.eclipse.cdt.dsf.gdb.aggressiveBpFilter", (Object)GdbBreakpointVMProvider.this.fUseAggressiveBpFilter);
            }
        }
    };

    public GdbBreakpointVMProvider(AbstractVMAdapter adapter, IPresentationContext presentationContext, DsfSession session) {
        super(adapter, presentationContext);
        this.fSession = session;
        this.fServicesTracker = new DsfServicesTracker(GdbUIPlugin.getBundleContext(), this.fSession.getId());
        IPreferenceStore store = GdbUIPlugin.getDefault().getPreferenceStore();
        store.addPropertyChangeListener(this.fPropertyChangeListener);
        this.fUseAggressiveBpFilter = store.getBoolean("org.eclipse.cdt.dsf.gdb.aggressiveBpFilter");
    }

    public void dispose() {
        GdbUIPlugin.getDefault().getPreferenceStore().removePropertyChangeListener(this.fPropertyChangeListener);
        this.fServicesTracker.dispose();
        super.dispose();
    }

    protected void calcFileteredBreakpoints(DataRequestMonitor<IBreakpoint[]> rm) {
        if (Boolean.TRUE.equals(this.getPresentationContext().getProperty("FilterSelection"))) {
            if (this.fUseAggressiveBpFilter) {
                ISelection debugContext = this.getDebugContext();
                if (debugContext instanceof IStructuredSelection) {
                    final HashSet bps = new HashSet();
                    int count = 0;
                    final ImmediateCountingRequestMonitor crm = new ImmediateCountingRequestMonitor((RequestMonitor)rm, (DataRequestMonitor)rm, bps){
                        private final /* synthetic */ DataRequestMonitor val$rm;
                        private final /* synthetic */ Set val$bps;
                        {
                            this.val$rm = dataRequestMonitor;
                            this.val$bps = set;
                            super($anonymous0);
                        }

                        protected void handleSuccess() {
                            this.val$rm.done((Object)this.val$bps.toArray(new IBreakpoint[this.val$bps.size()]));
                        }
                    };
                    for (Object element : ((IStructuredSelection)debugContext).toList()) {
                        IBreakpoints.IBreakpointsTargetDMContext bpContext = null;
                        IRunControl.IExecutionDMContext execContext = null;
                        if (!(element instanceof IDMVMContext)) continue;
                        bpContext = (IBreakpoints.IBreakpointsTargetDMContext)DMContexts.getAncestorOfType((IDMContext)((IDMVMContext)element).getDMContext(), IBreakpoints.IBreakpointsTargetDMContext.class);
                        execContext = (IRunControl.IExecutionDMContext)DMContexts.getAncestorOfType((IDMContext)((IDMVMContext)element).getDMContext(), IRunControl.IExecutionDMContext.class);
                        if (bpContext == null || !this.fSession.getId().equals(bpContext.getSessionId())) continue;
                        ++count;
                        this.getInstalledBreakpoints(bpContext, execContext, new DataRequestMonitor<Collection<IBreakpoint>>(this.getExecutor(), (RequestMonitor)crm){

                            protected void handleCompleted() {
                                if (this.isSuccess()) {
                                    bps.addAll((Collection)this.getData());
                                }
                                crm.done();
                            }
                        });
                    }
                    crm.setDoneCount(count);
                } else {
                    rm.done((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb.ui", 10002, "Invalid debug selection", null));
                }
            } else {
                IBreakpoint[] allBreakpoints = DebugPlugin.getDefault().getBreakpointManager().getBreakpoints();
                ArrayList<IBreakpoint> filteredBPs = new ArrayList<IBreakpoint>(allBreakpoints.length);
                IBreakpoint[] iBreakpointArray = allBreakpoints;
                int n = allBreakpoints.length;
                int n2 = 0;
                while (n2 < n) {
                    IBreakpoint bp = iBreakpointArray[n2];
                    if (bp instanceof ICBreakpoint && bp.getModelIdentifier().equals("org.eclipse.cdt.debug.core")) {
                        filteredBPs.add(bp);
                    }
                    ++n2;
                }
                rm.done((Object)filteredBPs.toArray(new IBreakpoint[filteredBPs.size()]));
            }
        } else {
            super.calcFileteredBreakpoints(rm);
        }
    }

    protected IVMNode createBreakpointVMNode() {
        return new GdbBreakpointVMNode(this);
    }

    public void getBreakpointsForDebugContext(ISelection debugContext, final DataRequestMonitor<IBreakpoint[]> rm) {
        Object element;
        IRunControl.IExecutionDMContext _execCtx = null;
        if (debugContext instanceof IStructuredSelection && (element = ((IStructuredSelection)debugContext).getFirstElement()) instanceof IDMVMContext) {
            _execCtx = (IRunControl.IExecutionDMContext)DMContexts.getAncestorOfType((IDMContext)((IDMVMContext)element).getDMContext(), IRunControl.IExecutionDMContext.class);
        }
        if (_execCtx == null || !this.fSession.getId().equals(_execCtx.getSessionId())) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb.ui", 10002, "Debug context doesn't contain a thread", null));
            rm.done();
            return;
        }
        final IRunControl.IExecutionDMContext execCtx = _execCtx;
        try {
            this.fSession.getExecutor().execute((Runnable)new DsfRunnable(){

                public void run() {
                    IBreakpointsExtension bpService = (IBreakpointsExtension)GdbBreakpointVMProvider.this.fServicesTracker.getService(IBreakpointsExtension.class);
                    if (bpService == null) {
                        rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb.ui", 10001, "Breakpoints service not available", null));
                        rm.done();
                        return;
                    }
                    bpService.getExecutionContextBreakpoints(execCtx, (DataRequestMonitor)new DataRequestMonitor<IBreakpoints.IBreakpointDMContext[]>((Executor)GdbBreakpointVMProvider.this.fSession.getExecutor(), (RequestMonitor)rm){

                        protected void handleSuccess() {
                            MIBreakpointsManager bpManager = (MIBreakpointsManager)(this).GdbBreakpointVMProvider.this.fServicesTracker.getService(MIBreakpointsManager.class);
                            if (bpManager == null) {
                                rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb.ui", 10001, "Breakpoints service not available", null));
                                rm.done();
                                return;
                            }
                            IBreakpoint bp = null;
                            if (((IBreakpoints.IBreakpointDMContext[])this.getData()).length > 0) {
                                bp = bpManager.findPlatformBreakpoint(((IBreakpoints.IBreakpointDMContext[])this.getData())[0]);
                            }
                            if (bp != null) {
                                rm.setData((Object)new IBreakpoint[]{bp});
                            } else {
                                rm.setData((Object)new IBreakpoint[0]);
                            }
                            rm.done();
                        }
                    });
                }
            });
        }
        catch (RejectedExecutionException e) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb.ui", 10001, "Request for monitor: '" + ((Object)((Object)this)).toString() + "' resulted in a rejected execution exception.", (Throwable)e));
            rm.done();
        }
    }

    private ISelection getDebugContext() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null) {
            return DebugUITools.getDebugContextManager().getContextService(window).getActiveContext();
        }
        return StructuredSelection.EMPTY;
    }

    private void getInstalledBreakpoints(final IBreakpoints.IBreakpointsTargetDMContext targetContext, final IRunControl.IExecutionDMContext execContext, final DataRequestMonitor<Collection<IBreakpoint>> rm) {
        try {
            this.fSession.getExecutor().execute((Runnable)new DsfRunnable(){

                public void run() {
                    final IBreakpointsExtension bpService = (IBreakpointsExtension)GdbBreakpointVMProvider.this.fServicesTracker.getService(IBreakpointsExtension.class);
                    if (bpService == null) {
                        rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb.ui", 10001, "Breakpoints service not available", null));
                        rm.done();
                        return;
                    }
                    bpService.getBreakpoints(targetContext, (DataRequestMonitor)new DataRequestMonitor<IBreakpoints.IBreakpointDMContext[]>((Executor)GdbBreakpointVMProvider.this.fSession.getExecutor(), (RequestMonitor)rm){

                        protected void handleSuccess() {
                            final MIBreakpointsManager bpManager = (MIBreakpointsManager)(this).GdbBreakpointVMProvider.this.fServicesTracker.getService(MIBreakpointsManager.class);
                            if (bpManager == null) {
                                rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb.ui", 10001, "Breakpoint manager service not available", null));
                                rm.done();
                                return;
                            }
                            if (((IBreakpoints.IBreakpointDMContext[])this.getData()).length > 0) {
                                final HashSet bps = new HashSet(((IBreakpoints.IBreakpointDMContext[])this.getData()).length);
                                final CountingRequestMonitor crm = new CountingRequestMonitor(ImmediateExecutor.getInstance(), (RequestMonitor)rm){

                                    protected void handleSuccess() {
                                        rm.setData((Object)bps);
                                        rm.done();
                                    }
                                };
                                crm.setDoneCount(((IBreakpoints.IBreakpointDMContext[])this.getData()).length);
                                IBreakpoints.IBreakpointDMContext[] iBreakpointDMContextArray = (IBreakpoints.IBreakpointDMContext[])this.getData();
                                int n = iBreakpointDMContextArray.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    final IBreakpoints.IBreakpointDMContext bpCtx = iBreakpointDMContextArray[n2];
                                    bpService.getBreakpointDMData(bpCtx, (DataRequestMonitor)new DataRequestMonitor<IBreakpoints.IBreakpointDMData>(ImmediateExecutor.getInstance(), (RequestMonitor)crm){

                                        protected void handleSuccess() {
                                            MIBreakpointDMData data;
                                            if (this.getData() instanceof MIBreakpointDMData && !(data = (MIBreakpointDMData)this.getData()).isPending()) {
                                                GdbBreakpointVMProvider.this.bpBelongsToContext(execContext, data, (DataRequestMonitor<Boolean>)new ImmediateDataRequestMonitor<Boolean>((RequestMonitor)crm){

                                                    protected void handleSuccess() {
                                                        IBreakpoint bp;
                                                        if (((Boolean)this.getData()).booleanValue() && (bp = bpManager.findPlatformBreakpoint(bpCtx)) != null) {
                                                            bps.add(bp);
                                                        }
                                                        crm.done();
                                                    }
                                                });
                                                return;
                                            }
                                            crm.done();
                                        }
                                    });
                                    ++n2;
                                }
                            } else {
                                rm.setData(new HashSet());
                                rm.done();
                            }
                        }
                    });
                }
            });
        }
        catch (RejectedExecutionException e) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb.ui", 10001, "Request for monitor: '" + ((Object)((Object)this)).toString() + "' resulted in a rejected execution exception.", (Throwable)e));
            rm.done();
        }
    }

    private void bpBelongsToContext(IRunControl.IExecutionDMContext execContext, MIBreakpointDMData data, DataRequestMonitor<Boolean> rm) {
        String bpThreadId;
        if (execContext == null) {
            rm.done((Object)true);
            return;
        }
        IMIExecutionDMContext threadContext = (IMIExecutionDMContext)DMContexts.getAncestorOfType((IDMContext)execContext, IMIExecutionDMContext.class);
        if (threadContext != null && data.getThreadId() != null && data.getThreadId().length() > 0 && !(bpThreadId = data.getThreadId().trim()).equals("0")) {
            String ctxThreadId = threadContext.getThreadId();
            rm.done((Object)ctxThreadId.equals(bpThreadId));
            return;
        }
        IMIContainerDMContext containerContext = (IMIContainerDMContext)DMContexts.getAncestorOfType((IDMContext)execContext, IMIContainerDMContext.class);
        if (containerContext != null) {
            if (data.getGroupIds() != null) {
                List<String> groupIds = Arrays.asList(data.getGroupIds());
                rm.done((Object)groupIds.contains(containerContext.getGroupId()));
            } else {
                rm.done((Object)true);
            }
        } else {
            rm.done((Object)true);
        }
    }

    public void refresh() {
        super.refresh();
        try {
            this.fSession.getExecutor().execute((Runnable)new DsfRunnable(){

                public void run() {
                    DsfServicesTracker tracker = new DsfServicesTracker(GdbUIPlugin.getBundleContext(), GdbBreakpointVMProvider.this.fSession.getId());
                    MIBreakpointsSynchronizer breakpointsSynchronizer = (MIBreakpointsSynchronizer)tracker.getService(MIBreakpointsSynchronizer.class);
                    if (breakpointsSynchronizer != null) {
                        breakpointsSynchronizer.flushCache(null);
                    }
                    tracker.dispose();
                }
            });
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            // empty catch block
        }
    }
}

