/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.gdb.service;

import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.concurrent.Executor;
import org.eclipse.cdt.debug.core.model.IChangeReverseMethodHandler;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.DsfRunnable;
import org.eclipse.cdt.dsf.concurrent.ImmediateDataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.ImmediateRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.datamodel.DMContexts;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.service.IRunControl;
import org.eclipse.cdt.dsf.debug.service.command.ICommandControlService;
import org.eclipse.cdt.dsf.gdb.service.GDBRunControl_7_10;
import org.eclipse.cdt.dsf.gdb.service.IGDBBackend;
import org.eclipse.cdt.dsf.mi.service.IMICommandControl;
import org.eclipse.cdt.dsf.mi.service.IMIExecutionDMContext;
import org.eclipse.cdt.dsf.mi.service.command.CommandFactory;
import org.eclipse.cdt.dsf.mi.service.command.events.IMIDMEvent;
import org.eclipse.cdt.dsf.mi.service.command.events.MIBreakpointHitEvent;
import org.eclipse.cdt.dsf.mi.service.command.events.MIStoppedEvent;
import org.eclipse.cdt.dsf.mi.service.command.output.MIBreakpoint;
import org.eclipse.cdt.dsf.mi.service.command.output.MIFrame;
import org.eclipse.cdt.dsf.mi.service.command.output.MIInfo;
import org.eclipse.cdt.dsf.service.DsfServiceEventHandler;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

public class GDBRunControl_7_12
extends GDBRunControl_7_10 {
    private IMICommandControl fCommandControl;
    private CommandFactory fCommandFactory;
    private IGDBBackend fGDBBackEnd;
    private Map<String, EnableReverseAtLocOperation> fBpIdToReverseOpMap = new HashMap<String, EnableReverseAtLocOperation>();

    public GDBRunControl_7_12(DsfSession session) {
        super(session);
    }

    @Override
    public void initialize(final RequestMonitor rm) {
        super.initialize((RequestMonitor)new ImmediateRequestMonitor(rm){

            protected void handleSuccess() {
                GDBRunControl_7_12.this.doInitialize(rm);
            }
        });
    }

    private void doInitialize(RequestMonitor rm) {
        this.fCommandControl = (IMICommandControl)this.getServicesTracker().getService(IMICommandControl.class);
        this.fGDBBackEnd = (IGDBBackend)this.getServicesTracker().getService(IGDBBackend.class);
        this.fCommandFactory = this.fCommandControl.getCommandFactory();
        this.register(new String[]{GDBRunControl_7_12.class.getName()}, new Hashtable());
        rm.done();
    }

    @Override
    public void suspend(final IRunControl.IExecutionDMContext context, final RequestMonitor rm) {
        this.canSuspend(context, new DataRequestMonitor<Boolean>((Executor)this.getExecutor(), rm){

            protected void handleSuccess() {
                if (((Boolean)this.getData()).booleanValue()) {
                    GDBRunControl_7_12.this.doSuspend(context, rm);
                } else {
                    rm.done((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10001, "Context cannot be suspended.", null));
                }
            }
        });
    }

    private void doSuspend(IRunControl.IExecutionDMContext context, final RequestMonitor rm) {
        if (this.fGDBBackEnd.useTargetAsync()) {
            final MonitorSuspendJob monitorJob = new MonitorSuspendJob(0, rm);
            this.fCommandControl.queueCommand(this.fCommandFactory.createMIExecInterrupt(context), (DataRequestMonitor)new ImmediateDataRequestMonitor<MIInfo>(){

                protected void handleSuccess() {
                }

                protected void handleFailure() {
                    monitorJob.cleanAndCancel();
                    rm.done(this.getStatus());
                }
            });
        } else {
            super.suspend(context, rm);
        }
    }

    @Override
    public boolean isTargetAcceptingCommands() {
        if (this.fGDBBackEnd.useTargetAsync()) {
            return true;
        }
        return super.isTargetAcceptingCommands();
    }

    @DsfServiceEventHandler
    public void eventDispatched(IRunControl.ISuspendedDMEvent event) {
        Object evt;
        assert (event instanceof IMIDMEvent);
        if (event instanceof IMIDMEvent && (evt = ((IMIDMEvent)event).getMIEvent()) instanceof MIBreakpointHitEvent) {
            MIBreakpointHitEvent miEvt = (MIBreakpointHitEvent)((Object)evt);
            for (final EnableReverseAtLocOperation enableReverse : this.fBpIdToReverseOpMap.values()) {
                if (!this.breakpointHitMatchesLocation(miEvt, enableReverse)) continue;
                this.fBpIdToReverseOpMap.remove(enableReverse.fBpId);
                final IRunControl.IContainerDMContext containerContext = enableReverse.getContainerContext();
                ICommandControlService.ICommandControlDMContext controlDmc = (ICommandControlService.ICommandControlDMContext)DMContexts.getAncestorOfType((IDMContext)containerContext, ICommandControlService.ICommandControlDMContext.class);
                IChangeReverseMethodHandler.ReverseDebugMethod reverseMethod = enableReverse.getReverseDebugMethod();
                if (controlDmc == null || reverseMethod == null) break;
                this.enableReverseMode(controlDmc, reverseMethod, new RequestMonitor((Executor)this.getExecutor(), null){

                    protected void handleSuccess() {
                        if (enableReverse.shouldTriggerContinue()) {
                            GDBRunControl_7_12.this.fCommandControl.queueCommand(GDBRunControl_7_12.this.fCommandFactory.createMIExecContinue((IRunControl.IExecutionDMContext)containerContext), (DataRequestMonitor)new ImmediateDataRequestMonitor());
                        }
                    }
                });
                break;
            }
        }
    }

    void enableReverseModeAtBpLocation(IRunControl.IContainerDMContext containerContext, IChangeReverseMethodHandler.ReverseDebugMethod traceMethod, MIBreakpoint bp, boolean triggerContinue) {
        String fileLoc = String.valueOf(bp.getFile()) + ":" + bp.getLine();
        this.fBpIdToReverseOpMap.put(bp.getNumber(), new EnableReverseAtLocOperation(containerContext, traceMethod, bp.getNumber(), fileLoc, bp.getAddress(), triggerContinue));
    }

    private boolean breakpointHitMatchesLocation(MIBreakpointHitEvent e, EnableReverseAtLocOperation enableReverse) {
        if (enableReverse != null) {
            String bpId = e.getNumber();
            boolean equalFileLocation = false;
            boolean equalAddrLocation = false;
            boolean equalBpId = bpId.equals(enableReverse.getBreakointId());
            MIFrame frame = e.getFrame();
            if (frame != null) {
                String fileLocation = String.valueOf(frame.getFile()) + ":" + frame.getLine();
                String addrLocation = frame.getAddress();
                equalFileLocation = fileLocation.equals(enableReverse.getFileLocation());
                equalAddrLocation = addrLocation.equals(enableReverse.getAddrLocation());
            }
            if (equalFileLocation || equalAddrLocation || equalBpId) {
                return true;
            }
        }
        return false;
    }

    private static class EnableReverseAtLocOperation {
        private final IRunControl.IContainerDMContext fContainerContext;
        private final IChangeReverseMethodHandler.ReverseDebugMethod fTraceMethod;
        private final String fBpId;
        private final String fFileLocation;
        private final String fAddrLocation;
        private final boolean fTriggerContinue;

        public EnableReverseAtLocOperation(IRunControl.IContainerDMContext containerContext, IChangeReverseMethodHandler.ReverseDebugMethod traceMethod, String bpId, String fileLoc, String addr, boolean tiggerContinue) {
            this.fContainerContext = containerContext;
            this.fTraceMethod = traceMethod;
            this.fBpId = bpId;
            this.fFileLocation = fileLoc;
            this.fAddrLocation = addr;
            this.fTriggerContinue = tiggerContinue;
        }

        public IRunControl.IContainerDMContext getContainerContext() {
            return this.fContainerContext;
        }

        public IChangeReverseMethodHandler.ReverseDebugMethod getReverseDebugMethod() {
            return this.fTraceMethod;
        }

        public String getBreakointId() {
            return this.fBpId;
        }

        public String getFileLocation() {
            return this.fFileLocation;
        }

        public String getAddrLocation() {
            return this.fAddrLocation;
        }

        public boolean shouldTriggerContinue() {
            return this.fTriggerContinue;
        }

        public int hashCode() {
            return this.fBpId.hashCode();
        }

        public boolean equals(Object other) {
            return other instanceof EnableReverseAtLocOperation && this.fContainerContext != null && this.fContainerContext.equals(((EnableReverseAtLocOperation)other).fContainerContext) && this.fTraceMethod != null && this.fTraceMethod.equals((Object)((EnableReverseAtLocOperation)other).fTraceMethod) && this.fBpId != null && this.fBpId.equals(((EnableReverseAtLocOperation)other).fBpId) && this.fFileLocation != null && this.fFileLocation.equals(((EnableReverseAtLocOperation)other).fFileLocation) && this.fAddrLocation != null && this.fAddrLocation.equals(((EnableReverseAtLocOperation)other).fAddrLocation) && this.fTriggerContinue == ((EnableReverseAtLocOperation)other).fTriggerContinue;
        }
    }

    protected class MonitorSuspendJob
    extends Job {
        private static final int TIMEOUT_DEFAULT_VALUE = 5000;
        private final RequestMonitor fRequestMonitor;

        public MonitorSuspendJob(int timeout, RequestMonitor rm) {
            super("Suspend monitor job.");
            this.setSystem(true);
            this.fRequestMonitor = rm;
            if (timeout <= 0) {
                timeout = 5000;
            }
            GDBRunControl_7_12.this.getSession().addServiceEventListener((Object)this, null);
            this.schedule(timeout);
        }

        public boolean cleanAndCancel() {
            if (GDBRunControl_7_12.this.getExecutor().isInExecutorThread()) {
                GDBRunControl_7_12.this.getSession().removeServiceEventListener((Object)this);
            } else {
                GDBRunControl_7_12.this.getExecutor().submit((Runnable)new DsfRunnable(){

                    public void run() {
                        GDBRunControl_7_12.this.getSession().removeServiceEventListener((Object)MonitorSuspendJob.this);
                    }
                });
            }
            return this.cancel();
        }

        @DsfServiceEventHandler
        public void eventDispatched(MIStoppedEvent e) {
            if (e.getDMContext() != null && e.getDMContext() instanceof IMIExecutionDMContext && this.cleanAndCancel()) {
                this.fRequestMonitor.done();
            }
        }

        protected IStatus run(IProgressMonitor monitor) {
            GDBRunControl_7_12.this.getExecutor().submit((Runnable)new DsfRunnable(){

                public void run() {
                    GDBRunControl_7_12.this.getSession().removeServiceEventListener((Object)MonitorSuspendJob.this);
                    MonitorSuspendJob.this.fRequestMonitor.done((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10004, "Suspend operation timeout.", null));
                }
            });
            return Status.OK_STATUS;
        }
    }
}

