/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.c;

import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTArrayDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTArrayModifier;
import org.eclipse.cdt.core.dom.ast.IASTInitializer;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.parser.util.ArrayUtil;
import org.eclipse.cdt.internal.core.dom.parser.c.CASTDeclarator;

public class CASTArrayDeclarator
extends CASTDeclarator
implements IASTArrayDeclarator {
    private IASTArrayModifier[] arrayMods;
    private int arrayModsPos = -1;

    public CASTArrayDeclarator() {
    }

    public CASTArrayDeclarator(IASTName name, IASTInitializer initializer) {
        super(name, initializer);
    }

    public CASTArrayDeclarator(IASTName name) {
        super(name);
    }

    @Override
    public CASTArrayDeclarator copy() {
        return this.copy(IASTNode.CopyStyle.withoutLocations);
    }

    @Override
    public CASTArrayDeclarator copy(IASTNode.CopyStyle style) {
        CASTArrayDeclarator copy = new CASTArrayDeclarator();
        IASTArrayModifier[] iASTArrayModifierArray = this.getArrayModifiers();
        int n = iASTArrayModifierArray.length;
        int n2 = 0;
        while (n2 < n) {
            IASTArrayModifier modifier = iASTArrayModifierArray[n2];
            copy.addArrayModifier(modifier == null ? null : modifier.copy(style));
            ++n2;
        }
        return this.copy(copy, style);
    }

    @Override
    public IASTArrayModifier[] getArrayModifiers() {
        if (this.arrayMods == null) {
            return IASTArrayModifier.EMPTY_ARRAY;
        }
        this.arrayMods = ArrayUtil.trimAt(IASTArrayModifier.class, this.arrayMods, this.arrayModsPos);
        return this.arrayMods;
    }

    @Override
    public void addArrayModifier(IASTArrayModifier arrayModifier) {
        this.assertNotFrozen();
        if (arrayModifier != null) {
            arrayModifier.setParent(this);
            arrayModifier.setPropertyInParent(ARRAY_MODIFIER);
            this.arrayMods = ArrayUtil.appendAt(IASTArrayModifier.class, this.arrayMods, ++this.arrayModsPos, arrayModifier);
        }
    }

    @Override
    protected boolean postAccept(ASTVisitor action) {
        IASTArrayModifier[] mods = this.getArrayModifiers();
        int i = 0;
        while (i < mods.length) {
            if (!mods[i].accept(action)) {
                return false;
            }
            ++i;
        }
        return super.postAccept(action);
    }
}

