/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.examples.dsf.timers;

import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.eclipse.cdt.dsf.concurrent.Immutable;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.datamodel.AbstractDMContext;
import org.eclipse.cdt.dsf.datamodel.AbstractDMEvent;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.service.AbstractDsfService;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.cdt.examples.dsf.DsfExamplesPlugin;
import org.osgi.framework.BundleContext;

public class TimerService
extends AbstractDsfService {
    private int fTimerNumberCounter = 1;
    private Map<TimerDMContext, Integer> fTimers = new LinkedHashMap<TimerDMContext, Integer>();
    private Map<TimerDMContext, Future<?>> fTimerFutures = new HashMap();

    TimerService(DsfSession session) {
        super(session);
    }

    protected BundleContext getBundleContext() {
        return DsfExamplesPlugin.getDefault().getBundle().getBundleContext();
    }

    public void initialize(final RequestMonitor requestMonitor) {
        super.initialize(new RequestMonitor((Executor)this.getExecutor(), requestMonitor){

            public void handleSuccess() {
                TimerService.this.doInitialize(requestMonitor);
            }
        });
    }

    private void doInitialize(RequestMonitor requestMonitor) {
        this.register(new String[]{TimerService.class.getName()}, new Hashtable());
        requestMonitor.done();
    }

    public void shutdown(RequestMonitor requestMonitor) {
        for (Future<?> future : this.fTimerFutures.values()) {
            future.cancel(false);
        }
        this.unregister();
        super.shutdown(requestMonitor);
    }

    public TimerDMContext[] getTimers() {
        return this.fTimers.keySet().toArray(new TimerDMContext[this.fTimers.size()]);
    }

    public int getTimerValue(TimerDMContext context) {
        Integer value = this.fTimers.get((Object)context);
        if (value != null) {
            return value;
        }
        return -1;
    }

    public TimerDMContext startTimer() {
        final TimerDMContext newTimer = new TimerDMContext(this.getSession().getId(), this.fTimerNumberCounter++);
        this.fTimers.put(newTimer, 0);
        ScheduledFuture timerFuture = this.getExecutor().scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                TimerService.this.fTimers.put(newTimer, TimerService.this.fTimers.get((Object)newTimer) + 1);
                TimerService.this.getSession().dispatchEvent((Object)new TimerTickDMEvent(newTimer), TimerService.this.getProperties());
            }

            public String toString() {
                return "Scheduled timer runnable for timer " + (Object)((Object)newTimer);
            }
        }, 1L, 1L, TimeUnit.SECONDS);
        this.fTimerFutures.put(newTimer, timerFuture);
        this.getSession().dispatchEvent((Object)new TimersChangedEvent(), this.getProperties());
        return newTimer;
    }

    public void killTimer(TimerDMContext timerContext) {
        if (this.fTimers.containsKey((Object)timerContext)) {
            this.fTimers.remove((Object)timerContext);
            this.fTimerFutures.remove((Object)timerContext).cancel(false);
        }
        this.getSession().dispatchEvent((Object)new TimersChangedEvent(), this.getProperties());
    }

    @Immutable
    public static class TimerDMContext
    extends AbstractDMContext {
        final int fNumber;

        public TimerDMContext(String sessionId, int timer) {
            super(sessionId, new IDMContext[0]);
            this.fNumber = timer;
        }

        public int getTimerNumber() {
            return this.fNumber;
        }

        public boolean equals(Object other) {
            return this.baseEquals(other) && ((TimerDMContext)((Object)other)).fNumber == this.fNumber;
        }

        public int hashCode() {
            return this.baseHashCode() + this.fNumber;
        }

        public String toString() {
            return String.valueOf(this.baseToString()) + ".timer[" + this.fNumber + "]";
        }
    }

    public class TimerTickDMEvent
    extends AbstractDMEvent<TimerDMContext> {
        public TimerTickDMEvent(TimerDMContext context) {
            super((IDMContext)context);
        }
    }

    @Immutable
    public static class TimersChangedEvent {
    }
}

