/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.examples.dsf.pda.ui;

import org.eclipse.cdt.dsf.concurrent.ThreadSafe;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.cdt.examples.dsf.pda.launch.PDALaunch;
import org.eclipse.cdt.examples.dsf.pda.ui.PDAUIPlugin;
import org.eclipse.cdt.examples.dsf.pda.ui.SessionAdapterSet;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementContentProvider;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelProxyFactory;
import org.eclipse.debug.ui.contexts.ISuspendTrigger;

@ThreadSafe
public class PDAAdapterFactory
implements IAdapterFactory {
    public <T> T getAdapter(Object adaptableObject, Class<T> adapterType) {
        if (!(adaptableObject instanceof PDALaunch)) {
            return null;
        }
        PDALaunch launch = (PDALaunch)adaptableObject;
        DsfSession session = launch.getSession();
        if (session == null) {
            return null;
        }
        SessionAdapterSet adapterSet = PDAUIPlugin.getDefault().getAdapterSet(launch);
        if (adapterSet == null) {
            return null;
        }
        if (adapterType.equals(IElementContentProvider.class)) {
            return adapterType.cast((Object)adapterSet.fViewModelAdapter);
        }
        if (adapterType.equals(IModelProxyFactory.class)) {
            return adapterType.cast((Object)adapterSet.fViewModelAdapter);
        }
        if (adapterType.equals(ISuspendTrigger.class)) {
            return adapterType.cast((Object)adapterSet.fSuspendTrigger);
        }
        return null;
    }

    public Class<?>[] getAdapterList() {
        return new Class[]{IElementContentProvider.class, IModelProxyFactory.class, ISuspendTrigger.class};
    }
}

