/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.lsp.internal.ui.properties;

import java.util.Optional;
import org.eclipse.cdt.lsp.core.preferences.LanguageServerPreferenceMetadata;
import org.eclipse.cdt.lsp.internal.core.preferences.LanguageServerDefaults;
import org.eclipse.cdt.lsp.internal.ui.LspUiMessages;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.PreferenceMetadata;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.dialogs.PropertyPage;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;
import org.osgi.service.prefs.BackingStoreException;

public final class LanguageServerPropertyPage
extends PropertyPage {
    private LanguageServerPreferenceMetadata metadata = new LanguageServerDefaults();
    private Button prefer;

    private void addHeaderSection(Composite parent) {
        Composite composite = this.createDefaultComposite(parent);
        Label warning = new Label(composite, 0);
        warning.setText(LspUiMessages.LanguageServerPropertyPage_w_ls_experimental);
    }

    private void addSeparator(Composite parent) {
        Label separator = new Label(parent, 258);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        separator.setLayoutData((Object)gridData);
    }

    private void addSettingsSection(Composite parent) {
        PreferenceMetadata option = this.metadata.preferLanguageServer();
        Composite composite = this.createDefaultComposite(parent);
        this.prefer = new Button(composite, 32);
        this.prefer.setLayoutData((Object)new GridData());
        this.prefer.setText(option.name());
        this.prefer.setToolTipText(option.description());
    }

    private void load() {
        Optional<IProject> project = this.project();
        PreferenceMetadata option = this.metadata.preferLanguageServer();
        if (project.isPresent()) {
            this.prefer.setSelection(Platform.getPreferencesService().getBoolean("org.eclipse.cdt.lsp.core", option.identifer(), ((Boolean)option.defaultValue()).booleanValue(), new IScopeContext[]{new ProjectScope(project.get())}));
        } else {
            this.prefer.setSelection(((Boolean)option.defaultValue()).booleanValue());
        }
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        composite.setLayout((Layout)layout);
        GridData data = new GridData(4);
        data.grabExcessHorizontalSpace = true;
        composite.setLayoutData((Object)data);
        this.addHeaderSection(composite);
        this.addSeparator(composite);
        this.addSettingsSection(composite);
        this.load();
        return composite;
    }

    private Composite createDefaultComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)GridDataFactory.fillDefaults().create());
        return composite;
    }

    protected void performDefaults() {
        super.performDefaults();
        this.prefer.setSelection(((Boolean)this.metadata.preferLanguageServer().defaultValue()).booleanValue());
    }

    public boolean performOk() {
        Optional<IProject> project = this.project();
        if (project.isPresent()) {
            IEclipsePreferences node = new ProjectScope(project.get()).getNode("org.eclipse.cdt.lsp.core");
            node.putBoolean(this.metadata.preferLanguageServer().identifer(), this.prefer.getSelection());
            try {
                node.flush();
                return true;
            }
            catch (BackingStoreException e) {
                Platform.getLog((Bundle)FrameworkUtil.getBundle(((Object)((Object)this)).getClass())).error(e.getMessage(), (Throwable)e);
            }
        }
        return false;
    }

    private Optional<IProject> project() {
        return Optional.ofNullable(this.getElement()).filter(IProject.class::isInstance).map(IProject.class::cast);
    }
}

