/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.lsp.internal.ui.text;

import java.net.URI;
import java.util.Collection;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import org.eclipse.cdt.lsp.internal.core.workspace.ResolveDocumentUri;
import org.eclipse.cdt.lsp.internal.ui.text.PresentationReconcilerCPP;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.lsp4j.Range;

public final class SetInactiveRegions
implements BiConsumer<Supplier<URI>, Supplier<Collection<Range>>> {
    private final ResolveDocumentUri resolve = new ResolveDocumentUri();

    @Override
    public void accept(Supplier<URI> uri, Supplier<Collection<Range>> ranges) {
        URI uriReceived = uri.get();
        Collection<Range> inactiveRegions = ranges.get();
        IDocument doc = null;
        for (PresentationReconcilerCPP eachReconciler : PresentationReconcilerCPP.presentationReconcilers) {
            IDocument currentReconcilerDoc = eachReconciler.getTextViewer().getDocument();
            Optional currentReconcilerUri = this.resolve.apply(currentReconcilerDoc);
            if (!currentReconcilerUri.isPresent() || !uriReceived.equals(currentReconcilerUri.get())) continue;
            doc = currentReconcilerDoc;
            break;
        }
        if (doc == null) {
            return;
        }
        try {
            doc.removePositionCategory("org.eclipse.cdt.lsp.core.inactiveCodeHighlight");
        }
        catch (BadPositionCategoryException e) {
            Platform.getLog(this.getClass()).error(e.getMessage(), (Throwable)e);
        }
        doc.addPositionCategory("org.eclipse.cdt.lsp.core.inactiveCodeHighlight");
        for (Range region : inactiveRegions) {
            int offset = 0;
            int length = 0;
            try {
                offset = doc.getLineOffset(region.getStart().getLine());
                length = doc.getLineOffset(region.getEnd().getLine()) - offset;
            }
            catch (BadLocationException e) {
                Platform.getLog(this.getClass()).error(e.getMessage(), (Throwable)e);
            }
            Position inactivePosition = new Position(offset, length);
            try {
                doc.addPosition("org.eclipse.cdt.lsp.core.inactiveCodeHighlight", inactivePosition);
            }
            catch (BadLocationException | BadPositionCategoryException e) {
                Platform.getLog(this.getClass()).error(e.getMessage(), e);
            }
        }
    }
}

