/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.internal.core.makefile.gnu;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.cdt.make.core.makefile.IDirective;
import org.eclipse.cdt.make.core.makefile.IMakefile;
import org.eclipse.cdt.make.core.makefile.IMakefileReaderProvider;
import org.eclipse.cdt.make.core.makefile.gnu.IInclude;
import org.eclipse.cdt.make.internal.core.makefile.Directive;
import org.eclipse.cdt.make.internal.core.makefile.Parent;
import org.eclipse.cdt.make.internal.core.makefile.gnu.GNUMakefile;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class Include
extends Parent
implements IInclude {
    String[] filenames;
    String[] dirs;

    public Include(Directive parent, String[] files, String[] directories) {
        super(parent);
        this.filenames = files;
        this.dirs = directories;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("include");
        int i = 0;
        while (i < this.filenames.length) {
            sb.append(' ').append(this.filenames[i]);
            ++i;
        }
        return sb.toString();
    }

    @Override
    public String[] getFilenames() {
        return this.filenames;
    }

    private IMakefileReaderProvider getCurrentMakefileReaderProvider() {
        IDirective directive = this;
        while (directive != null) {
            IMakefileReaderProvider makefileReaderProvider;
            if (directive instanceof IMakefile && (makefileReaderProvider = ((IMakefile)directive).getMakefileReaderProvider()) != null) {
                return makefileReaderProvider;
            }
            directive = directive.getParent();
        }
        return null;
    }

    @Override
    public IDirective[] getDirectives() {
        this.clearDirectives();
        URI uri = this.getMakefile().getFileURI();
        IMakefileReaderProvider makefileReaderProvider = this.getCurrentMakefileReaderProvider();
        int i = 0;
        while (i < this.filenames.length) {
            Path includeFilePath = new Path(this.filenames[i]);
            if (includeFilePath.isAbsolute()) {
                IPath path = URIUtil.toPath((URI)uri);
                if (path != null) {
                    String device = path.getDevice();
                    if (device != null && includeFilePath.getDevice() == null) {
                        includeFilePath = includeFilePath.setDevice(device);
                    }
                    try {
                        URI includeURI = URIUtil.toURI((IPath)includeFilePath);
                        if (!this.isAlreadyIncluded(includeURI)) {
                            GNUMakefile gnu = new GNUMakefile();
                            gnu.parse(includeURI, makefileReaderProvider);
                            this.addDirective(gnu);
                        }
                    }
                    catch (IOException includeURI) {}
                }
            } else if (this.dirs != null) {
                int j = 0;
                while (j < this.dirs.length) {
                    try {
                        URI includeURI;
                        IPath testIncludeFilePath = new Path(this.dirs[j]).append((IPath)includeFilePath);
                        String uriPath = testIncludeFilePath.toString();
                        if (testIncludeFilePath.getDevice() != null) {
                            uriPath = String.valueOf('/') + uriPath;
                        }
                        if (this.isAlreadyIncluded(includeURI = new URI(uri.getScheme(), uri.getUserInfo(), uri.getHost(), uri.getPort(), uriPath, null, null))) break;
                        GNUMakefile gnu = new GNUMakefile();
                        gnu.parse(includeURI, makefileReaderProvider);
                        this.addDirective(gnu);
                        break;
                    }
                    catch (IOException iOException) {
                    }
                    catch (URISyntaxException uRISyntaxException) {
                        // empty catch block
                    }
                    ++j;
                }
            }
            ++i;
        }
        return super.getDirectives();
    }

    private boolean isAlreadyIncluded(URI includeURI) {
        IDirective parent = this.getParent();
        while (parent != null) {
            if (parent instanceof IMakefile && includeURI.equals(((IMakefile)parent).getFileURI())) {
                return true;
            }
            parent = parent.getParent();
        }
        return false;
    }
}

