/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.core.memory.transport;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import org.eclipse.cdt.debug.core.memory.transport.ExportRequest;
import org.eclipse.cdt.debug.core.memory.transport.FileExport;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.MemoryByte;

public final class RAWBinaryExport
extends FileExport {
    public RAWBinaryExport(File input, ExportRequest request) {
        super(input, request);
    }

    @Override
    protected BigInteger chunkSize() {
        return BigInteger.valueOf(1024L);
    }

    @Override
    protected void transfer(OutputStream output, BigInteger factor, IProgressMonitor monitor) throws IOException, DebugException {
        BigInteger transferAddress = this.start;
        BigInteger jobCount = BigInteger.ZERO;
        BigInteger chunkSize = this.chunkSize();
        while (transferAddress.compareTo(this.end) < 0 && !monitor.isCanceled()) {
            MemoryByte[] byteValues;
            BigInteger length = chunkSize;
            if (this.end.subtract(transferAddress).compareTo(length) < 0) {
                length = this.end.subtract(transferAddress);
            }
            monitor.subTask(this.transferring(length, transferAddress));
            MemoryByte[] memoryByteArray = byteValues = this.read.from(transferAddress, length.longValue() / this.addressable.longValue());
            int n = byteValues.length;
            int n2 = 0;
            while (n2 < n) {
                MemoryByte memoryByte = memoryByteArray[n2];
                output.write(memoryByte.getValue());
                ++n2;
            }
            transferAddress = transferAddress.add(length);
            if ((jobCount = jobCount.add(BigInteger.ONE)).compareTo(factor) != 0) continue;
            jobCount = BigInteger.ZERO;
            monitor.worked(1);
        }
    }
}

