/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.gdb.internal.ui.tracepoints;

import java.text.Collator;
import java.util.Locale;
import org.eclipse.cdt.dsf.gdb.internal.ui.tracepoints.TraceControlView;
import org.eclipse.cdt.dsf.gdb.internal.ui.tracepoints.TracepointsMessages;
import org.eclipse.cdt.dsf.gdb.service.IGDBTraceControl;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ResourceLocator;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public final class TraceVarDetailsDialog
extends Dialog {
    private Button createButton = null;
    private Button refreshButton = null;
    private Table table = null;
    private TraceControlView fView = null;
    private Text nameInput = null;
    private Text valueInput = null;
    private Image warningImage = null;
    private Label warningIconLabel = null;
    private Label warningTextLabel = null;

    public TraceVarDetailsDialog(Shell shell, TraceControlView view) {
        super(shell);
        this.setShellStyle(this.getShellStyle() | 0x10 | 0x400);
        this.fView = view;
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText(TracepointsMessages.TraceControlView_trace_variable_details_dialog_title);
        Composite composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(1, false);
        composite.setLayout((Layout)gridLayout);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite tableComposite = new Composite(composite, 0);
        gridLayout = new GridLayout(1, false);
        tableComposite.setLayout((Layout)gridLayout);
        tableComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.table = new Table(tableComposite, 34816);
        GridData gridData = new GridData(4, 4, true, true);
        gridData.heightHint = 6 * this.table.getItemHeight();
        this.table.setLayoutData((Object)gridData);
        this.table.setLinesVisible(true);
        this.table.setHeaderVisible(true);
        TableColumn nameTableColumn = new TableColumn(this.table, 0);
        nameTableColumn.setWidth(150);
        nameTableColumn.setText(TracepointsMessages.TraceControlView_trace_variable_details_column_name);
        nameTableColumn.setAlignment(16384);
        TableColumn initValTableColumn = new TableColumn(this.table, 0);
        initValTableColumn.setWidth(120);
        initValTableColumn.setText(TracepointsMessages.TraceControlView_trace_variable_details_column_init_value);
        initValTableColumn.setAlignment(131072);
        TableColumn currentValTableColumn = new TableColumn(this.table, 0);
        currentValTableColumn.setWidth(120);
        currentValTableColumn.setText(TracepointsMessages.TraceControlView_trace_variable_details_column_curr_value);
        currentValTableColumn.setAlignment(131072);
        this.refreshButton = new Button(tableComposite, 0);
        this.refreshButton.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 2, 1));
        this.refreshButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TraceVarDetailsDialog.this.handleRefresh();
            }
        });
        this.refreshButton.setText(TracepointsMessages.TraceControlView_trace_variable_details_refresh_button);
        this.refreshButton.setEnabled(true);
        Label separator = new Label(composite, 258);
        separator.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Composite createComposite = new Composite(composite, 0);
        gridLayout = new GridLayout(1, false);
        createComposite.setLayout((Layout)gridLayout);
        createComposite.setLayoutData((Object)new GridData(4, 4, true, false));
        Composite inputComposite = new Composite(createComposite, 0);
        gridLayout = new GridLayout(2, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        inputComposite.setLayout((Layout)gridLayout);
        inputComposite.setLayoutData((Object)new GridData(4, 4, true, false));
        Label nameLabel = new Label(inputComposite, 0);
        nameLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        nameLabel.setText(TracepointsMessages.TraceControlView_trace_variable_details_name_label);
        this.nameInput = new Text(inputComposite, 2048);
        this.nameInput.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Label valueLabel = new Label(inputComposite, 0);
        valueLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        valueLabel.setText(TracepointsMessages.TraceControlView_trace_variable_details_value_label);
        this.valueInput = new Text(inputComposite, 2048);
        this.valueInput.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Composite createButtonComposite = new Composite(createComposite, 0);
        gridLayout = new GridLayout(3, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        createButtonComposite.setLayout((Layout)gridLayout);
        createButtonComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.createButton = new Button(createButtonComposite, 0);
        this.createButton.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.createButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TraceVarDetailsDialog.this.handleCreate();
            }
        });
        this.createButton.setText(TracepointsMessages.TraceControlView_trace_variable_details_create_button);
        this.createButton.setEnabled(true);
        this.warningIconLabel = new Label(createButtonComposite, 0);
        this.warningIconLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.warningImage = ((ImageDescriptor)ResourceLocator.imageDescriptorFromBundle((String)"org.eclipse.cdt.dsf.gdb.ui", (String)"icons/full/obj16/warning.gif").get()).createImage();
        this.warningIconLabel.setImage(this.warningImage);
        this.warningIconLabel.setVisible(false);
        this.warningTextLabel = new Label(createButtonComposite, 0);
        this.warningTextLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        parent.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (TraceVarDetailsDialog.this.warningImage != null) {
                    TraceVarDetailsDialog.this.warningImage.dispose();
                }
            }
        });
        FocusListener clearWarningFocusListener = new FocusListener(){

            public void focusGained(FocusEvent e) {
                TraceVarDetailsDialog.this.getShell().setDefaultButton(TraceVarDetailsDialog.this.createButton);
            }

            public void focusLost(FocusEvent e) {
            }
        };
        this.nameInput.addFocusListener(clearWarningFocusListener);
        this.valueInput.addFocusListener(clearWarningFocusListener);
        ModifyListener clearWarningListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TraceVarDetailsDialog.this.setWarningVisible(false);
            }
        };
        this.nameInput.addModifyListener(clearWarningListener);
        this.valueInput.addModifyListener(clearWarningListener);
        this.resetInputFields();
        this.handleRefresh();
        return composite;
    }

    public void setWarningVisible(boolean visible) {
        if (this.warningIconLabel == null) {
            return;
        }
        this.warningIconLabel.setVisible(visible);
        if (!visible && this.warningTextLabel != null) {
            this.warningTextLabel.setText("");
        }
    }

    public void setWarningVisible(String message) {
        if (this.warningIconLabel == null || this.warningTextLabel == null) {
            return;
        }
        this.warningTextLabel.setText(message);
        this.warningIconLabel.setVisible(true);
        this.nameInput.setFocus();
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 12, IDialogConstants.CLOSE_LABEL, true);
    }

    protected void buttonPressed(int buttonId) {
        if (12 == buttonId) {
            this.close();
        }
    }

    protected void handleRefresh() {
        IGDBTraceControl.ITraceVariableDMData[] vars = this.fView.fTraceControlModel.getTraceVarList();
        if (vars == null) {
            this.setWarningVisible(TracepointsMessages.TraceControlView_refresh_variable_error);
            this.createButton.setEnabled(false);
            return;
        }
        this.setWarningVisible(false);
        this.createButton.setEnabled(true);
        this.table.removeAll();
        IGDBTraceControl.ITraceVariableDMData[] iTraceVariableDMDataArray = vars;
        int n = vars.length;
        int n2 = 0;
        while (n2 < n) {
            IGDBTraceControl.ITraceVariableDMData var = iTraceVariableDMDataArray[n2];
            String currentVal = var.getValue();
            if (currentVal == null) {
                currentVal = "";
            }
            this.addTableItem(var.getName(), var.getInitialValue(), currentVal);
            ++n2;
        }
    }

    private void addTableItem(String name, String initVal, String currentVal) {
        int index = -1;
        TableItem[] items = this.table.getItems();
        Collator collator = Collator.getInstance(Locale.getDefault());
        int i = 0;
        while (i < items.length) {
            String rowName = items[i].getText(0);
            if (collator.compare(name, rowName) < 0) {
                index = i;
                break;
            }
            ++i;
        }
        if (index == -1) {
            index = items.length;
        }
        TableItem tableItem = new TableItem(this.table, 0, index);
        tableItem.setText(0, name);
        tableItem.setText(1, initVal);
        tableItem.setText(2, currentVal);
    }

    protected void resetInputFields() {
        this.nameInput.setText("");
        this.valueInput.setText("0");
    }

    protected void handleCreate() {
        String name = this.nameInput.getText();
        if (name != null && !name.isEmpty()) {
            String value = this.valueInput.getText();
            if (value != null && value.length() == 0) {
                value = null;
            }
            try {
                this.fView.fTraceControlModel.createVariable(name, value);
                this.resetInputFields();
                this.nameInput.setFocus();
                this.handleRefresh();
            }
            catch (TraceControlView.FailedTraceVariableCreationException e) {
                this.setWarningVisible(e.getMessage());
            }
        } else {
            this.setWarningVisible(TracepointsMessages.TraceControlView_create_variable_empty_name_error);
        }
    }
}

