/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ast.ASTTypeUtil;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IProblemBinding;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.ITypedef;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassSpecialization;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateArgument;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateDefinition;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateInstance;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateParameterMap;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPClassSpecialization;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPClassSpecializationScope;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPTemplates;

public class CPPClassInstance
extends CPPClassSpecialization
implements ICPPTemplateInstance {
    private final ICPPTemplateArgument[] arguments;

    public CPPClassInstance(ICPPClassType orig, IBinding owner, ICPPTemplateParameterMap argMap, ICPPTemplateArgument[] args) {
        super(orig, owner, argMap);
        this.arguments = args;
    }

    @Override
    public ICPPTemplateDefinition getTemplateDefinition() {
        return (ICPPTemplateDefinition)((Object)this.getSpecializedBinding());
    }

    @Override
    public ICPPTemplateArgument[] getTemplateArguments() {
        return this.arguments;
    }

    @Override
    protected ICPPClassSpecializationScope getSpecializationScope() {
        this.checkForDefinition();
        if (this.getDefinition() != null) {
            return null;
        }
        return super.getSpecializationScope();
    }

    @Override
    public boolean isExplicitSpecialization() {
        this.checkForDefinition();
        if (this.getDefinition() != null) {
            return true;
        }
        IASTNode[] decls = this.getDeclarations();
        return decls != null && decls.length > 0 && decls[0] != null;
    }

    @Override
    public String toString() {
        return String.valueOf(this.getName()) + " " + ASTTypeUtil.getArgumentListString(this.arguments, true);
    }

    public boolean equals(Object obj) {
        return obj instanceof ICPPClassType && this.isSameType((ICPPClassType)obj);
    }

    @Override
    public boolean isSameType(IType type) {
        if (type == this) {
            return true;
        }
        if (type instanceof ITypedef) {
            return type.isSameType(this);
        }
        return CPPClassInstance.isSameClassInstance(this, type);
    }

    public static boolean isSameClassInstance(ICPPClassSpecialization classInstance, IType type) {
        ICPPClassType orig2;
        assert (classInstance instanceof ICPPTemplateInstance);
        if (!(type instanceof ICPPClassSpecialization) || !(type instanceof ICPPTemplateInstance) || type instanceof IProblemBinding) {
            return false;
        }
        ICPPClassSpecialization classSpec2 = (ICPPClassSpecialization)type;
        ICPPClassType orig1 = classInstance.getSpecializedBinding();
        if (!orig1.isSameType(orig2 = classSpec2.getSpecializedBinding())) {
            return false;
        }
        return CPPTemplates.haveSameArguments((ICPPTemplateInstance)((Object)classInstance), (ICPPTemplateInstance)((Object)type));
    }
}

