/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.index;

import org.eclipse.cdt.core.index.IIndexFileLocation;
import org.eclipse.cdt.core.parser.ISignificantMacros;

public class FileContentKey {
    private final int linkageID;
    private final IIndexFileLocation location;
    private final ISignificantMacros significantMacros;

    public FileContentKey(int linkageID, IIndexFileLocation location, ISignificantMacros sigMacros) {
        this.linkageID = linkageID;
        this.location = location;
        this.significantMacros = sigMacros;
    }

    public int getLinkageID() {
        return this.linkageID;
    }

    public IIndexFileLocation getLocation() {
        return this.location;
    }

    public ISignificantMacros getSignificantMacros() {
        return this.significantMacros;
    }

    public int hashCode() {
        return (this.linkageID + this.location.hashCode() * 31) * 31 + this.significantMacros.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FileContentKey other = (FileContentKey)obj;
        if (this.linkageID != other.linkageID) {
            return false;
        }
        if (!this.location.equals(other.location)) {
            return false;
        }
        return this.significantMacros.equals(other.significantMacros);
    }

    public String toString() {
        return String.valueOf(this.linkageID) + ": " + this.location.getURI().toString() + "[" + this.significantMacros.hashCode() + "]";
    }
}

